/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.CertificateParser;
import io.apigee.trireme.core.internal.SSLCiphers;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.SecureContextImpl;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ScriptableObject {
    private static final Logger log = LoggerFactory.getLogger((String)ConnectionImpl.class.getName());
    private static final AtomicInteger lastId = new AtomicInteger();
    public static final String CLASS_NAME = "Connection";
    protected static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private final ArrayDeque<QueuedChunk> outgoingChunks = new ArrayDeque();
    private final ArrayDeque<QueuedChunk> incomingChunks = new ArrayDeque();
    private final int id = lastId.incrementAndGet();
    private ScriptRunner runtime;
    private boolean isServer;
    private boolean requestCert;
    private boolean rejectUnauthorized;
    private String serverName;
    private int serverPort;
    SecureContextImpl context;
    private SSLEngine engine;
    private ByteBuffer readBuf;
    private ByteBuffer writeBuf;
    private boolean handshaking;
    private boolean initFinished;
    private boolean sentShutdown;
    private boolean receivedShutdown;
    private Function onHandshakeStart;
    private Function onHandshakeDone;
    private Function onWrap;
    private Function onUnwrap;
    private Function onError;
    private Scriptable verifyError;
    private Scriptable error;

    public ConnectionImpl() {
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSConstructor
    public static Object construct(Context cx, Object[] args, Function ctor, boolean inNew) {
        if (!inNew) {
            return cx.newObject((Scriptable)ctor, CLASS_NAME, args);
        }
        SecureContextImpl ctxImpl = ArgUtils.objArg(args, 0, SecureContextImpl.class, true);
        boolean isServer = ArgUtils.booleanArg(args, 1);
        boolean requestCert = false;
        String serverName = null;
        if (isServer) {
            requestCert = ArgUtils.booleanArg(args, 2, false);
        } else {
            serverName = ArgUtils.stringArg(args, 2, null);
        }
        boolean rejectUnauthorized = ArgUtils.booleanArg(args, 3, false);
        int port = ArgUtils.intArg(args, 4, -1);
        ConnectionImpl conn = new ConnectionImpl(isServer, requestCert, rejectUnauthorized, serverName, port);
        conn.context = ctxImpl;
        if (log.isDebugEnabled()) {
            log.debug("Initializing Connection {}: isServer = {} requestCert = {} rejectUnauthorized = {}", new Object[]{conn.id, isServer, requestCert, rejectUnauthorized});
        }
        conn.runtime = (ScriptRunner)cx.getThreadLocal((Object)"runner");
        return conn;
    }

    private ConnectionImpl(boolean serverMode, boolean requestCert, boolean rejectUnauth, String serverName, int port) {
        this.isServer = serverMode;
        this.requestCert = requestCert;
        this.rejectUnauthorized = rejectUnauth;
        this.serverName = serverName;
        this.serverPort = port;
    }

    @JSFunction
    public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        SSLContext ctx = self.context.makeContext(cx, (Scriptable)self);
        self.engine = !self.isServer && self.serverName != null ? ctx.createSSLEngine(self.serverName, self.serverPort) : ctx.createSSLEngine();
        self.engine.setUseClientMode(!self.isServer);
        if (self.requestCert) {
            if (self.rejectUnauthorized) {
                self.engine.setNeedClientAuth(true);
            } else {
                self.engine.setWantClientAuth(true);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Created SSLEngine {}", (Object)self.engine);
        }
        if (self.context.getCipherSuites() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Setting cipher suites {}", (Object[])self.context.getCipherSuites());
                }
                self.engine.setEnabledCipherSuites(self.context.getCipherSuites());
            }
            catch (IllegalArgumentException iae) {
                self.handleError(cx, new SSLException(iae));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Allocating read and write buffers of size {}", (Object)self.engine.getSession().getPacketBufferSize());
        }
        self.readBuf = ByteBuffer.allocate(self.engine.getSession().getPacketBufferSize());
        self.writeBuf = ByteBuffer.allocate(self.engine.getSession().getPacketBufferSize());
    }

    @JSFunction
    public static int start(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        if (!self.isServer) {
            self.outgoingChunks.add(new QueuedChunk(null, null));
            self.encodeLoop(cx);
        }
        return 0;
    }

    @JSSetter(value="onhandshakestart")
    public void setHandshakeStart(Function f) {
        this.onHandshakeStart = f;
    }

    @JSGetter(value="onhandshakestart")
    public Function getHandshakeStart() {
        return this.onHandshakeStart;
    }

    @JSSetter(value="onhandshakedone")
    public void setHandshakeDone(Function f) {
        this.onHandshakeDone = f;
    }

    @JSGetter(value="onhandshakedone")
    public Function getHandshakeDone() {
        return this.onHandshakeDone;
    }

    @JSSetter(value="onwrap")
    public void setOnWrap(Function f) {
        this.onWrap = f;
    }

    @JSGetter(value="onwrap")
    public Function getOnWrap() {
        return this.onWrap;
    }

    @JSSetter(value="onunwrap")
    public void setOnUnwrap(Function f) {
        this.onUnwrap = f;
    }

    @JSGetter(value="onunwrap")
    public Function getOnUnwrap() {
        return this.onUnwrap;
    }

    @JSSetter(value="onerror")
    public void setOnError(Function f) {
        this.onError = f;
    }

    @JSGetter(value="onerror")
    public Function getOnError() {
        return this.onError;
    }

    @JSGetter(value="error")
    public Scriptable getError() {
        return this.error;
    }

    @JSGetter(value="sentShutdown")
    public boolean isSentShutdown() {
        return this.sentShutdown;
    }

    @JSGetter(value="receivedShutdown")
    public boolean isReceivedShutdown() {
        return this.receivedShutdown;
    }

    @JSFunction
    public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void wrap(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        Function cb = ArgUtils.functionArg(args, 1, true);
        ConnectionImpl self = (ConnectionImpl)thisObj;
        ByteBuffer bb = buf.getBuffer();
        self.outgoingChunks.add(new QueuedChunk(bb, cb));
        self.encodeLoop(cx);
    }

    @JSFunction
    public static void shutdown(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Function cb = ArgUtils.functionArg(args, 0, false);
        ConnectionImpl self = (ConnectionImpl)thisObj;
        QueuedChunk qc = new QueuedChunk(null, cb);
        qc.shutdown = true;
        self.outgoingChunks.add(qc);
        self.encodeLoop(cx);
    }

    @JSFunction
    public static void shutdownInbound(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self;
        Function cb;
        block3: {
            cb = ArgUtils.functionArg(args, 0, false);
            self = (ConnectionImpl)thisObj;
            try {
                self.engine.closeInbound();
            }
            catch (SSLException ssle) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error closing inbound SSLEngine: {}", (Throwable)ssle);
            }
        }
        if (cb != null) {
            cb.call(cx, thisObj, thisObj, ScriptRuntime.emptyArgs);
        }
        self.doUnwrap(cx);
        self.encodeLoop(cx);
    }

    @JSFunction
    public static void unwrap(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        Function cb = ArgUtils.functionArg(args, 1, true);
        ConnectionImpl self = (ConnectionImpl)thisObj;
        ByteBuffer bb = buf.getBuffer();
        self.incomingChunks.add(new QueuedChunk(bb, cb));
        self.encodeLoop(cx);
    }

    protected void encodeLoop(Context cx) {
        block6: while (true) {
            if (log.isTraceEnabled()) {
                log.trace("engine {} status: {} incoming: {} outgoing: {}", new Object[]{this.id, this.engine.getHandshakeStatus(), this.incomingChunks.size(), this.outgoingChunks.size()});
            }
            switch (this.engine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    this.processHandshaking(cx);
                    if (this.doWrap(cx)) break;
                    return;
                }
                case NEED_UNWRAP: {
                    this.processHandshaking(cx);
                    if (this.doUnwrap(cx)) break;
                    return;
                }
                case NEED_TASK: {
                    this.processTasks();
                    return;
                }
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    if (this.outgoingChunks.isEmpty() && this.incomingChunks.isEmpty()) {
                        return;
                    }
                    if (!this.outgoingChunks.isEmpty() && !this.doWrap(cx)) {
                        return;
                    }
                    if (this.incomingChunks.isEmpty() || this.doUnwrap(cx)) continue block6;
                    return;
                }
            }
        }
    }

    private boolean doWrap(Context cx) {
        SSLEngineResult result;
        ByteBuffer bb;
        QueuedChunk qc = this.outgoingChunks.peek();
        ByteBuffer byteBuffer = bb = qc == null ? EMPTY : qc.buf;
        if (bb == null) {
            bb = EMPTY;
        }
        boolean wasShutdown = false;
        do {
            if (qc != null && qc.shutdown) {
                log.trace("Sending closeOutbound");
                this.engine.closeOutbound();
                this.sentShutdown = true;
                wasShutdown = true;
            }
            if (log.isTraceEnabled()) {
                log.trace("{} Wrapping {}", (Object)this.id, (Object)bb);
            }
            try {
                result = this.engine.wrap(bb, this.writeBuf);
            }
            catch (SSLException ssle) {
                this.handleEncodingError(cx, qc, ssle);
                if (qc != null) {
                    this.outgoingChunks.remove();
                }
                return false;
            }
            if (log.isTraceEnabled()) {
                log.trace("wrap result: {}", (Object)result);
            }
            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.writeBuf = Utils.doubleBuffer(this.writeBuf);
        } while (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
        Function writeCallback = null;
        if (qc != null && !bb.hasRemaining() && this.initFinished) {
            this.outgoingChunks.remove();
            if (qc.callback != null) {
                writeCallback = qc.callback;
                qc.callback = null;
            }
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.processNotHandshaking(cx);
        }
        if (result.bytesProduced() > 0) {
            this.deliverWriteBuffer(cx, wasShutdown, writeCallback);
        } else if (writeCallback != null) {
            writeCallback.call(cx, (Scriptable)this, (Scriptable)this, ScriptRuntime.emptyArgs);
        }
        return result.getStatus() == SSLEngineResult.Status.OK;
    }

    private void deliverWriteBuffer(Context cx, boolean shutdown, Function writeCallback) {
        if (this.onWrap != null) {
            this.writeBuf.flip();
            ByteBuffer bb = ByteBuffer.allocate(this.writeBuf.remaining());
            bb.put(this.writeBuf);
            this.writeBuf.clear();
            bb.flip();
            if (log.isTraceEnabled()) {
                log.trace("Delivering {} bytes to the onwrap callback. shutdown = {}", (Object)bb.remaining(), (Object)shutdown);
            }
            Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, bb, false);
            this.runtime.enqueueCallback(this.onWrap, (Scriptable)this, (Scriptable)this, new Object[]{buf, shutdown, writeCallback});
        } else {
            this.writeBuf.clear();
            if (writeCallback != null) {
                writeCallback.call(cx, (Scriptable)this, (Scriptable)this, ScriptRuntime.emptyArgs);
            }
        }
    }

    private boolean doUnwrap(Context cx) {
        SSLEngineResult result;
        QueuedChunk qc;
        block10: {
            ByteBuffer bb;
            qc = this.incomingChunks.peek();
            ByteBuffer byteBuffer = bb = qc == null ? EMPTY : qc.buf;
            while (true) {
                if (log.isTraceEnabled()) {
                    log.trace("{} Unwrapping {}", (Object)this.id, (Object)bb);
                }
                try {
                    result = this.engine.unwrap(bb, this.readBuf);
                }
                catch (SSLException ssle) {
                    this.handleEncodingError(cx, qc, ssle);
                    return false;
                }
                if (log.isTraceEnabled()) {
                    log.trace("unwrap result: {}", (Object)result);
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.readBuf = Utils.doubleBuffer(this.readBuf);
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW || qc == null) break block10;
                qc.deliverCallback(cx, (Scriptable)this);
                if (this.incomingChunks.size() < 2) break;
                QueuedChunk c1 = this.incomingChunks.poll();
                qc = this.incomingChunks.peek();
                bb = qc.buf = Utils.catBuffers(c1.buf, qc.buf);
            }
            qc = this.incomingChunks.peek();
        }
        boolean deliverShutdown = false;
        if (result.getStatus() == SSLEngineResult.Status.CLOSED && !this.receivedShutdown) {
            this.receivedShutdown = true;
            deliverShutdown = true;
        }
        if (qc != null && !qc.buf.hasRemaining()) {
            this.incomingChunks.poll();
            qc.deliverCallback(cx, (Scriptable)this);
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.processNotHandshaking(cx);
        }
        if (result.bytesProduced() > 0 || deliverShutdown) {
            this.deliverReadBuffer(cx, deliverShutdown);
        }
        return result.getStatus() == SSLEngineResult.Status.OK;
    }

    private void deliverReadBuffer(Context cx, boolean shutdown) {
        if (this.onUnwrap != null) {
            this.readBuf.flip();
            ByteBuffer bb = ByteBuffer.allocate(this.readBuf.remaining());
            bb.put(this.readBuf);
            bb.flip();
            this.readBuf.clear();
            if (log.isTraceEnabled()) {
                log.trace("Delivering {} bytes to the onunwrap callback. shutdown = {}", (Object)bb.remaining(), (Object)shutdown);
            }
            Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, bb, false);
            this.runtime.enqueueCallback(this.onUnwrap, (Scriptable)this, (Scriptable)this, new Object[]{buf, shutdown});
        } else {
            this.readBuf.clear();
        }
    }

    private void handleEncodingError(Context cx, QueuedChunk qc, SSLException ssle) {
        Scriptable err;
        if (log.isDebugEnabled()) {
            log.debug("SSL exception: {}", (Object)ssle, (Object)ssle);
        }
        Throwable cause = ssle;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        this.error = err = Utils.makeErrorObject(cx, (Scriptable)this, cause.toString());
        if (!this.initFinished) {
            this.verifyError = err;
            if (this.onError != null) {
                this.onError.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{err});
            }
        } else if (qc != null) {
            qc.deliverCallback(cx, (Scriptable)this, err);
        } else if (this.onError != null) {
            this.onError.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{err});
        }
    }

    private void processHandshaking(Context cx) {
        if (!(this.handshaking || this.sentShutdown || this.receivedShutdown)) {
            this.handshaking = true;
            if (this.onHandshakeStart != null) {
                this.onHandshakeStart.call(cx, (Scriptable)this.onHandshakeStart, (Scriptable)this, ScriptRuntime.emptyArgs);
            }
        }
    }

    private void processNotHandshaking(Context cx) {
        if (this.handshaking) {
            this.checkPeerAuthorization(cx);
            this.handshaking = false;
            this.initFinished = true;
            if (this.onHandshakeDone != null) {
                this.onHandshakeDone.call(cx, (Scriptable)this.onHandshakeDone, (Scriptable)this, ScriptRuntime.emptyArgs);
            }
        }
    }

    private void checkPeerAuthorization(Context cx) {
        Certificate[] certChain;
        try {
            certChain = this.engine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException unver) {
            if (log.isDebugEnabled()) {
                log.debug("Peer is unverified");
            }
            if (!this.isServer || this.requestCert) {
                this.handleError(cx, unver);
            }
            return;
        }
        if (certChain == null) {
            if (log.isDebugEnabled()) {
                log.debug("Peer has no client- or server-side certs");
            }
            if (!this.isServer || this.requestCert) {
                this.handleError(cx, new SSLException("Peer has no certificates"));
            }
            return;
        }
        if (this.context.getTrustManager() == null) {
            this.handleError(cx, new SSLException("No trusted CAs"));
            return;
        }
        try {
            if (this.isServer) {
                this.context.getTrustManager().checkClientTrusted((X509Certificate[])certChain, "RSA");
            } else {
                this.context.getTrustManager().checkServerTrusted((X509Certificate[])certChain, "RSA");
            }
            if (log.isDebugEnabled()) {
                log.debug("SSL peer {} is valid", (Object)this.engine.getSession());
            }
        }
        catch (CertificateException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error verifying SSL peer {}: {}", (Object)this.engine.getSession(), (Object)e);
            }
            this.handleError(cx, new SSLException(e));
        }
    }

    private void handleError(Context cx, SSLException ssle) {
        if (log.isDebugEnabled()) {
            log.debug("SSL exception: {}", (Object)ssle, (Object)ssle);
        }
        Throwable cause = ssle;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        Scriptable err = Utils.makeErrorObject(cx, (Scriptable)this, cause.toString());
        if (this.handshaking) {
            this.verifyError = err;
        } else {
            this.error = err;
        }
    }

    private void processTasks() {
        this.runtime.getAsyncPool().submit(new Runnable(){

            public void run() {
                Runnable task = ConnectionImpl.this.engine.getDelegatedTask();
                while (task != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(ConnectionImpl.this.id + ": Running SSLEngine task {}", (Object)task);
                    }
                    task.run();
                    task = ConnectionImpl.this.engine.getDelegatedTask();
                }
                ConnectionImpl.this.runtime.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        ConnectionImpl.this.encodeLoop(cx);
                    }
                });
            }
        });
    }

    @JSFunction
    public static Object getPeerCertificate(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Certificate cert;
        ConnectionImpl self = (ConnectionImpl)thisObj;
        if (self.engine == null || self.engine.getSession() == null) {
            return Undefined.instance;
        }
        try {
            cert = self.engine.getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException puve) {
            if (log.isDebugEnabled()) {
                log.debug("getPeerCertificates threw {}", (Throwable)puve);
            }
            cert = null;
        }
        if (!(cert instanceof X509Certificate)) {
            log.debug("Peer certificate is not an X.509 cert");
            return Undefined.instance;
        }
        return CertificateParser.get().parse(cx, (Scriptable)self, (X509Certificate)cert);
    }

    @JSFunction
    public static Object getSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
        return Undefined.instance;
    }

    @JSFunction
    public static void setSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void loadSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static boolean isSessionReused(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        return false;
    }

    @JSFunction
    public static boolean isInitFinished(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        return self.initFinished;
    }

    @JSFunction
    public static Object verifyError(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        if (self.verifyError == null) {
            return Undefined.instance;
        }
        return self.verifyError;
    }

    @JSFunction
    public static Object getCurrentCipher(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ConnectionImpl self = (ConnectionImpl)thisObj;
        if (self.engine == null || self.engine.getSession() == null) {
            return Undefined.instance;
        }
        SSLCiphers.Ciph cipher = SSLCiphers.get().getJavaCipher(self.engine.getSession().getCipherSuite());
        if (cipher == null) {
            return Undefined.instance;
        }
        Scriptable c = cx.newObject((Scriptable)self);
        c.put("name", c, (Object)cipher.getSslName());
        c.put("version", c, (Object)self.engine.getSession().getProtocol());
        c.put("javaCipher", c, (Object)self.engine.getSession().getCipherSuite());
        return c;
    }

    static final class QueuedChunk {
        ByteBuffer buf;
        Function callback;
        boolean shutdown;

        QueuedChunk(ByteBuffer buf, Function callback) {
            this.buf = buf;
            this.callback = callback;
        }

        void deliverCallback(Context cx, Scriptable scope) {
            if (this.callback != null) {
                Function cb = this.callback;
                this.callback = null;
                cb.call(cx, (Scriptable)cb, scope, ScriptRuntime.emptyArgs);
            }
        }

        void deliverCallback(Context cx, Scriptable scope, Scriptable err) {
            if (this.callback != null) {
                Function cb = this.callback;
                this.callback = null;
                cb.call(cx, (Scriptable)cb, scope, new Object[]{err});
            }
        }
    }
}

