/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.internal.ScriptRunner;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class Referenceable
extends ScriptableObject {
    private static final int PIN_REQUESTED = 1;
    private static final int PIN_ALLOWED = 2;
    private static final int PINNABLE = 3;
    private int pinState = 2;

    public String getClassName() {
        return "_Referenceable";
    }

    private void updatePinState(int newState) {
        if (this.pinState != 3 && newState == 3) {
            Referenceable.getRunner().pin();
        } else if (this.pinState == 3 && newState != 3) {
            Referenceable.getRunner().unPin();
        }
        this.pinState = newState;
    }

    @JSFunction
    public void ref() {
        Referenceable.clearErrno();
        this.updatePinState(this.pinState | 2);
    }

    @JSFunction
    public void unref() {
        Referenceable.clearErrno();
        this.updatePinState(this.pinState & 0xFFFFFFFD);
    }

    protected void requestPin() {
        this.updatePinState(this.pinState | 1);
    }

    protected void clearPin() {
        this.updatePinState(this.pinState & 0xFFFFFFFE);
    }

    @JSFunction
    public void close() {
        Referenceable.clearErrno();
        this.clearPin();
    }

    protected static void setErrno(String err) {
        Referenceable.getRunner().setErrno(err);
    }

    protected static void clearErrno() {
        Referenceable.getRunner().clearErrno();
    }

    protected static ScriptRunner getRunner(Context cx) {
        return (ScriptRunner)cx.getThreadLocal((Object)"runner");
    }

    protected static ScriptRunner getRunner() {
        return Referenceable.getRunner(Context.getCurrentContext());
    }
}

