/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.SecureContextImpl;
import io.apigee.trireme.net.spi.HttpDataAdapter;
import io.apigee.trireme.net.spi.HttpFuture;
import io.apigee.trireme.net.spi.HttpRequestAdapter;
import io.apigee.trireme.net.spi.HttpResponseAdapter;
import io.apigee.trireme.net.spi.HttpServerAdapter;
import io.apigee.trireme.net.spi.HttpServerContainer;
import io.apigee.trireme.net.spi.HttpServerStub;
import io.apigee.trireme.net.spi.TLSParams;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(HTTPWrap.class);

    public String getModuleName() {
        return "http_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, HttpImpl.class);
        HttpImpl http = (HttpImpl)cx.newObject(scope, "_httpWrapperClass");
        http.init(runner);
        ScriptableObject.defineClass((Scriptable)scope, ServerContainer.class);
        ScriptableObject.defineClass((Scriptable)scope, RequestAdapter.class);
        ScriptableObject.defineClass((Scriptable)scope, ResponseAdapter.class);
        return http;
    }

    public static class ResponseAdapter
    extends ScriptableObject {
        public static final String CLASS_NAME = "_httpResponseAdapterClass";
        private HttpResponseAdapter response;
        private ServerContainer server;
        private Function onWriteComplete;
        private Function onChannelClosed;
        private static final String RFC_1123_FORMAT = "EEE, dd MM yyyy HH:mm:ss zzz";

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(HttpResponseAdapter response, ServerContainer server) {
            this.response = response;
            this.server = server;
        }

        @JSGetter(value="onwritecomplete")
        public Function getOnWriteComplete() {
            return this.onWriteComplete;
        }

        @JSSetter(value="onwritecomplete")
        public void setOnWriteComplete(Function onComplete) {
            this.onWriteComplete = onComplete;
        }

        @JSGetter(value="onchannelclosed")
        public Function getOnChannelClosed() {
            return this.onChannelClosed;
        }

        @JSSetter(value="onchannelclosed")
        public void setOnChannelClosed(Function cc) {
            this.onChannelClosed = cc;
        }

        @JSGetter(value="attachment")
        public Object getAttachment() {
            return this.response.getClientAttachment();
        }

        private ByteBuffer gatherData(Object data, Object encoding) {
            if (data == null || data == Context.getUndefinedValue()) {
                return null;
            }
            if (data instanceof String) {
                if (encoding == null || encoding == Context.getUndefinedValue()) {
                    return Utils.stringToBuffer((String)data, Charsets.get().getCharset("utf8"));
                }
                String encStr = Context.toString((Object)encoding);
                String str = Context.toString((Object)data);
                return Utils.stringToBuffer(str, Charsets.get().resolveCharset(encStr));
            }
            if (data instanceof Buffer.BufferImpl) {
                return ((Buffer.BufferImpl)((Object)data)).getBuffer();
            }
            throw Utils.makeError(Context.getCurrentContext(), (Scriptable)this, "Data must be a String or a Buffer");
        }

        @JSFunction
        public boolean send(int statusCode, boolean sendDate, Scriptable headers, Object data, Object encoding, Scriptable trailers, boolean last) {
            HttpFuture future;
            if (last) {
                this.server.requestComplete(this);
            }
            ByteBuffer buf = this.gatherData(data, encoding);
            this.response.setStatusCode(statusCode);
            boolean hasDate = false;
            if (headers != null) {
                Object value;
                Object name;
                int i = 0;
                do {
                    name = headers.get(i++, headers);
                    value = headers.get(i++, headers);
                    if (name == Scriptable.NOT_FOUND || value == Scriptable.NOT_FOUND) continue;
                    String nameVal = Context.toString((Object)name);
                    if ("Date".equalsIgnoreCase(nameVal)) {
                        hasDate = true;
                    }
                    this.response.addHeader(nameVal, Context.toString((Object)value));
                } while (name != Scriptable.NOT_FOUND && value != Scriptable.NOT_FOUND);
            }
            if (sendDate && !hasDate) {
                this.addDateHeader(this.response);
            }
            if (last) {
                this.addTrailers(trailers, this.response);
                if (buf != null) {
                    this.response.setData(buf);
                }
                future = this.response.send(true);
            } else {
                future = this.response.send(false);
                if (buf != null) {
                    future = this.response.sendChunk(buf, false);
                }
            }
            this.setListener(future);
            return future.isDone();
        }

        @JSFunction
        public boolean sendChunk(Object data, Object encoding, Scriptable trailers, boolean last) {
            if (last) {
                this.server.requestComplete(this);
            }
            ByteBuffer buf = this.gatherData(data, encoding);
            if (last) {
                this.addTrailers(trailers, this.response);
            }
            HttpFuture future = this.response.sendChunk(buf, last);
            this.setListener(future);
            return future.isDone();
        }

        @JSFunction
        public void destroy() {
            this.server.requestComplete(this);
            this.response.destroy();
        }

        @JSFunction
        public void fatalError(String message, Object stack) {
            String stackStr = null;
            if (stack instanceof String && !Context.getUndefinedValue().equals(stack)) {
                stackStr = (String)stack;
            }
            this.response.fatalError(message, stackStr);
        }

        private void addTrailers(Scriptable trailers, HttpResponseAdapter response) {
            if (trailers != null) {
                Object value;
                Object name;
                int i = 0;
                do {
                    name = trailers.get(i++, trailers);
                    value = trailers.get(i++, trailers);
                    if (name == Scriptable.NOT_FOUND || value == Scriptable.NOT_FOUND) continue;
                    response.setTrailer(Context.toString((Object)name), Context.toString((Object)value));
                } while (name != Scriptable.NOT_FOUND && value != Scriptable.NOT_FOUND);
            }
        }

        private void addDateHeader(HttpResponseAdapter response) {
            SimpleDateFormat df = new SimpleDateFormat(RFC_1123_FORMAT);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            String headerVal = df.format(new Date());
            response.addHeader("Date", headerVal);
        }

        private void setListener(HttpFuture future) {
            future.setListener(new HttpFuture.Listener(){

                public void onComplete(final boolean success, final boolean closed, final Throwable cause) {
                    if (log.isDebugEnabled()) {
                        log.debug("Write complete: success = {} closed = {} cause = {}", new Object[]{success, closed, cause});
                    }
                    Scriptable domain = ResponseAdapter.this.server.getRunner().getDomain();
                    ResponseAdapter.this.server.getRunner().enqueueTask(new ScriptTask(){

                        public void execute(Context cx, Scriptable scope) {
                            Scriptable err = null;
                            if (closed) {
                                ResponseAdapter.this.onChannelClosed.call(cx, (Scriptable)ResponseAdapter.this.onChannelClosed, (Scriptable)ResponseAdapter.this, ScriptRuntime.emptyArgs);
                            } else {
                                if (!success) {
                                    err = Utils.makeErrorObject(cx, (Scriptable)ResponseAdapter.this, cause == null ? null : cause.toString());
                                }
                                ResponseAdapter.this.onWriteComplete.call(cx, (Scriptable)ResponseAdapter.this.onWriteComplete, (Scriptable)ResponseAdapter.this, new Object[]{err});
                            }
                        }
                    }, domain);
                }
            });
        }
    }

    public static class RequestAdapter
    extends ScriptableObject {
        public static final String CLASS_NAME = "_httpRequestAdaptorClass";
        private HttpRequestAdapter request;

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(HttpRequestAdapter request) {
            this.request = request;
        }

        @JSGetter(value="attachment")
        public Object getAttachment() {
            return this.request.getClientAttachment();
        }

        @JSGetter(value="requestUrl")
        public String getRequestUrl() {
            return this.request.getUrl();
        }

        @JSGetter(value="requestMajorVersion")
        public int getRequestMajorVersion() {
            return this.request.getMajorVersion();
        }

        @JSGetter(value="requestMinorVersion")
        public int getRequestMinorVersion() {
            return this.request.getMinorVersion();
        }

        @JSGetter(value="requestMethod")
        public String getRequestMethod() {
            return this.request.getMethod();
        }

        @JSFunction
        public static Scriptable getRequestHeaders(Context cx, Scriptable thisObj, Object[] args, Function func) {
            RequestAdapter ar = (RequestAdapter)thisObj;
            ArrayList<String> headers = new ArrayList<String>();
            for (Map.Entry<String, String> hdr : ar.request.getHeaders()) {
                headers.add(hdr.getKey());
                headers.add(hdr.getValue());
            }
            return cx.newArray(thisObj, headers.toArray());
        }

        @JSFunction
        public void pause() {
            this.request.pause();
        }

        @JSFunction
        public void resume() {
            this.request.resume();
        }
    }

    public static class ServerContainer
    extends ScriptableObject
    implements HttpServerStub {
        public static final String CLASS_NAME = "_httpServerWrapperClass";
        private NodeRuntime runner;
        private HttpServerAdapter adapter;
        private Function makeSocket;
        private Function makeRequest;
        private Function makeResponse;
        private Function onHeaders;
        private Function onData;
        private Function onComplete;
        private Function onClose;
        private TLSParams tlsParams;
        private Scriptable timeoutOpts;
        private final IdentityHashMap<ResponseAdapter, ResponseAdapter> pendingRequests = new IdentityHashMap();

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(NodeRuntime runner, HttpServerContainer container) {
            this.runner = runner;
            this.adapter = container.newServer(runner.getScriptObject(), this);
            runner.pin();
        }

        NodeRuntime getRunner() {
            return this.runner;
        }

        @JSFunction
        public static void setSslContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            SecureContextImpl ctx = ArgUtils.objArg(args, 0, SecureContextImpl.class, true);
            boolean rejectUnauthorized = ArgUtils.booleanArg(args, 1, true);
            boolean requestCerts = ArgUtils.booleanArg(args, 2, false);
            ServerContainer self = (ServerContainer)thisObj;
            self.tlsParams = self.makeTLSParams(cx, ctx, rejectUnauthorized, requestCerts);
        }

        @JSFunction
        public int listen(String host, int port, int backlog) {
            this.adapter.listen(host, port, backlog, this.tlsParams);
            log.debug("Listening on port {}", (Object)port);
            return 0;
        }

        @JSFunction
        public void close() {
            log.debug("Closing HTTP server adapter completely");
            if (this.adapter != null) {
                this.adapter.suspend();
                this.adapter.close();
                this.adapter = null;
            }
            this.runner.unPin();
        }

        @JSFunction
        public void fatalError(String message, Object stack) {
            if (log.isDebugEnabled()) {
                log.debug("Caught a top-level script error. Terminating all HTTP requests");
            }
            String stackStr = null;
            if (stack instanceof String && !Context.getUndefinedValue().equals(stack)) {
                stackStr = (String)stack;
            }
            for (ResponseAdapter ar : this.pendingRequests.keySet()) {
                try {
                    ar.fatalError(message, stackStr);
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Error handling a fatal request: {}", t);
                }
            }
            this.pendingRequests.clear();
        }

        void requestComplete(ResponseAdapter ar) {
            this.pendingRequests.remove((Object)ar);
        }

        public void onRequest(final HttpRequestAdapter request, final HttpResponseAdapter response) {
            if (log.isDebugEnabled()) {
                log.debug("Received HTTP onRequest: {} self contained = {}", (Object)request, (Object)request.isSelfContained());
            }
            this.runner.enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    RequestAdapter reqAdapter = (RequestAdapter)cx.newObject((Scriptable)ServerContainer.this, "_httpRequestAdaptorClass");
                    reqAdapter.init(request);
                    ResponseAdapter respAdapter = (ResponseAdapter)cx.newObject((Scriptable)ServerContainer.this, "_httpResponseAdapterClass");
                    respAdapter.init(response, ServerContainer.this);
                    Scriptable socketInfo = ServerContainer.this.makeSocketInfo(cx, request);
                    Scriptable socketObj = (Scriptable)ServerContainer.this.makeSocket.call(cx, (Scriptable)ServerContainer.this.makeSocket, null, new Object[]{socketInfo});
                    Scriptable requestObj = (Scriptable)ServerContainer.this.makeRequest.call(cx, (Scriptable)ServerContainer.this.makeRequest, null, new Object[]{reqAdapter, socketObj});
                    Scriptable responseObj = (Scriptable)ServerContainer.this.makeResponse.call(cx, (Scriptable)ServerContainer.this.makeResponse, null, new Object[]{respAdapter, socketObj, ServerContainer.this.timeoutOpts});
                    request.setScriptObject(requestObj);
                    response.setScriptObject(responseObj);
                    ServerContainer.this.onHeaders.call(cx, (Scriptable)ServerContainer.this.onHeaders, (Scriptable)ServerContainer.this, new Object[]{requestObj, responseObj});
                }
            });
            if (request.isSelfContained()) {
                final ByteBuffer requestData = request.hasData() ? request.getData() : null;
                this.runner.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        ServerContainer.this.callOnData(cx, scope, request, requestData);
                    }
                });
                this.runner.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        ServerContainer.this.callOnComplete(cx, request);
                    }
                });
            }
        }

        public void onData(final HttpRequestAdapter request, HttpResponseAdapter response, HttpDataAdapter data) {
            if (log.isDebugEnabled()) {
                log.debug("Received HTTP onData for {} with {}", (Object)request, (Object)data);
            }
            final ByteBuffer requestData = data.hasData() ? data.getData() : null;
            this.runner.enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    ServerContainer.this.callOnData(cx, scope, request, requestData);
                }
            });
            if (data.isLastChunk()) {
                this.runner.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        ServerContainer.this.callOnComplete(cx, request);
                    }
                });
            }
        }

        private void callOnComplete(Context cx, HttpRequestAdapter request) {
            Scriptable incoming = request.getScriptObject();
            if (log.isDebugEnabled()) {
                log.debug("Calling onComplete with {}", (Object)incoming);
            }
            this.onComplete.call(cx, (Scriptable)this.onComplete, (Scriptable)this, new Object[]{incoming});
        }

        private void callOnData(Context cx, Scriptable scope, HttpRequestAdapter request, ByteBuffer requestData) {
            Scriptable incoming = request.getScriptObject();
            if (log.isDebugEnabled()) {
                log.debug("Calling onData with {}", (Object)incoming);
            }
            Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, scope, requestData, true);
            this.onData.call(cx, (Scriptable)this.onData, (Scriptable)this, new Object[]{incoming, buf});
        }

        public void onConnection() {
        }

        public void onClose(final HttpRequestAdapter request, final HttpResponseAdapter response) {
            if (request != null) {
                this.runner.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        Scriptable reqObject = request.getScriptObject();
                        Object respObject = response != null ? response.getScriptObject() : Context.getUndefinedValue();
                        ServerContainer.this.onClose.call(cx, (Scriptable)ServerContainer.this.onClose, (Scriptable)ServerContainer.this, new Object[]{reqObject, respObject});
                    }
                });
            }
        }

        public void onError(String message) {
            throw Utils.makeError(Context.getCurrentContext(), (Scriptable)this, message);
        }

        public void onError(String message, Throwable cause) {
            if (cause instanceof RhinoException) {
                throw Utils.makeError(Context.getCurrentContext(), (Scriptable)this, message, (RhinoException)cause);
            }
            throw Utils.makeError(Context.getCurrentContext(), (Scriptable)this, cause.getMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDefaultTimeout(long timeout, TimeUnit unit, int statusCode, String contentType, String message) {
            if (timeout <= 0L) {
                this.timeoutOpts = null;
                return;
            }
            Context cx = Context.enter();
            try {
                this.timeoutOpts = cx.newObject((Scriptable)this);
                this.timeoutOpts.put("timeout", this.timeoutOpts, (Object)unit.toMillis(timeout));
                this.timeoutOpts.put("statusCode", this.timeoutOpts, (Object)statusCode);
                this.timeoutOpts.put("contentType", this.timeoutOpts, (Object)contentType);
                this.timeoutOpts.put("message", this.timeoutOpts, (Object)message);
            }
            finally {
                Context.exit();
            }
        }

        @JSGetter(value="makeSocket")
        public Function getMakeSocket() {
            return this.makeSocket;
        }

        @JSSetter(value="makeSocket")
        public void setMakeSocket(Function mr) {
            this.makeSocket = mr;
        }

        @JSGetter(value="makeRequest")
        public Function getMakeRequest() {
            return this.makeRequest;
        }

        @JSSetter(value="makeRequest")
        public void setMakeRequest(Function mr) {
            this.makeRequest = mr;
        }

        @JSGetter(value="makeResponse")
        public Function getMakeResponse() {
            return this.makeResponse;
        }

        @JSSetter(value="makeResponse")
        public void setMakeResponse(Function mr) {
            this.makeResponse = mr;
        }

        @JSGetter(value="onheaders")
        public Function getOnHeaders() {
            return this.onHeaders;
        }

        @JSSetter(value="onheaders")
        public void setOnHeaders(Function onHeaders) {
            this.onHeaders = onHeaders;
        }

        @JSGetter(value="ondata")
        public Function getOnData() {
            return this.onData;
        }

        @JSSetter(value="ondata")
        public void setOnData(Function onData) {
            this.onData = onData;
        }

        @JSGetter(value="oncomplete")
        public Function getOnComplete() {
            return this.onComplete;
        }

        @JSSetter(value="oncomplete")
        public void setOnComplete(Function onComplete) {
            this.onComplete = onComplete;
        }

        @JSGetter(value="onclose")
        public Function getOnClose() {
            return this.onClose;
        }

        @JSSetter(value="onclose")
        public void setOnClose(Function oc) {
            this.onClose = oc;
        }

        private TLSParams makeTLSParams(Context cx, SecureContextImpl sc, boolean rejectUnauthorized, boolean requestCert) {
            SSLContext ctx = sc.makeContext(cx, (Scriptable)this);
            TLSParams t = new TLSParams();
            t.setContext(ctx);
            if (sc.getCipherSuites() != null) {
                t.setCiphers(sc.getCipherSuites());
            }
            if (requestCert) {
                if (rejectUnauthorized) {
                    t.setClientAuthRequired(true);
                } else {
                    t.setClientAuthRequested(true);
                }
            }
            return t;
        }

        private Scriptable makeSocketInfo(Context cx, HttpRequestAdapter request) {
            Scriptable i = cx.newObject((Scriptable)this);
            i.put("remoteAddress", i, (Object)request.getRemoteAddress());
            i.put("remotePort", i, (Object)request.getRemotePort());
            i.put("localAddress", i, (Object)request.getLocalAddress());
            i.put("localPort", i, (Object)request.getLocalPort());
            i.put("localFamily", i, (Object)(request.isLocalIPv6() ? "IPv6" : "IPv4"));
            return i;
        }
    }

    public static class HttpImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_httpWrapperClass";
        private NodeRuntime runner;

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(NodeRuntime runner) {
            this.runner = runner;
        }

        @JSFunction
        public boolean hasServerAdapter() {
            return this.runner.getEnvironment().getHttpContainer() != null;
        }

        @JSFunction
        public static Scriptable createServerAdapter(Context cx, Scriptable thisObj, Object[] args, Function fn) {
            HttpImpl http = (HttpImpl)thisObj;
            ServerContainer container = (ServerContainer)cx.newObject(thisObj, "_httpServerWrapperClass");
            container.init(http.runner, http.runner.getEnvironment().getHttpContainer());
            return container;
        }
    }
}

