/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.AbstractFilesystem;
import io.apigee.trireme.core.modules.Buffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filesystem
implements InternalNodeModule {
    private static final Logger log = LoggerFactory.getLogger(Filesystem.class);

    public String getModuleName() {
        return "fs";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, FSImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)scope, StatsImpl.class, (boolean)false, (boolean)true);
        FSImpl fs = (FSImpl)cx.newObject(scope, "_fsClass");
        fs.initialize(runner, runner.getAsyncPool());
        ScriptableObject.defineClass((Scriptable)fs, StatsImpl.class, (boolean)false, (boolean)true);
        return fs;
    }

    private static abstract class AsyncAction {
        private AsyncAction() {
        }

        public abstract Object[] execute() throws NodeOSException;

        public Object[] mapException(Context cx, Scriptable scope, NodeOSException e) {
            return new Object[]{Utils.makeErrorObject(cx, scope, e)};
        }

        public Object[] mapSyncException(NodeOSException e) {
            return null;
        }
    }

    public static class FileHandle {
        static final String KEY = "_fileHandle";
        RandomAccessFile file;
        File fileRef;

        FileHandle(File fileRef, RandomAccessFile file) {
            this.fileRef = fileRef;
            this.file = file;
        }
    }

    public static class StatsImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "Stats";

        public String getClassName() {
            return CLASS_NAME;
        }

        public void setAttributes(Context cx, File file) {
            this.put("size", (Scriptable)this, file.length());
            Scriptable modDate = cx.newObject((Scriptable)this, "Date", new Object[]{file.lastModified()});
            this.put("atime", (Scriptable)this, modDate);
            this.put("mtime", (Scriptable)this, modDate);
            this.put("ctime", (Scriptable)this, modDate);
            this.put("dev", (Scriptable)this, 0);
            this.put("uid", (Scriptable)this, 0);
            this.put("gid", (Scriptable)this, 0);
            int mode = 0;
            if (file.isDirectory()) {
                mode |= 0x4000;
            }
            if (file.isFile()) {
                mode |= 0x8000;
            }
            if (file.canRead()) {
                mode |= 0x100;
            }
            if (file.canWrite()) {
                mode |= 0x80;
            }
            if (file.canExecute()) {
                mode |= 0x40;
            }
            this.put("mode", (Scriptable)this, mode);
        }
    }

    public static class FSImpl
    extends AbstractFilesystem {
        public static final String CLASS_NAME = "_fsClass";
        private static final int FIRST_FD = 4;
        protected ScriptRunner runner;
        protected Executor pool;
        private final AtomicInteger nextFd = new AtomicInteger(4);
        private final ConcurrentHashMap<Integer, FileHandle> descriptors = new ConcurrentHashMap();

        public String getClassName() {
            return CLASS_NAME;
        }

        protected void initialize(NodeRuntime runner, Executor fsPool) {
            this.runner = (ScriptRunner)runner;
            this.pool = fsPool;
        }

        public void cleanup() {
            for (FileHandle handle : this.descriptors.values()) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing leaked file descriptor " + handle);
                }
                if (handle.file == null) continue;
                try {
                    handle.file.close();
                }
                catch (IOException iOException) {}
            }
            this.descriptors.clear();
        }

        private Object runAction(final Context cx, final Function callback, final AsyncAction action) {
            if (callback == null) {
                try {
                    Object[] ret = action.execute();
                    if (ret == null || ret.length < 2) {
                        return null;
                    }
                    return ret[1];
                }
                catch (NodeOSException e) {
                    Object[] err;
                    if (log.isDebugEnabled()) {
                        log.debug("I/O exception: {}: {}", (Object)e.getCode(), (Object)e);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace(e.toString(), (Throwable)((Object)e));
                    }
                    if ((err = action.mapSyncException(e)) == null) {
                        throw Utils.makeError(cx, (Scriptable)this, e);
                    }
                    return err[1];
                }
            }
            final FSImpl self = this;
            final Scriptable domain = this.runner.getDomain();
            this.runner.pin();
            this.pool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (log.isTraceEnabled()) {
                        log.trace("Executing async action {}", (Object)action);
                    }
                    try {
                        Object[] args = action.execute();
                        if (args == null) {
                            args = new Object[]{};
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Calling {} with {}", (Object)((BaseFunction)callback).getFunctionName(), (Object)args);
                        }
                        FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, args);
                    }
                    catch (NodeOSException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Async action {} failed: {}: {}", new Object[]{action, e.getCode(), e});
                        }
                        FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, action.mapException(cx, (Scriptable)self, e));
                    }
                    finally {
                        FSImpl.this.runner.unPin();
                    }
                }
            });
            return null;
        }

        private static void checkCall(boolean result, File f, String name) throws IOException {
            if (!result) {
                if (log.isDebugEnabled()) {
                    log.debug("Permission {} failed for {}", (Object)name, (Object)f.getPath());
                }
                throw new IOException(name + " failed for " + f.getPath());
            }
        }

        private File translatePath(String path) throws NodeOSException {
            File trans = this.runner.translatePath(path);
            if (trans == null) {
                throw new NodeOSException("ENOENT");
            }
            return trans;
        }

        private void setMode(File f, int origMode) {
            int mode = origMode & ~this.runner.getProcess().getUmask();
            if ((mode & 4) != 0 || (mode & 0x20) != 0) {
                f.setReadable(true, false);
            } else if ((mode & 0x100) != 0) {
                f.setReadable(true, true);
            } else {
                f.setReadable(false, true);
            }
            if ((mode & 2) != 0 || (mode & 0x10) != 0) {
                f.setWritable(true, false);
            } else if ((mode & 0x80) != 0) {
                f.setWritable(true, true);
            } else {
                f.setWritable(false, true);
            }
            if ((mode & 1) != 0 || (mode & 8) != 0) {
                f.setExecutable(true, false);
            } else if ((mode & 0x40) != 0) {
                f.setExecutable(true, true);
            } else {
                f.setExecutable(false, true);
            }
        }

        private FileHandle ensureHandle(int fd) throws NodeOSException {
            FileHandle handle = this.descriptors.get(fd);
            if (handle == null) {
                if (log.isDebugEnabled()) {
                    log.debug("FD {} is not a valid handle", (Object)fd);
                }
                throw new NodeOSException("EBADF");
            }
            return handle;
        }

        private FileHandle ensureRegularFileHandle(int fd) throws NodeOSException {
            FileHandle h = this.ensureHandle(fd);
            if (h.file == null) {
                if (log.isDebugEnabled()) {
                    log.debug("FD {} is not a valid handle or regular file", (Object)fd);
                }
                throw new NodeOSException("EBADF");
            }
            return h;
        }

        private static Buffer.BufferImpl ensureBuffer(Context cx, Scriptable scope, Object[] args, int pos) {
            ArgUtils.ensureArg(args, pos);
            try {
                return (Buffer.BufferImpl)((Object)args[pos]);
            }
            catch (ClassCastException cce) {
                throw Utils.makeError(cx, scope, "Not a buffer", "EINVAL");
            }
        }

        @JSFunction
        public static Object open(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final String pathStr = ArgUtils.stringArg(args, 0);
            final int flags = ArgUtils.intArg(args, 1);
            final int mode = ArgUtils.intArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doOpen(pathStr, flags, mode);
                }

                public Object[] mapException(Context cx, Scriptable scope, NodeOSException e) {
                    return new Object[]{Utils.makeErrorObject(cx, thisObj, e)};
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doOpen(String pathStr, int flags, int mode) throws NodeOSException {
            if (log.isDebugEnabled()) {
                log.debug("open({}, {}, {})", new Object[]{pathStr, flags, mode});
            }
            File path = this.translatePath(pathStr);
            if ((flags & 0x200) != 0) {
                boolean justCreated;
                try {
                    justCreated = path.createNewFile();
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error in createNewFile: {}", (Object)e, (Object)e);
                    }
                    throw new NodeOSException("EIO", e);
                }
                if (justCreated) {
                    this.setMode(path, mode);
                } else if ((flags & 0x800) != 0) {
                    NodeOSException ne = new NodeOSException("EEXIST");
                    ne.setPath(pathStr);
                    throw ne;
                }
            } else if (!path.exists()) {
                NodeOSException ne = new NodeOSException("ENOENT");
                ne.setPath(pathStr);
                throw ne;
            }
            RandomAccessFile file = null;
            if (path.isFile()) {
                String modeStr = (flags & 2) != 0 ? "rw" : ((flags & 1) != 0 ? "rw" : "r");
                if ((flags & 0x80) != 0) {
                    modeStr = "rws";
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Opening {} with {}", (Object)path.getPath(), (Object)modeStr);
                    }
                    file = new RandomAccessFile(path, modeStr);
                    if ((flags & 0x400) != 0) {
                        file.setLength(0L);
                    } else if ((flags & 8) != 0 && file.length() > 0L) {
                        file.seek(file.length());
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (log.isDebugEnabled()) {
                        log.debug("File not found: {}", (Object)path);
                    }
                    throw new NodeOSException("ENOENT");
                }
                catch (IOException ioe) {
                    if (log.isDebugEnabled()) {
                        log.debug("I/O error: {}", (Object)ioe, (Object)ioe);
                    }
                    throw new NodeOSException("EIO", ioe);
                }
            }
            Context.enter();
            try {
                FileHandle fileHandle = new FileHandle(path, file);
                int fd = this.nextFd.getAndIncrement();
                this.descriptors.put(fd, fileHandle);
                if (log.isDebugEnabled()) {
                    log.debug("Returning FD {}", (Object)fd);
                }
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), fd};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doClose(fd);
                    return null;
                }
            });
        }

        private void doClose(int fd) throws NodeOSException {
            FileHandle handle = this.ensureHandle(fd);
            try {
                if (handle.file != null) {
                    handle.file.close();
                }
                this.descriptors.remove(fd);
            }
            catch (IOException ioe) {
                throw new NodeOSException("EIO", ioe);
            }
        }

        @JSFunction
        public static Object read(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            final Buffer.BufferImpl buf = FSImpl.ensureBuffer(cx, thisObj, args, 1);
            final int off = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 2, 0);
            final int len = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 3, 0);
            final long pos = ArgUtils.longArgOnly(cx, (Scriptable)fs, args, 4, -1L);
            Function callback = ArgUtils.functionArg(args, 5, false);
            if (off >= buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Offset is out of bounds", "EINVAL");
            }
            if (off + len > buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Length extends beyond buffer", "EINVAL");
            }
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doRead(fd, buf, off, len, pos);
                }

                public Object[] mapException(Context cx, Scriptable scope, NodeOSException e) {
                    return new Object[]{Utils.makeErrorObject(cx, thisObj, e), 0, buf};
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doRead(int fd, Buffer.BufferImpl buf, int off, int len, long pos) throws NodeOSException {
            byte[] bytes = buf.getArray();
            int bytesOffset = buf.getArrayOffset() + off;
            FileHandle handle = this.ensureRegularFileHandle(fd);
            try {
                int count;
                FileHandle fileHandle = handle;
                synchronized (fileHandle) {
                    if (pos >= 0L) {
                        handle.file.seek(pos);
                    }
                    count = handle.file.read(bytes, bytesOffset, len);
                }
                if (count < 0) {
                    count = 0;
                }
                if (log.isDebugEnabled()) {
                    log.debug("read({}, {}, {}) = {}", new Object[]{off, len, pos, count});
                }
                return new Object[]{Context.getUndefinedValue(), count, buf};
            }
            catch (IOException ioe) {
                throw new NodeOSException("EIO", ioe);
            }
        }

        @JSFunction
        public static Object write(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            final Buffer.BufferImpl buf = FSImpl.ensureBuffer(cx, thisObj, args, 1);
            final int off = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 2, 0);
            final int len = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 3, 0);
            final long pos = ArgUtils.longArgOnly(cx, (Scriptable)fs, args, 4, 0L);
            Function callback = ArgUtils.functionArg(args, 5, false);
            if (off >= buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Offset is out of bounds", "EINVAL");
            }
            if (off + len > buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Length extends beyond buffer", "EINVAL");
            }
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doWrite(fd, buf, off, len, pos);
                }

                public Object[] mapException(Context cx, Scriptable scope, NodeOSException e) {
                    return new Object[]{Utils.makeErrorObject(cx, thisObj, e), 0, buf};
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doWrite(int fd, Buffer.BufferImpl buf, int off, int len, long pos) throws NodeOSException {
            byte[] bytes = buf.getArray();
            int bytesOffset = buf.getArrayOffset() + off;
            FileHandle handle = this.ensureRegularFileHandle(fd);
            try {
                FileHandle fileHandle = handle;
                synchronized (fileHandle) {
                    if (pos > 0L) {
                        handle.file.seek(pos);
                    }
                    handle.file.write(bytes, bytesOffset, len);
                }
                if (log.isDebugEnabled()) {
                    log.debug("write({}, {}, {})", new Object[]{off, len, pos});
                }
                return new Object[]{Context.getUndefinedValue(), len, buf};
            }
            catch (IOException ioe) {
                throw new NodeOSException("EIO", ioe);
            }
        }

        @JSFunction
        public static void fsync(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doSync(fd);
                    return null;
                }
            });
        }

        private void doSync(int fd) throws NodeOSException {
            FileHandle handle = this.ensureRegularFileHandle(fd);
            try {
                handle.file.getFD().sync();
            }
            catch (IOException ioe) {
                throw new NodeOSException("EIO", ioe);
            }
        }

        @JSFunction
        public static void fdatasync(Context cx, Scriptable thisObj, Object[] args, Function func) {
            FSImpl.fsync(cx, thisObj, args, func);
        }

        @JSFunction
        public static void rename(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String oldPath = ArgUtils.stringArg(args, 0);
            final String newPath = ArgUtils.stringArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl fs = (FSImpl)thisObj;
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doRename(oldPath, newPath);
                    return null;
                }
            });
        }

        private void doRename(String oldPath, String newPath) throws NodeOSException {
            File oldFile = this.translatePath(oldPath);
            if (!oldFile.exists()) {
                NodeOSException ne = new NodeOSException("ENOENT");
                ne.setPath(oldPath);
                throw ne;
            }
            File newFile = this.translatePath(newPath);
            if (newFile.getParentFile() != null && !newFile.getParentFile().exists()) {
                NodeOSException ne = new NodeOSException("ENOENT");
                ne.setPath(newPath);
                throw ne;
            }
            if (!oldFile.renameTo(newFile)) {
                throw new NodeOSException("EIO");
            }
        }

        @JSFunction
        public static void ftruncate(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            final long len = ArgUtils.longArgOnly(cx, (Scriptable)fs, args, 1, 0L);
            Function callback = ArgUtils.functionArg(args, 2, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doTruncate(fd, len);
                    return null;
                }
            });
        }

        private void doTruncate(int fd, long len) throws NodeOSException {
            try {
                FileHandle handle = this.ensureRegularFileHandle(fd);
                handle.file.setLength(len);
            }
            catch (IOException e) {
                throw new NodeOSException("EIO", e);
            }
        }

        @JSFunction
        public static void rmdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doRmdir(path);
                    return null;
                }
            });
        }

        private void doRmdir(String path) throws NodeOSException {
            File file = this.translatePath(path);
            if (!file.exists()) {
                NodeOSException ne = new NodeOSException("ENOENT");
                ne.setPath(path);
                throw ne;
            }
            if (!file.isDirectory()) {
                NodeOSException ne = new NodeOSException("ENOTDIR");
                ne.setPath(path);
                throw ne;
            }
            if (!file.delete()) {
                throw new NodeOSException("EIO");
            }
        }

        @JSFunction
        public static void unlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doUnlink(path);
                    return null;
                }
            });
        }

        private void doUnlink(String path) throws NodeOSException {
            File file = this.translatePath(path);
            if (!file.exists()) {
                NodeOSException ne = new NodeOSException("ENOENT");
                ne.setPath(path);
                throw ne;
            }
            if (!file.delete()) {
                throw new NodeOSException("EIO");
            }
        }

        @JSFunction
        public static void mkdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final int mode = ArgUtils.intArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl fs = (FSImpl)thisObj;
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doMkdir(path, mode);
                    return null;
                }
            });
        }

        private void doMkdir(String path, int mode) throws NodeOSException {
            File file = this.translatePath(path);
            if (file.exists()) {
                throw new NodeOSException("EEXIST", path);
            }
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                throw new NodeOSException("ENOENT", path);
            }
            if (!file.mkdir()) {
                throw new NodeOSException("EIO", path);
            }
            this.setMode(file, mode);
        }

        @JSFunction
        public static Object readdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doReaddir(path);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doReaddir(String dn) {
            Context cx = Context.enter();
            try {
                Scriptable fileList;
                File f = this.translatePath(dn);
                String[] files = f.list();
                if (files == null) {
                    fileList = cx.newArray((Scriptable)this, 0);
                } else {
                    Object[] objs = new Object[files.length];
                    System.arraycopy(files, 0, objs, 0, files.length);
                    fileList = cx.newArray((Scriptable)this, objs);
                }
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), fileList};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static Object stat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doStat(path);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doStat(String fn) {
            Context cx = Context.enter();
            try {
                File f = this.translatePath(fn);
                if (!f.exists()) {
                    if (log.isTraceEnabled()) {
                        log.trace("stat {} = {}", (Object)f.getPath(), (Object)"ENOENT");
                    }
                    NodeOSException ne = new NodeOSException("ENOENT");
                    ne.setPath(fn);
                    throw ne;
                }
                StatsImpl s = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
                s.setAttributes(cx, f);
                if (log.isTraceEnabled()) {
                    log.trace("stat {} = {}", (Object)f.getPath(), (Object)s);
                }
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), s};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static Object lstat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return FSImpl.stat(cx, thisObj, args, func);
        }

        @JSFunction
        public static Object fstat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doFStat(fd);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doFStat(int fd) {
            FileHandle handle = this.ensureHandle(fd);
            Context cx = Context.enter();
            try {
                StatsImpl s = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
                s.setAttributes(cx, handle.fileRef);
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), s};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        private Object[] doUtimes(File f, double atime, double mtime) throws NodeOSException {
            if (!f.exists()) {
                NodeOSException ne = new NodeOSException("ENOENT");
                ne.setPath(f.getPath());
                throw ne;
            }
            f.setLastModified((long)(mtime * 1000.0));
            return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
        }

        @JSFunction
        public static void utimes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final double atime = ArgUtils.doubleArg(args, 1);
            final double mtime = ArgUtils.doubleArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    File f = self.translatePath(path);
                    return self.doUtimes(f, atime, mtime);
                }
            });
        }

        @JSFunction
        public static void futimes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg(args, 0);
            final double atime = ArgUtils.doubleArg(args, 1);
            final double mtime = ArgUtils.doubleArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    FileHandle fh = self.ensureHandle(fd);
                    return self.doUtimes(fh.fileRef, atime, mtime);
                }
            });
        }

        @JSFunction
        public static void chmod(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final int mode = ArgUtils.intArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    File f = self.translatePath(path);
                    self.setMode(f, mode);
                    return null;
                }
            });
        }

        @JSFunction
        public static void fchmod(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg(args, 0);
            final int mode = ArgUtils.intArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    FileHandle fh = self.ensureHandle(fd);
                    self.setMode(fh.fileRef, mode);
                    return null;
                }
            });
        }

        private void returnError(Context cx, String code, Function cb) {
            if (cb == null) {
                throw Utils.makeError(cx, (Scriptable)this, code, code);
            }
            Scriptable err = Utils.makeErrorObject(cx, (Scriptable)this, code, code);
            this.runner.enqueueCallback(cb, (Scriptable)cb, null, this.runner.getDomain(), new Object[]{err});
        }

        @JSFunction
        public static void chown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Function callback = ArgUtils.functionArg(args, 3, false);
            ((FSImpl)thisObj).returnError(cx, "EPERM", callback);
        }

        @JSFunction
        public static void fchown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Function callback = ArgUtils.functionArg(args, 3, false);
            ((FSImpl)thisObj).returnError(cx, "EPERM", callback);
        }

        @JSFunction
        public static void link(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Function callback = ArgUtils.functionArg(args, 2, false);
            ((FSImpl)thisObj).returnError(cx, "EACCES", callback);
        }

        @JSFunction
        public static void symlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Function callback = ArgUtils.functionArg(args, 3, false);
            ((FSImpl)thisObj).returnError(cx, "EACCES", callback);
        }

        @JSFunction
        public static void readlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Function callback = ArgUtils.functionArg(args, 1, false);
            ((FSImpl)thisObj).returnError(cx, "EINVAL", callback);
        }
    }
}

