/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal.handles;

import io.apigee.trireme.core.NetworkPolicy;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.internal.handles.AbstractNIOHandle;
import io.apigee.trireme.core.internal.handles.HandleListener;
import io.apigee.trireme.core.internal.handles.NetworkHandleListener;
import io.apigee.trireme.net.SelectorHandler;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSocketHandle
extends AbstractNIOHandle {
    private static final Logger log = LoggerFactory.getLogger(NIOSocketHandle.class);
    public static final int READ_BUFFER_SIZE = Short.MAX_VALUE;
    private InetSocketAddress boundAddress;
    private ServerSocketChannel svrChannel;
    private SocketChannel clientChannel;
    private boolean readStarted;
    private ByteBuffer readBuffer;
    private NetworkHandleListener listener;
    private Object listenerCtx;

    public NIOSocketHandle(NodeRuntime runtime) {
        super(runtime);
    }

    public NIOSocketHandle(NodeRuntime runtime, SocketChannel clientChannel) throws IOException {
        super(runtime);
        this.clientChannel = clientChannel;
        this.clientInit();
        this.selKey = clientChannel.register(runtime.getSelector(), 4, new SelectorHandler(){

            public void selected(SelectionKey key) {
                NIOSocketHandle.this.clientSelected(key);
            }
        });
    }

    private void clientInit() throws IOException {
        this.readBuffer = ByteBuffer.allocate(Short.MAX_VALUE);
        this.clientChannel.configureBlocking(false);
        this.setNoDelay(true);
    }

    public void close() {
        try {
            if (this.clientChannel != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing client channel {}", (Object)this.clientChannel);
                }
                this.clientChannel.close();
                this.runtime.unregisterCloseable(this.clientChannel);
            }
            if (this.svrChannel != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing server channel {}", (Object)this.svrChannel);
                }
                this.svrChannel.close();
                this.runtime.unregisterCloseable(this.svrChannel);
            }
        }
        catch (IOException ioe) {
            log.debug("Uncaught exception in channel close: {}", (Throwable)ioe);
        }
    }

    public void bind(String address, int port) throws NodeOSException {
        this.boundAddress = new InetSocketAddress(address, port);
        if (this.boundAddress.isUnresolved()) {
            throw new NodeOSException("ENOENT");
        }
    }

    public void listen(int backlog, NetworkHandleListener listener, Object context) throws NodeOSException {
        if (this.boundAddress == null) {
            throw new NodeOSException("EINVAL");
        }
        NetworkPolicy netPolicy = this.getNetworkPolicy();
        if (netPolicy != null && !netPolicy.allowListening(this.boundAddress)) {
            log.debug("Address {} not allowed by network policy", (Object)this.boundAddress);
            throw new NodeOSException("EINVAL");
        }
        this.listener = listener;
        this.listenerCtx = context;
        if (log.isDebugEnabled()) {
            log.debug("Server listening on {} with backlog {}", (Object)this.boundAddress, (Object)backlog);
        }
        boolean success = false;
        try {
            this.svrChannel = ServerSocketChannel.open();
            this.runtime.registerCloseable(this.svrChannel);
            this.svrChannel.configureBlocking(false);
            this.svrChannel.socket().setReuseAddress(true);
            this.svrChannel.socket().bind(this.boundAddress, backlog);
            this.svrChannel.register(this.runtime.getSelector(), 16, new SelectorHandler(){

                public void selected(SelectionKey key) {
                    NIOSocketHandle.this.serverSelected(key);
                }
            });
            success = true;
        }
        catch (BindException be) {
            log.debug("Error listening: {}", (Throwable)be);
            throw new NodeOSException("EADDRINUSE");
        }
        catch (IOException ioe) {
            log.debug("Error listening: {}", (Throwable)ioe);
            throw new NodeOSException("EIO");
        }
        finally {
            if (!success && this.svrChannel != null) {
                this.runtime.unregisterCloseable(this.svrChannel);
                try {
                    this.svrChannel.close();
                }
                catch (IOException ioe) {
                    log.debug("Error closing channel that might be closed: {}", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSelected(SelectionKey key) {
        if (!key.isValid()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Server selected: a = {}", (Object)key.isAcceptable());
        }
        if (key.isAcceptable()) {
            SocketChannel child = null;
            do {
                try {
                    child = this.svrChannel.accept();
                    if (child == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted new socket {}", (Object)child);
                    }
                    boolean success = false;
                    try {
                        this.runtime.registerCloseable(child);
                        NIOSocketHandle sock = new NIOSocketHandle(this.runtime, child);
                        this.listener.onConnection(true, sock, this.listenerCtx);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            this.runtime.unregisterCloseable(child);
                            try {
                                child.close();
                            }
                            catch (IOException ioe) {
                                log.debug("Error closing channel that might be closed: {}", (Throwable)ioe);
                            }
                        }
                    }
                }
                catch (ClosedChannelException cce) {
                    log.debug("Server channel has been closed");
                    break;
                }
                catch (IOException ioe) {
                    log.error("Error accepting a new socket: {}", (Throwable)ioe);
                }
            } while (child != null);
        }
    }

    public int write(ByteBuffer buf, HandleListener listener, Object context) {
        AbstractNIOHandle.QueuedWrite qw = new AbstractNIOHandle.QueuedWrite(buf, listener, context);
        this.offerWrite(qw);
        return qw.length;
    }

    public void shutdown(HandleListener listener, Object context) {
        AbstractNIOHandle.QueuedWrite qw = new AbstractNIOHandle.QueuedWrite(null, listener, context);
        qw.setShutdown(true);
        this.offerWrite(qw);
    }

    private void offerWrite(AbstractNIOHandle.QueuedWrite qw) {
        if (this.writeQueue.isEmpty() && !qw.shutdown) {
            int written;
            try {
                written = this.clientChannel.write(qw.buf);
            }
            catch (IOException ioe) {
                this.queueWrite(qw);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Wrote {} to {} from {}", new Object[]{written, this.clientChannel, qw.buf});
            }
            if (qw.buf.hasRemaining()) {
                this.writeReady = false;
                this.queueWrite(qw);
            } else {
                qw.getListener().onWriteComplete(qw.getLength(), true, qw.getContext());
            }
        } else {
            this.queueWrite(qw);
        }
    }

    public int getWritesOutstanding() {
        return this.queuedBytes;
    }

    public void startReading(HandleListener listener, Object context) {
        if (!this.readStarted) {
            this.listener = (NetworkHandleListener)listener;
            this.listenerCtx = context;
            this.addInterest(1);
            this.readStarted = true;
        }
    }

    public void stopReading() {
        if (this.readStarted) {
            this.removeInterest(1);
            this.readStarted = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(String host, int port, NetworkHandleListener listener, Object context) throws NodeOSException {
        boolean success = false;
        AbstractInterruptibleChannel newChannel = null;
        try {
            InetSocketAddress targetAddress = new InetSocketAddress(host, port);
            NetworkPolicy netPolicy = this.getNetworkPolicy();
            if (netPolicy != null && !netPolicy.allowConnection(targetAddress)) {
                log.debug("Disallowed connection to {} due to network policy", (Object)targetAddress);
                throw new NodeOSException("EINVAL");
            }
            if (log.isDebugEnabled()) {
                log.debug("Client connecting to {}:{}", (Object)host, (Object)port);
            }
            newChannel = this.boundAddress == null ? SocketChannel.open() : SocketChannel.open(this.boundAddress);
            this.runtime.registerCloseable(newChannel);
            this.clientChannel = newChannel;
            this.clientInit();
            this.listener = listener;
            this.listenerCtx = context;
            ((SocketChannel)newChannel).connect(targetAddress);
            this.selKey = ((AbstractSelectableChannel)newChannel).register(this.runtime.getSelector(), 8, new SelectorHandler(){

                public void selected(SelectionKey key) {
                    NIOSocketHandle.this.clientSelected(key);
                }
            });
            return;
        }
        catch (IOException ioe) {
            try {
                log.debug("Error on connect: {}", (Throwable)ioe);
                throw new NodeOSException("EIO");
            }
            catch (Throwable throwable) {
                if (success || newChannel == null) throw throwable;
                this.runtime.unregisterCloseable(newChannel);
                try {
                    newChannel.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    log.debug("Error closing channel that might be closed: {}", (Throwable)ioe2);
                }
                throw throwable;
            }
        }
    }

    protected void processConnect() {
        try {
            this.removeInterest(8);
            this.addInterest(4);
            this.clientChannel.finishConnect();
            if (log.isDebugEnabled()) {
                log.debug("Client {} connected", (Object)this.clientChannel);
            }
            this.listener.onConnectComplete(true, this.listenerCtx);
        }
        catch (ConnectException ce) {
            if (log.isDebugEnabled()) {
                log.debug("Error completing connect: {}", (Throwable)ce);
            }
            this.listener.onConnectError("ECONNREFUSED", true, this.listenerCtx);
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Error completing connect: {}", (Throwable)ioe);
            }
            this.listener.onConnectError("EIO", true, this.listenerCtx);
        }
    }

    protected void processWrites() {
        AbstractNIOHandle.QueuedWrite qw;
        this.writeReady = true;
        this.removeInterest(4);
        while ((qw = (AbstractNIOHandle.QueuedWrite)this.writeQueue.pollFirst()) != null) {
            this.queuedBytes -= qw.getLength();
            assert (this.queuedBytes >= 0);
            try {
                if (qw.shutdown) {
                    if (log.isDebugEnabled()) {
                        log.debug("Sending shutdown for {}", (Object)this.clientChannel);
                    }
                    this.clientChannel.socket().shutdownOutput();
                    this.listener.onWriteComplete(0, true, qw.getContext());
                    continue;
                }
                int written = this.clientChannel.write(qw.buf);
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} to {} from {}", new Object[]{written, this.clientChannel, qw.buf});
                }
                if (qw.buf.hasRemaining()) {
                    this.writeReady = false;
                    this.writeQueue.addFirst(qw);
                    this.queuedBytes += qw.getLength();
                    this.addInterest(4);
                    break;
                }
                this.listener.onWriteComplete(qw.getLength(), true, qw.getContext());
            }
            catch (ClosedChannelException cce) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel is closed");
                }
                this.listener.onWriteError("EOF", true, qw.getContext());
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error on write: {}", (Throwable)ioe);
                }
                this.listener.onWriteError("EIO", true, qw.getContext());
            }
        }
    }

    protected void processReads() {
        int read;
        if (!this.readStarted) {
            return;
        }
        do {
            try {
                read = this.clientChannel.read(this.readBuffer);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error reading from channel: {}", (Object)ioe, (Object)ioe);
                }
                read = -1;
            }
            if (log.isDebugEnabled()) {
                log.debug("Read {} bytes from {} into {}", new Object[]{read, this.clientChannel, this.readBuffer});
            }
            if (read > 0) {
                this.readBuffer.flip();
                ByteBuffer buf = ByteBuffer.allocate(this.readBuffer.remaining());
                buf.put(this.readBuffer);
                buf.flip();
                this.readBuffer.clear();
                this.listener.onReadComplete(buf, true, this.listenerCtx);
                continue;
            }
            if (read >= 0) continue;
            this.removeInterest(1);
            this.listener.onReadError("EOF", true, this.listenerCtx);
        } while (this.readStarted && read > 0);
    }

    public InetSocketAddress getSockName() {
        if (this.svrChannel == null) {
            return (InetSocketAddress)this.clientChannel.socket().getLocalSocketAddress();
        }
        return (InetSocketAddress)this.svrChannel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress getPeerName() {
        if (this.clientChannel == null) {
            return null;
        }
        return (InetSocketAddress)this.clientChannel.socket().getRemoteSocketAddress();
    }

    public void setNoDelay(boolean nd) throws NodeOSException {
        if (this.clientChannel != null) {
            try {
                this.clientChannel.socket().setTcpNoDelay(nd);
            }
            catch (SocketException e) {
                log.error("Error setting TCP no delay on {}: {}", (Object)this, (Object)e);
                throw new NodeOSException("EIO");
            }
        }
    }

    public void setKeepAlive(boolean nd) throws NodeOSException {
        if (this.clientChannel != null) {
            try {
                this.clientChannel.socket().setKeepAlive(nd);
            }
            catch (SocketException e) {
                log.error("Error setting TCP keep alive on {}: {}", (Object)this, (Object)e);
                throw new NodeOSException("EIO");
            }
        }
    }
}

