/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal.handles;

import io.apigee.trireme.core.internal.handles.AbstractHandle;
import io.apigee.trireme.core.internal.handles.HandleListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class JavaOutputStreamHandle
extends AbstractHandle {
    private final OutputStream out;

    public JavaOutputStreamHandle(OutputStream out) {
        this.out = out;
    }

    public int write(ByteBuffer buf, HandleListener listener, Object context) {
        try {
            int len = buf.remaining();
            if (buf.hasArray()) {
                this.out.write(buf.array(), buf.arrayOffset() + buf.position(), len);
                buf.position(buf.position() + len);
            } else {
                byte[] tmp = new byte[len];
                buf.get(tmp);
                this.out.write(tmp);
            }
            listener.onWriteComplete(len, true, context);
            return len;
        }
        catch (IOException ioe) {
            listener.onWriteError("EIO", true, context);
            return 0;
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

