/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal.handles;

import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.handles.HandleListener;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class AbstractHandle {
    public int write(ByteBuffer buf, HandleListener listener, Object context) {
        throw new IllegalStateException("Handle not capable of writing");
    }

    public int write(String s, Charset cs, HandleListener listener, Object context) {
        ByteBuffer buf = Utils.stringToBuffer(s, cs);
        return this.write(buf, listener, context);
    }

    public int getWritesOutstanding() {
        return 0;
    }

    public void startReading(HandleListener listener, Object context) {
        throw new IllegalStateException("Handle not capable of reading");
    }

    public void stopReading() {
        throw new IllegalStateException("Handle not capable of reading");
    }

    public abstract void close();
}

