/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureAlgorithms {
    public static final String SIGNATURE = "Signature";
    private static final SignatureAlgorithms myself = new SignatureAlgorithms();
    private final Pattern SIGNATURE_NAME = Pattern.compile("([0-9a-zA-Z]+)with([0-9a-zA-Z]+)");
    private final HashMap<String, Algorithm> algs = new HashMap();
    private final ArrayList<String> algNames;

    public static SignatureAlgorithms get() {
        return myself;
    }

    private SignatureAlgorithms() {
        for (Provider prov : Security.getProviders()) {
            for (Provider.Service svc : prov.getServices()) {
                Matcher m;
                if (!SIGNATURE.equals(svc.getType()) || !(m = this.SIGNATURE_NAME.matcher(svc.getAlgorithm())).matches()) continue;
                Algorithm sig = new Algorithm();
                String sslName = m.group(2) + '-' + m.group(1);
                sig.setJavaName(svc.getAlgorithm());
                sig.setName(sslName);
                sig.setKeyFormat(m.group(2));
                this.algs.put(sslName, sig);
            }
        }
        this.algNames = new ArrayList<String>(this.algs.keySet());
        Collections.sort(this.algNames);
    }

    public Algorithm get(String name) {
        return this.algs.get(name.toUpperCase());
    }

    public List<String> getAlgorithms() {
        return this.algNames;
    }

    public static class Algorithm {
        private String name;
        private String javaName;
        private String keyFormat;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public void setJavaName(String javaName) {
            this.javaName = javaName;
        }

        public String getKeyFormat() {
            return this.keyFormat;
        }

        public void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }
    }
}

