/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeEnvironment;
import io.apigee.trireme.core.NodeException;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.NodeScript;
import io.apigee.trireme.core.Sandbox;
import io.apigee.trireme.core.ScriptFuture;
import io.apigee.trireme.core.ScriptStatus;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.NodeExitException;
import io.apigee.trireme.core.internal.PathTranslator;
import io.apigee.trireme.core.modules.AbstractFilesystem;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.NativeModule;
import io.apigee.trireme.core.modules.Process;
import io.apigee.trireme.core.modules.ProcessWrap;
import io.apigee.trireme.net.SelectorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRunner
implements NodeRuntime,
Callable<ScriptStatus> {
    public static final String RUNNER = "runner";
    private static final Logger log = LoggerFactory.getLogger(ScriptRunner.class);
    private static final long DEFAULT_DELAY = Integer.MAX_VALUE;
    public static final String TIMEOUT_TIMESTAMP_KEY = "_tickTimeout";
    private final NodeEnvironment env;
    private long now;
    private AbstractModuleRegistry registry;
    private File scriptFile;
    private String script;
    private final NodeScript scriptObject;
    private final String[] args;
    private final HashMap<String, NativeModule.ModuleImpl> moduleCache = new HashMap();
    private final HashMap<String, Object> internalModuleCache = new HashMap();
    private ScriptFuture future;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final Sandbox sandbox;
    private final PathTranslator pathTranslator;
    private final ExecutorService asyncPool;
    private final IdentityHashMap<Closeable, Closeable> openHandles = new IdentityHashMap();
    private final ConcurrentLinkedQueue<Activity> tickFunctions = new ConcurrentLinkedQueue();
    private final PriorityQueue<Activity> timerQueue = new PriorityQueue();
    private final Selector selector;
    private int timerSequence;
    private final AtomicInteger pinCount = new AtomicInteger(0);
    private NativeModule.NativeImpl nativeModule;
    protected Process.ProcessImpl process;
    private Buffer.BufferModuleImpl buffer;
    private String workingDirectory;
    private String scriptFileName;
    private ProcessWrap.ProcessImpl parentProcess;
    private boolean forceRepl;
    private ScriptableObject scope;

    public ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, File scriptFile, String[] args) {
        this(so, env, sandbox, args);
        this.scriptFile = scriptFile;
        try {
            this.scriptFileName = this.pathTranslator.reverseTranslate(scriptFile.getPath());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Error translating file path: " + ioe));
        }
    }

    public ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, String scriptName, String script, String[] args) {
        this(so, env, sandbox, args);
        this.script = script;
        this.scriptFileName = scriptName;
    }

    public ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, String[] args, boolean forceRepl) {
        this(so, env, sandbox, args);
        this.forceRepl = forceRepl;
    }

    private ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, String[] args) {
        this.env = env;
        this.scriptObject = so;
        this.args = args;
        this.sandbox = sandbox;
        this.pathTranslator = new PathTranslator();
        if (sandbox != null && sandbox.getFilesystemRoot() != null) {
            try {
                this.pathTranslator.setRoot(sandbox.getFilesystemRoot());
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)("Unexpected I/O error setting filesystem root: " + ioe));
            }
        }
        this.workingDirectory = sandbox != null && sandbox.getWorkingDirectory() != null ? sandbox.getWorkingDirectory() : (sandbox != null && sandbox.getFilesystemRoot() != null ? "/" : new File(".").getAbsolutePath());
        this.pathTranslator.setWorkingDir(this.workingDirectory);
        this.asyncPool = sandbox != null && sandbox.getAsyncThreadPool() != null ? sandbox.getAsyncThreadPool() : env.getAsyncPool();
        if (sandbox != null && sandbox.getMounts() != null) {
            for (Map.Entry<String, String> mount : sandbox.getMounts()) {
                this.pathTranslator.mount(mount.getKey(), new File(mount.getValue()));
            }
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public void close() {
        try {
            this.selector.close();
        }
        catch (IOException ioe) {
            log.debug("Error closing selector", (Throwable)ioe);
        }
    }

    public void setFuture(ScriptFuture future) {
        this.future = future;
    }

    public ScriptFuture getFuture() {
        return this.future;
    }

    @Override
    public NodeEnvironment getEnvironment() {
        return this.env;
    }

    public long getLoopTimestamp() {
        return this.now;
    }

    public AbstractModuleRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(AbstractModuleRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Sandbox getSandbox() {
        return this.sandbox;
    }

    @Override
    public NodeScript getScriptObject() {
        return this.scriptObject;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String wd) throws IOException {
        File wdf = new File(wd);
        if (wdf.isAbsolute()) {
            this.workingDirectory = wd;
        } else {
            File newWdf = new File(this.workingDirectory, wd);
            this.workingDirectory = newWdf.getCanonicalPath();
        }
        this.pathTranslator.setWorkingDir(this.workingDirectory);
    }

    public Scriptable getScriptScope() {
        return this.scope;
    }

    public NativeModule.NativeImpl getNativeModule() {
        return this.nativeModule;
    }

    public Buffer.BufferModuleImpl getBufferModule() {
        return this.buffer;
    }

    @Override
    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public ExecutorService getAsyncPool() {
        return this.asyncPool;
    }

    @Override
    public ExecutorService getUnboundedPool() {
        return this.env.getScriptPool();
    }

    public InputStream getStdin() {
        return this.sandbox != null && this.sandbox.getStdin() != null ? this.sandbox.getStdin() : System.in;
    }

    public OutputStream getStdout() {
        return this.sandbox != null && this.sandbox.getStdout() != null ? this.sandbox.getStdout() : System.out;
    }

    public OutputStream getStderr() {
        return this.sandbox != null && this.sandbox.getStderr() != null ? this.sandbox.getStderr() : System.err;
    }

    public ProcessWrap.ProcessImpl getParentProcess() {
        return this.parentProcess;
    }

    public Process.ProcessImpl getProcess() {
        return this.process;
    }

    public void setParentProcess(ProcessWrap.ProcessImpl parentProcess) {
        this.parentProcess = parentProcess;
    }

    public void awaitInitialization() {
        try {
            this.initialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public File translatePath(String path) {
        if (path.startsWith("\\\\?\\")) {
            path = path.substring(4);
        }
        File pf = new File(path);
        return this.pathTranslator.translate(pf.getPath());
    }

    @Override
    public String reverseTranslatePath(String path) throws IOException {
        return this.pathTranslator.reverseTranslate(path);
    }

    public PathTranslator getPathTranslator() {
        return this.pathTranslator;
    }

    @Override
    public void enqueueCallback(Function f, Scriptable scope, Scriptable thisObj, Object[] args) {
        this.enqueueCallback(f, scope, thisObj, null, args);
    }

    @Override
    public void enqueueCallback(Function f, Scriptable scope, Scriptable thisObj, Scriptable domain, Object[] args) {
        Callback cb = new Callback(f, scope, thisObj, args);
        cb.setDomain(domain);
        this.tickFunctions.offer(cb);
        this.selector.wakeup();
    }

    @Override
    public void enqueueTask(ScriptTask task) {
        this.enqueueTask(task, null);
    }

    @Override
    public void enqueueTask(ScriptTask task, Scriptable domain) {
        Task t = new Task(task, (Scriptable)this.scope);
        t.setDomain(domain);
        this.tickFunctions.offer(t);
        this.selector.wakeup();
    }

    public void enqueueIpc(Context cx, Object message, final ProcessWrap.ProcessImpl child) {
        Object toDeliver;
        String event = "message";
        if (message == ProcessWrap.IPC_DISCONNECT) {
            event = "disconnect";
            toDeliver = Undefined.instance;
        } else if (message instanceof Buffer.BufferImpl) {
            ByteBuffer bb = ((Buffer.BufferImpl)((Object)message)).getBuffer();
            toDeliver = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this.scope, bb, true);
        } else if (message instanceof Scriptable) {
            String cmd;
            Scriptable s = (Scriptable)message;
            toDeliver = this.copy(cx, s);
            if (s.has("cmd", s) && (cmd = Context.toString((Object)s.get("cmd", s))).startsWith("NODE_")) {
                event = "internalMessage";
            }
        } else if (message instanceof String) {
            toDeliver = message;
        } else {
            throw new AssertionError((Object)"Unsupported object type for IPC");
        }
        final Object reallyDeliver = toDeliver;
        final String fevent = event;
        if (child == null) {
            this.enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    if ("disconnect".equals(fevent)) {
                        if (ScriptRunner.this.process.isConnected()) {
                            ScriptRunner.this.process.setConnected(false);
                            ScriptRunner.this.process.getEmit().call(cx, scope, (Scriptable)ScriptRunner.this.process, new Object[]{fevent});
                        }
                    } else {
                        ScriptRunner.this.process.getEmit().call(cx, scope, (Scriptable)ScriptRunner.this.process, new Object[]{fevent, reallyDeliver});
                    }
                }
            });
        } else {
            assert (child.getRuntime() != this);
            child.getRuntime().enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    child.getOnMessage().call(cx, scope, null, new Object[]{fevent, reallyDeliver});
                }
            });
        }
    }

    private Scriptable copy(Context cx, Scriptable s) {
        if (s instanceof Function) {
            return null;
        }
        Scriptable t = cx.newObject((Scriptable)this.scope);
        for (Object id : s.getIds()) {
            Object val;
            if (id instanceof String) {
                String n = (String)id;
                val = s.get(n, s);
                if (val instanceof Scriptable) {
                    val = this.copy(cx, (Scriptable)val);
                }
                t.put(n, t, val);
                continue;
            }
            if (id instanceof Number) {
                int i = ((Number)id).intValue();
                val = s.get(i, s);
                if (val instanceof Scriptable) {
                    val = this.copy(cx, (Scriptable)val);
                }
                t.put(i, t, val);
                continue;
            }
            throw new AssertionError();
        }
        return t;
    }

    @Override
    public Scriptable getDomain() {
        return ArgUtils.ensureValid(this.process.getDomain());
    }

    public Activity createTimer(long delay, boolean repeating, long repeatInterval, ScriptTask task, Scriptable scope) {
        Task t = new Task(task, scope);
        long timeout = System.currentTimeMillis() + delay;
        int seq = this.timerSequence++;
        if (log.isDebugEnabled()) {
            log.debug("Going to fire timeout {} at {}", (Object)seq, (Object)timeout);
        }
        t.setId(seq);
        t.setTimeout(timeout);
        if (repeating) {
            t.setInterval(repeatInterval);
            t.setRepeating(true);
        }
        this.timerQueue.add(t);
        this.selector.wakeup();
        return t;
    }

    @Override
    public void pin() {
        int currentPinCount = this.pinCount.incrementAndGet();
        log.debug("Pin count is now {}", (Object)currentPinCount);
    }

    @Override
    public void unPin() {
        int currentPinCount = this.pinCount.decrementAndGet();
        log.debug("Pin count is now {}", (Object)currentPinCount);
        if (currentPinCount < 0) {
            log.warn("Negative pin count: {}", (Object)currentPinCount);
        }
        if (currentPinCount == 0) {
            this.selector.wakeup();
        }
    }

    public void setErrno(String err) {
        this.scope.put("errno", (Scriptable)this.scope, (Object)err);
    }

    public void clearErrno() {
        this.scope.put("errno", (Scriptable)this.scope, (Object)0);
    }

    public Object getErrno() {
        if (this.scope.has("errno", (Scriptable)this.scope)) {
            Object errno = this.scope.get("errno", (Scriptable)this.scope);
            if (errno == null) {
                return Context.getUndefinedValue();
            }
            return this.scope.get("errno", (Scriptable)this.scope);
        }
        return Context.getUndefinedValue();
    }

    @Override
    public void registerCloseable(Closeable c) {
        this.openHandles.put(c, c);
    }

    @Override
    public void unregisterCloseable(Closeable c) {
        this.openHandles.remove(c);
    }

    private void closeCloseables(Context cx) {
        AbstractFilesystem fs = (AbstractFilesystem)((Object)this.requireInternal("fs", cx));
        if (fs == null) {
            return;
        }
        fs.cleanup();
        for (Closeable c : this.openHandles.values()) {
            if (log.isDebugEnabled()) {
                log.debug("Closing leaked handle {}", (Object)c);
            }
            try {
                c.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error closing leaked handle: {}", (Throwable)ioe);
            }
        }
    }

    @Override
    public ScriptStatus call() throws NodeException {
        Object ret = this.env.getContextFactory().call(new ContextAction(){

            public Object run(Context cx) {
                return ScriptRunner.this.runScript(cx);
            }
        });
        return (ScriptStatus)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ScriptStatus runScript(Context cx) {
        ScriptStatus status;
        if (this.scriptObject.getDisplayName() != null) {
            try {
                Thread.currentThread().setName("Trireme: " + this.scriptObject.getDisplayName());
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        cx.putThreadLocal((Object)RUNNER, (Object)this);
        this.now = System.currentTimeMillis();
        try {
            this.scope = cx.initStandardObjects();
            this.registry.loadRoot(cx);
            try {
                this.initGlobals(cx);
            }
            catch (NodeException ne) {
                ScriptStatus scriptStatus = new ScriptStatus(ne);
                return scriptStatus;
            }
            finally {
                this.initialized.countDown();
            }
            if (this.scriptFile == null && this.script == null) {
                this.process.setForceRepl(this.forceRepl);
                this.setArgv(null);
            } else if (this.scriptFile == null) {
                this.process.setEval(this.script);
                this.process.setPrintEval(this.scriptObject.isPrintEval());
                this.setArgv(this.scriptFileName);
            } else {
                this.setArgv(this.scriptFileName);
            }
            Script mainScript = this.registry.getMainScript();
            Function main = (Function)mainScript.exec(cx, (Scriptable)this.scope);
            boolean timing = this.startTiming(cx);
            try {
                main.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, new Object[]{this.process});
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
            }
            finally {
                if (timing) {
                    this.endTiming(cx);
                }
            }
            status = this.mainLoop(cx);
        }
        catch (NodeExitException ne) {
            status = ne.getStatus();
        }
        catch (IOException ioe) {
            log.debug("I/O exception processing script: {}", (Throwable)ioe);
            status = new ScriptStatus(ioe);
        }
        catch (Throwable t) {
            log.debug("Unexpected script error: {}", t);
            status = new ScriptStatus(t);
        }
        log.debug("Script exiting with exit code {}", (Object)status.getExitCode());
        if (!status.hasCause() && !this.process.isExiting()) {
            try {
                this.process.setExiting(true);
                this.process.fireExit(cx, status.getExitCode());
            }
            catch (NodeExitException ee) {
                log.debug("Script replacing exit code with {}", (Object)ee.getCode());
                status = ee.getStatus();
            }
            catch (RhinoException re) {
                status = new ScriptStatus(re);
            }
        }
        this.closeCloseables(cx);
        try {
            OutputStream stderr;
            OutputStream stdout = this.getStdout();
            if (stdout != System.out) {
                stdout.close();
            }
            if ((stderr = this.getStderr()) == System.err) return status;
            stderr.close();
            return status;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    private void setArgv(String scriptName) {
        String[] argv = scriptName == null ? new String[this.args == null ? 1 : this.args.length + 1] : new String[this.args == null ? 2 : this.args.length + 2];
        int p = 0;
        argv[p++] = "./node";
        if (scriptName != null) {
            argv[p++] = scriptName;
        }
        if (this.args != null) {
            System.arraycopy(this.args, 0, argv, p, this.args.length);
        }
        if (log.isDebugEnabled()) {
            for (int i = 0; i < argv.length; ++i) {
                log.debug("argv[{}] = {}", (Object)i, (Object)argv[i]);
            }
        }
        this.process.initializeArgv(argv);
    }

    private ScriptStatus mainLoop(Context cx) throws IOException {
        while (!this.tickFunctions.isEmpty() || this.pinCount.get() > 0 || this.process.isCallbacksRequired()) {
            try {
                long pollTimeout;
                if (this.future != null && this.future.isCancelled()) {
                    return ScriptStatus.CANCELLED;
                }
                this.executeNextTicks(cx);
                this.executeTicks(cx);
                this.executeImmediateCallbacks(cx);
                this.now = System.currentTimeMillis();
                if (!this.tickFunctions.isEmpty() || this.process.isCallbacksRequired() || this.pinCount.get() == 0) {
                    pollTimeout = 0L;
                } else if (this.timerQueue.isEmpty()) {
                    pollTimeout = Integer.MAX_VALUE;
                } else {
                    Activity nextActivity = this.timerQueue.peek();
                    pollTimeout = nextActivity.timeout - this.now;
                }
                if (log.isTraceEnabled()) {
                    Scriptable ib = (Scriptable)this.process.getTickInfoBox();
                    log.trace("PollDelay = {}. tickFunctions = {} needImmediate = {} needTick = {} timerQueue = {} pinCount = {} tick = {}, {}, {}", new Object[]{pollTimeout, this.tickFunctions.size(), this.process.isNeedImmediateCallback(), this.process.isNeedTickCallback(), this.timerQueue.size(), this.pinCount.get(), ib.get(0, ib), ib.get(1, ib), ib.get(2, ib)});
                }
                if (pollTimeout > 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("mainLoop: sleeping for {} pinCount = {}", (Object)pollTimeout, (Object)this.pinCount.get());
                    }
                    this.selector.select(pollTimeout);
                } else {
                    this.selector.selectNow();
                }
                this.executeNetworkCallbacks(cx);
                this.executeTimerTasks(cx, this.now);
            }
            catch (NodeExitException ne) {
                return ne.getStatus();
            }
            catch (RhinoException re) {
                return new ScriptStatus(re);
            }
        }
        return ScriptStatus.OK;
    }

    private Scriptable makeError(Context cx, RhinoException re) {
        if (re instanceof JavaScriptException && ((JavaScriptException)re).getValue() instanceof Scriptable) {
            return (Scriptable)((JavaScriptException)re).getValue();
        }
        if (re instanceof EcmaError) {
            return Utils.makeErrorObject(cx, (Scriptable)this.scope, ((EcmaError)re).getErrorMessage(), re);
        }
        return Utils.makeErrorObject(cx, (Scriptable)this.scope, re.getMessage(), re);
    }

    private boolean handleScriptException(Context cx, RhinoException re) {
        if (re instanceof NodeExitException) {
            return false;
        }
        this.endTiming(cx);
        Function handleFatal = this.process.getFatalException();
        if (handleFatal == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Handling fatal exception {} domain = {}\n{}", new Object[]{re, System.identityHashCode(this.process.getDomain()), re.getScriptStackTrace()});
            log.debug("Fatal Java exception: {}", (Throwable)re);
        }
        Scriptable error = this.makeError(cx, re);
        boolean handled = Context.toBoolean((Object)handleFatal.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, new Object[]{error}));
        if (log.isDebugEnabled()) {
            log.debug("Handled = {}", (Object)handled);
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTicks(Context cx) throws RhinoException {
        Activity nextCall;
        do {
            if ((nextCall = this.tickFunctions.poll()) == null) continue;
            boolean timing = this.startTiming(cx);
            try {
                nextCall.execute(cx);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
                return;
            }
            finally {
                if (timing) {
                    this.endTiming(cx);
                }
            }
        } while (nextCall != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNextTicks(Context cx) throws RhinoException {
        if (this.process.isNeedTickCallback()) {
            if (log.isTraceEnabled()) {
                log.trace("Executing ticks");
            }
            boolean timed = this.startTiming(cx);
            try {
                this.process.callTickFromSpinner(cx);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
            }
            finally {
                if (timed) {
                    this.endTiming(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImmediateCallbacks(Context cx) throws RhinoException {
        if (this.process.isNeedImmediateCallback()) {
            if (log.isTraceEnabled()) {
                log.trace("Executing immediate tasks");
            }
            boolean timed = this.startTiming(cx);
            try {
                this.process.callImmediateTasks(cx);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
            }
            finally {
                if (timed) {
                    this.endTiming(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNetworkCallbacks(Context cx) throws RhinoException {
        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
        while (keys.hasNext()) {
            SelectionKey selKey = keys.next();
            keys.remove();
            boolean timed = this.startTiming(cx);
            try {
                ((SelectorHandler)selKey.attachment()).selected(selKey);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (handled) continue;
                throw re;
            }
            finally {
                if (!timed) continue;
                this.endTiming(cx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTimerTasks(Context cx, long now) throws RhinoException {
        Activity timed = this.timerQueue.peek();
        while (timed != null && timed.timeout <= now) {
            this.timerQueue.poll();
            if (!timed.cancelled) {
                boolean timing = this.startTiming(cx);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Executing timer {}", (Object)timed.id);
                    }
                    timed.execute(cx);
                }
                catch (RhinoException re) {
                    boolean handled = this.handleScriptException(cx, re);
                    if (!handled) {
                        throw re;
                    }
                }
                finally {
                    if (timing) {
                        this.endTiming(cx);
                    }
                }
                if (timed.repeating && !timed.cancelled) {
                    timed.timeout = now + timed.interval;
                    if (log.isDebugEnabled()) {
                        log.debug("Re-registering {} to fire at {}", (Object)timed.id, (Object)timed.timeout);
                    }
                    this.timerQueue.add(timed);
                }
            }
            timed = this.timerQueue.peek();
        }
    }

    private void initGlobals(Context cx) throws NodeException {
        try {
            NativeModule.NativeImpl nativeMod;
            this.nativeModule = nativeMod = (NativeModule.NativeImpl)((Object)this.initializeModule("native_module", AbstractModuleRegistry.ModuleType.PUBLIC, cx, (Scriptable)this.scope));
            NativeModule.ModuleImpl nativeModMod = NativeModule.ModuleImpl.newModule(cx, (Scriptable)this.scope, "native_module", "native_module");
            nativeModMod.setLoaded(true);
            nativeModMod.setExports((Scriptable)nativeMod);
            this.cacheModule("native_module", nativeModMod);
            this.process = (Process.ProcessImpl)((Object)this.require("process", cx));
            this.process.setConnected(this.parentProcess != null);
            this.buffer = (Buffer.BufferModuleImpl)((Object)this.require("buffer", cx));
            Scriptable metrics = nativeMod.internalRequire("trireme_metrics", cx);
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "DTRACE_NET_SERVER_CONNECTION");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "DTRACE_NET_STREAM_END");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "COUNTER_NET_SERVER_CONNECTION");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "COUNTER_NET_SERVER_CONNECTION_CLOSE");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "DTRACE_HTTP_CLIENT_REQUEST");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "DTRACE_HTTP_CLIENT_RESPONSE");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "DTRACE_HTTP_SERVER_REQUEST");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "DTRACE_HTTP_SERVER_RESPONSE");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "COUNTER_HTTP_CLIENT_REQUEST");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "COUNTER_HTTP_CLIENT_RESPONSE");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "COUNTER_HTTP_SERVER_REQUEST");
            ScriptRunner.copyProp(metrics, (Scriptable)this.scope, "COUNTER_HTTP_SERVER_RESPONSE");
        }
        catch (InvocationTargetException e) {
            throw new NodeException(e);
        }
        catch (IllegalAccessException e) {
            throw new NodeException(e);
        }
        catch (InstantiationException e) {
            throw new NodeException(e);
        }
    }

    private static void copyProp(Scriptable src, Scriptable dest, String name) {
        dest.put(name, dest, src.get(name, src));
    }

    public Object initializeModule(String modName, AbstractModuleRegistry.ModuleType type, Context cx, Scriptable scope) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        NodeModule mod;
        switch (type) {
            case PUBLIC: {
                mod = this.registry.get(modName);
                break;
            }
            case INTERNAL: {
                mod = this.registry.getInternal(modName);
                break;
            }
            case NATIVE: {
                mod = this.registry.getNative(modName);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (mod == null) {
            return null;
        }
        Scriptable exp = mod.registerExports(cx, scope, this);
        if (exp == null) {
            throw new AssertionError((Object)("Module " + modName + " returned a null export"));
        }
        return exp;
    }

    @Override
    public Object require(String modName, Context cx) {
        try {
            return this.nativeModule.internalRequire(modName, cx);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new EvaluatorException("Error initializing module: " + (targetException != null ? e.toString() + ": " + targetException.toString() : e.toString()));
        }
        catch (InstantiationException e) {
            throw new EvaluatorException("Error initializing module: " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new EvaluatorException("Error initializing modugle: " + e.toString());
        }
    }

    public Object requireInternal(String modName, Context cx) {
        if (this.process == null) {
            return null;
        }
        return this.process.getInternalModule(modName, cx);
    }

    public boolean isNativeModule(String name) {
        return this.registry.get(name) != null || this.registry.getCompiledModule(name) != null;
    }

    public NativeModule.ModuleImpl getCachedModule(String name) {
        return this.moduleCache.get(name);
    }

    public void cacheModule(String name, NativeModule.ModuleImpl module) {
        this.moduleCache.put(name, module);
    }

    public Object getCachedInternalModule(String name) {
        return this.internalModuleCache.get(name);
    }

    public void cacheInternalModule(String name, Object module) {
        this.internalModuleCache.put(name, module);
    }

    private boolean startTiming(Context cx) {
        long tl;
        if (this.env != null && (tl = this.env.getScriptTimeLimit()) > 0L) {
            cx.putThreadLocal((Object)TIMEOUT_TIMESTAMP_KEY, (Object)(System.currentTimeMillis() + tl));
            return true;
        }
        return false;
    }

    private void endTiming(Context cx) {
        cx.removeThreadLocal((Object)TIMEOUT_TIMESTAMP_KEY);
    }

    private final class Task
    extends Activity {
        private ScriptTask task;
        private Scriptable scope;

        Task(ScriptTask task, Scriptable scope) {
            this.task = task;
            this.scope = scope;
        }

        void execute(Context cx) {
            if (this.domain != null && ScriptableObject.hasProperty((Scriptable)this.domain, (String)"_disposed")) {
                this.domain = null;
            }
            if (this.domain != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Entering domain {}", (Object)System.identityHashCode(this.domain));
                }
                Function enter = (Function)ScriptableObject.getProperty((Scriptable)this.domain, (String)"enter");
                enter.call(cx, (Scriptable)enter, this.domain, ScriptRuntime.emptyArgs);
            }
            this.task.execute(cx, this.scope);
            if (this.domain != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Exiting domain {}", (Object)System.identityHashCode(this.domain));
                }
                Function exit = (Function)ScriptableObject.getProperty((Scriptable)this.domain, (String)"exit");
                exit.call(cx, (Scriptable)exit, this.domain, ScriptRuntime.emptyArgs);
            }
        }
    }

    private final class Callback
    extends Activity {
        Function function;
        Scriptable scope;
        Scriptable thisObj;
        Object[] args;

        Callback(Function f, Scriptable s, Scriptable thisObj, Object[] args) {
            this.function = f;
            this.scope = s;
            this.thisObj = thisObj;
            this.args = args;
        }

        void execute(Context cx) {
            Function submitTick = ScriptRunner.this.process.getSubmitTick();
            Object[] callArgs = new Object[(this.args == null ? 0 : this.args.length) + 3];
            callArgs[0] = this.function;
            callArgs[1] = this.thisObj;
            callArgs[2] = this.domain;
            if (this.args != null) {
                System.arraycopy(this.args, 0, callArgs, 3, this.args.length);
            }
            submitTick.call(cx, (Scriptable)this.function, (Scriptable)ScriptRunner.this.process, callArgs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Activity
    implements Comparable<Activity> {
        protected int id;
        protected long timeout;
        protected long interval;
        protected boolean repeating;
        protected boolean cancelled;
        protected Scriptable domain;

        abstract void execute(Context var1);

        int getId() {
            return this.id;
        }

        void setId(int id) {
            this.id = id;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public void setRepeating(boolean repeating) {
            this.repeating = repeating;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public Scriptable getDomain() {
            return this.domain;
        }

        public void setDomain(Scriptable domain) {
            this.domain = domain;
        }

        @Override
        public int compareTo(Activity a) {
            if (this.timeout < a.timeout) {
                return -1;
            }
            if (this.timeout > a.timeout) {
                return 1;
            }
            return 0;
        }
    }
}

