/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.internal.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLCiphers {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    private static final Pattern WHITESPACE = Pattern.compile("[\\t ]+");
    private static final SSLCiphers myself = new SSLCiphers();
    private final HashMap<String, Ciph> javaCiphers = new HashMap();
    private final HashMap<String, HashMap<String, Ciph>> sslCiphers = new HashMap();

    public static SSLCiphers get() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLCiphers() {
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(SSLCiphers.class.getResourceAsStream("/ssl-ciphers.txt"), Charsets.UTF8));
            try {
                String line;
                do {
                    String[] m;
                    if ((line = rdr.readLine()) == null || line.startsWith("#") || (m = WHITESPACE.split(line)).length != 6) continue;
                    Ciph c = new Ciph();
                    c.setJavaName(m[0]);
                    c.setSslName(m[1]);
                    c.setProtocol(m[2]);
                    c.setKeyAlg(m[3]);
                    c.setCryptAlg(m[4]);
                    c.setKeyLen(Integer.parseInt(m[5]));
                    this.javaCiphers.put(c.getJavaName(), c);
                    this.addMap(c.getProtocol(), c.getSslName(), c, this.sslCiphers);
                } while (line != null);
            }
            finally {
                rdr.close();
            }
        }
        catch (IOException ioe) {
            throw new AssertionError("Can't read SSL ciphers file", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new AssertionError("Invalid line in SSL ciphers file", nfe);
        }
    }

    private void addMap(String protocol, String key, Ciph c, HashMap<String, HashMap<String, Ciph>> m) {
        HashMap<String, Ciph> pm = m.get(protocol);
        if (pm == null) {
            pm = new HashMap();
            m.put(protocol, pm);
        }
        pm.put(key, c);
    }

    public Ciph getJavaCipher(String name) {
        return this.javaCiphers.get(name.toUpperCase());
    }

    public Ciph getSslCipher(String protocol, String name) {
        HashMap<String, Ciph> pm = this.sslCiphers.get(protocol);
        return pm == null ? null : pm.get(name.toUpperCase());
    }

    public List<String> getSslCiphers(List<String> javaCiphers) {
        ArrayList<String> l = new ArrayList<String>(javaCiphers.size());
        for (String jc : javaCiphers) {
            Ciph c = this.getJavaCipher(jc);
            if (c == null) continue;
            l.add(c.getSslName());
        }
        return l;
    }

    public List<String> getSslCiphers(String protocol, List<String> javaCiphers) {
        ArrayList<String> l = new ArrayList<String>(javaCiphers.size());
        for (String jc : javaCiphers) {
            Ciph c = this.getJavaCipher(jc);
            if (c == null || !protocol.equals(c.getProtocol())) continue;
            l.add(c.getSslName());
        }
        return l;
    }

    public static final class Ciph {
        private String protocol;
        private String javaName;
        private String sslName;
        private String keyAlg;
        private String cryptAlg;
        private int keyLen;

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public void setJavaName(String javaName) {
            this.javaName = javaName;
        }

        public String getSslName() {
            return this.sslName;
        }

        public void setSslName(String sslName) {
            this.sslName = sslName;
        }

        public String getKeyAlg() {
            return this.keyAlg;
        }

        public void setKeyAlg(String keyAlg) {
            this.keyAlg = keyAlg;
        }

        public String getCryptAlg() {
            return this.cryptAlg;
        }

        public void setCryptAlg(String cryptAlg) {
            this.cryptAlg = cryptAlg;
        }

        public int getKeyLen() {
            return this.keyLen;
        }

        public void setKeyLen(int keyLen) {
            this.keyLen = keyLen;
        }
    }
}

