/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NativeNodeModule;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.spi.NodeImplementation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildModuleRegistry
extends AbstractModuleRegistry {
    private HashMap<String, NodeModule> regularModules;
    private HashMap<String, InternalNodeModule> internalModules;
    private HashMap<String, NativeNodeModule> nativeModules;
    private HashMap<String, Script> scriptModules;
    private final AbstractModuleRegistry parent;

    public ChildModuleRegistry(AbstractModuleRegistry parent) {
        this.parent = parent;
    }

    @Override
    public NodeImplementation getImplementation() {
        return this.parent.getImplementation();
    }

    @Override
    public void loadRoot(Context cx) {
        this.parent.loadRoot(cx);
    }

    @Override
    public NodeModule get(String name) {
        NodeModule mod = this.regularModules == null ? null : this.regularModules.get(name);
        return mod == null ? this.parent.get(name) : mod;
    }

    @Override
    public NodeModule getInternal(String name) {
        InternalNodeModule mod = this.internalModules == null ? null : this.internalModules.get(name);
        return mod == null ? this.parent.getInternal(name) : mod;
    }

    @Override
    public NodeModule getNative(String name) {
        NativeNodeModule mod = this.nativeModules == null ? null : this.nativeModules.get(name);
        return mod == null ? this.parent.getNative(name) : mod;
    }

    @Override
    public Script getCompiledModule(String name) {
        Script s = this.scriptModules == null ? null : this.scriptModules.get(name);
        return s == null ? this.parent.getCompiledModule(name) : s;
    }

    @Override
    public Set<String> getCompiledModuleNames() {
        if (this.scriptModules == null) {
            return this.parent.getCompiledModuleNames();
        }
        HashSet<String> names = new HashSet<String>(this.scriptModules.keySet());
        names.addAll(this.parent.getCompiledModuleNames());
        return names;
    }

    @Override
    public Script getMainScript() {
        return this.parent.getMainScript();
    }

    @Override
    protected void putCompiledModule(String name, Script script) {
        if (this.scriptModules == null) {
            this.scriptModules = new HashMap();
        }
        this.scriptModules.put(name, script);
    }

    @Override
    protected void putInternalModule(String name, InternalNodeModule mod) {
        if (this.internalModules == null) {
            this.internalModules = new HashMap();
        }
        this.internalModules.put(name, mod);
    }

    @Override
    protected void putNativeModule(String name, NativeNodeModule mod) {
        if (this.nativeModules == null) {
            this.nativeModules = new HashMap();
        }
        this.nativeModules.put(name, mod);
    }

    @Override
    protected void putRegularModule(String name, NodeModule mod) {
        if (this.regularModules == null) {
            this.regularModules = new HashMap();
        }
        this.regularModules.put(name, mod);
    }
}

