/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NativeNodeModule;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeScriptModule;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.spi.NodeImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ServiceLoader;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleRegistry {
    private static final String CODE_PREFIX = "(function (exports, require, module, __filename, __dirname) {";
    private static final String CODE_POSTFIX = "});";

    public abstract NodeImplementation getImplementation();

    public abstract void loadRoot(Context var1);

    public abstract NodeModule get(String var1);

    public abstract NodeModule getInternal(String var1);

    public abstract NodeModule getNative(String var1);

    public abstract Script getCompiledModule(String var1);

    public abstract Set<String> getCompiledModuleNames();

    public abstract Script getMainScript();

    protected abstract void putCompiledModule(String var1, Script var2);

    protected abstract void putInternalModule(String var1, InternalNodeModule var2);

    protected abstract void putNativeModule(String var1, NativeNodeModule var2);

    protected abstract void putRegularModule(String var1, NodeModule var2);

    public void load(Context cx, ClassLoader cl) {
        ServiceLoader<NodeModule> loader = ServiceLoader.load(NodeModule.class, cl);
        for (NodeModule mod : loader) {
            this.addNativeModule(mod);
        }
        ServiceLoader<NodeScriptModule> scriptLoader = ServiceLoader.load(NodeScriptModule.class, cl);
        for (NodeScriptModule mod : scriptLoader) {
            for (String[] src : mod.getScriptSources()) {
                if (src.length != 2) {
                    throw new AssertionError((Object)("Script module " + mod.getClass().getName() + " returned script source arrays that do not have two elements"));
                }
                this.compileAndAdd(cx, mod, src[0], src[1]);
            }
        }
    }

    protected void addNativeModule(NodeModule mod) {
        if (mod instanceof InternalNodeModule) {
            this.putInternalModule(mod.getModuleName(), (InternalNodeModule)mod);
        } else if (mod instanceof NativeNodeModule) {
            this.putNativeModule(mod.getModuleName(), (NativeNodeModule)mod);
        } else {
            this.putRegularModule(mod.getModuleName(), mod);
        }
    }

    private void compileAndAdd(Context cx, Object impl, String name, String path) {
        String scriptSource;
        InputStream is = impl.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new AssertionError((Object)("Script " + path + " cannot be found for module " + name));
        }
        try {
            scriptSource = Utils.readStream(is);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Error reading script " + path + " for module " + name));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
        String finalSource = CODE_PREFIX + scriptSource + CODE_POSTFIX;
        Script compiled = cx.compileString(finalSource, name, 1, null);
        this.putCompiledModule(name, compiled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModuleType {
        PUBLIC,
        INTERNAL,
        NATIVE;

    }
}

