/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeVersion<T>
implements Comparable<NodeVersion<T>> {
    private static final Pattern ONEDIGIT = Pattern.compile("([0-9]+|x)");
    private static final Pattern TWODIGIT = Pattern.compile("([0-9]+|x)\\.([0-9]+|x)");
    private static final Pattern THREEDIGIT = Pattern.compile("([0-9]+|x)\\.([0-9]+|x)\\.([0-9]+|x)");
    private int major;
    private int minor;
    private int release;
    private T attachment;

    public NodeVersion(String str) throws IllegalArgumentException {
        String majStr = null;
        String minStr = null;
        String relStr = null;
        Matcher m = ONEDIGIT.matcher(str);
        if (m.matches()) {
            majStr = m.group(1);
        } else {
            m = TWODIGIT.matcher(str);
            if (m.matches()) {
                majStr = m.group(1);
                minStr = m.group(2);
            } else {
                m = THREEDIGIT.matcher(str);
                if (m.matches()) {
                    majStr = m.group(1);
                    minStr = m.group(2);
                    relStr = m.group(3);
                } else {
                    throw new IllegalArgumentException(str);
                }
            }
        }
        this.major = this.parsePart(majStr);
        this.minor = this.parsePart(minStr);
        this.release = this.parsePart(relStr);
    }

    public NodeVersion(String str, T att) throws IllegalArgumentException {
        this(str);
        this.attachment = att;
    }

    public T getAttachment() {
        return this.attachment;
    }

    public void setAttachment(T a) {
        this.attachment = a;
    }

    private int parsePart(String s) {
        if (s == null || "x".equals(s)) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int release) {
        this.release = release;
    }

    private int compare(int v1, int v2) {
        if (v1 < 0 || v2 < 0) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        if (v1 > v2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(NodeVersion v) {
        int compMaj = this.compare(this.major, v.major);
        if (compMaj != 0) {
            return compMaj;
        }
        int compMin = this.compare(this.minor, v.minor);
        if (compMin != 0) {
            return compMin;
        }
        int compRev = this.compare(this.release, v.release);
        if (compRev != 0) {
            return compRev;
        }
        return 0;
    }

    public boolean equals(Object o) {
        try {
            return this.compareTo((NodeVersion)o) == 0;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.major + this.minor + this.release;
    }

    public String toString() {
        return (this.major < 0 ? "x" : String.valueOf(this.major)) + '.' + (this.minor < 0 ? "x" : String.valueOf(this.minor)) + '.' + (this.release < 0 ? "x" : String.valueOf(this.release));
    }
}

