/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateConfigurationTemplateRequest
extends AmazonWebServiceRequest {
    private String applicationName;
    private String templateName;
    private String solutionStackName;
    private SourceConfiguration sourceConfiguration;
    private String environmentId;
    private String description;
    private List<ConfigurationOptionSetting> optionSettings;

    public CreateConfigurationTemplateRequest() {
    }

    public CreateConfigurationTemplateRequest(String applicationName, String templateName) {
        this.applicationName = applicationName;
        this.templateName = templateName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public CreateConfigurationTemplateRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public CreateConfigurationTemplateRequest withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public CreateConfigurationTemplateRequest withSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
        return this;
    }

    public SourceConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    public void setSourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    public CreateConfigurationTemplateRequest withSourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
        return this;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public CreateConfigurationTemplateRequest withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateConfigurationTemplateRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<ConfigurationOptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>(optionSettings.size());
        optionSettingsCopy.addAll(optionSettings);
        this.optionSettings = optionSettingsCopy;
    }

    public CreateConfigurationTemplateRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<ConfigurationOptionSetting>(optionSettings.length));
        }
        for (ConfigurationOptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public CreateConfigurationTemplateRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
        } else {
            ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>(optionSettings.size());
            optionSettingsCopy.addAll(optionSettings);
            this.optionSettings = optionSettingsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ", ");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: " + this.getTemplateName() + ", ");
        }
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: " + this.getSolutionStackName() + ", ");
        }
        if (this.getSourceConfiguration() != null) {
            sb.append("SourceConfiguration: " + this.getSourceConfiguration() + ", ");
        }
        if (this.getEnvironmentId() != null) {
            sb.append("EnvironmentId: " + this.getEnvironmentId() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: " + this.getOptionSettings() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceConfiguration() == null ? 0 : this.getSourceConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentId() == null ? 0 : this.getEnvironmentId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : ((Object)this.getOptionSettings()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationTemplateRequest)) {
            return false;
        }
        CreateConfigurationTemplateRequest other = (CreateConfigurationTemplateRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getSourceConfiguration() == null ^ this.getSourceConfiguration() == null) {
            return false;
        }
        if (other.getSourceConfiguration() != null && !other.getSourceConfiguration().equals(this.getSourceConfiguration())) {
            return false;
        }
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null) {
            return false;
        }
        if (other.getEnvironmentId() != null && !other.getEnvironmentId().equals(this.getEnvironmentId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        return other.getOptionSettings() == null || ((Object)other.getOptionSettings()).equals(this.getOptionSettings());
    }
}

