/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutPipelineDefinitionRequestMarshaller
implements Marshaller<Request<PutPipelineDefinitionRequest>, PutPipelineDefinitionRequest> {
    @Override
    public Request<PutPipelineDefinitionRequest> marshall(PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        if (putPipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutPipelineDefinitionRequest> request = new DefaultRequest<PutPipelineDefinitionRequest>(putPipelineDefinitionRequest, "DataPipeline");
        String target = "DataPipeline.PutPipelineDefinition";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            List<PipelineObject> pipelineObjectsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putPipelineDefinitionRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(putPipelineDefinitionRequest.getPipelineId());
            }
            if ((pipelineObjectsList = putPipelineDefinitionRequest.getPipelineObjects()) != null && pipelineObjectsList.size() > 0) {
                jsonWriter.key("pipelineObjects");
                jsonWriter.array();
                for (PipelineObject pipelineObjectsListValue : pipelineObjectsList) {
                    List<Field> fieldsList;
                    if (pipelineObjectsListValue == null) continue;
                    jsonWriter.object();
                    if (pipelineObjectsListValue.getId() != null) {
                        jsonWriter.key("id").value(pipelineObjectsListValue.getId());
                    }
                    if (pipelineObjectsListValue.getName() != null) {
                        jsonWriter.key("name").value(pipelineObjectsListValue.getName());
                    }
                    if ((fieldsList = pipelineObjectsListValue.getFields()) != null && fieldsList.size() > 0) {
                        jsonWriter.key("fields");
                        jsonWriter.array();
                        for (Field fieldsListValue : fieldsList) {
                            if (fieldsListValue == null) continue;
                            jsonWriter.object();
                            if (fieldsListValue.getKey() != null) {
                                jsonWriter.key("key").value(fieldsListValue.getKey());
                            }
                            if (fieldsListValue.getStringValue() != null) {
                                jsonWriter.key("stringValue").value(fieldsListValue.getStringValue());
                            }
                            if (fieldsListValue.getRefValue() != null) {
                                jsonWriter.key("refValue").value(fieldsListValue.getRefValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

