/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.services.datapipeline.model.ValidationError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatePipelineDefinitionResult {
    private List<ValidationError> validationErrors;
    private Boolean errored;

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<ValidationError> validationErrors) {
        if (validationErrors == null) {
            this.validationErrors = null;
            return;
        }
        ArrayList<ValidationError> validationErrorsCopy = new ArrayList<ValidationError>(validationErrors.size());
        validationErrorsCopy.addAll(validationErrors);
        this.validationErrors = validationErrorsCopy;
    }

    public ValidatePipelineDefinitionResult withValidationErrors(ValidationError ... validationErrors) {
        if (this.getValidationErrors() == null) {
            this.setValidationErrors(new ArrayList<ValidationError>(validationErrors.length));
        }
        for (ValidationError value : validationErrors) {
            this.getValidationErrors().add(value);
        }
        return this;
    }

    public ValidatePipelineDefinitionResult withValidationErrors(Collection<ValidationError> validationErrors) {
        if (validationErrors == null) {
            this.validationErrors = null;
        } else {
            ArrayList<ValidationError> validationErrorsCopy = new ArrayList<ValidationError>(validationErrors.size());
            validationErrorsCopy.addAll(validationErrors);
            this.validationErrors = validationErrorsCopy;
        }
        return this;
    }

    public Boolean isErrored() {
        return this.errored;
    }

    public void setErrored(Boolean errored) {
        this.errored = errored;
    }

    public ValidatePipelineDefinitionResult withErrored(Boolean errored) {
        this.errored = errored;
        return this;
    }

    public Boolean getErrored() {
        return this.errored;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValidationErrors() != null) {
            sb.append("ValidationErrors: " + this.getValidationErrors() + ", ");
        }
        if (this.isErrored() != null) {
            sb.append("Errored: " + this.isErrored() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValidationErrors() == null ? 0 : ((Object)this.getValidationErrors()).hashCode());
        hashCode = 31 * hashCode + (this.isErrored() == null ? 0 : this.isErrored().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionResult)) {
            return false;
        }
        ValidatePipelineDefinitionResult other = (ValidatePipelineDefinitionResult)obj;
        if (other.getValidationErrors() == null ^ this.getValidationErrors() == null) {
            return false;
        }
        if (other.getValidationErrors() != null && !((Object)other.getValidationErrors()).equals(this.getValidationErrors())) {
            return false;
        }
        if (other.isErrored() == null ^ this.isErrored() == null) {
            return false;
        }
        return other.isErrored() == null || other.isErrored().equals(this.isErrored());
    }
}

