/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.journal.leveldb;

import akka.actor.ActorRef;
import akka.dispatch.MessageDispatcher;
import akka.persistence.Delivered;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.leveldb.Key;
import akka.persistence.journal.leveldb.Key$;
import akka.persistence.journal.leveldb.LeveldbStore;
import java.util.Map;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.ReadOptions;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;

public abstract class LeveldbRecovery$class {
    public static String akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId(LeveldbStore $this) {
        return $this.config().getString("replay-dispatcher");
    }

    public static MessageDispatcher akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher(LeveldbStore $this) {
        return $this.context().system().dispatchers().lookup($this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId());
    }

    public static Future asyncReadHighestSequenceNr(LeveldbStore $this, String persistenceId, long fromSequenceNr) {
        int nid = $this.numericId(persistenceId);
        return Future$.MODULE$.apply((Function0)new Serializable($this, nid){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int nid$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.readHighestSequenceNr(this.nid$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nid$1 = nid$1;
            }
        }, (ExecutionContext)$this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static Future asyncReplayMessages(LeveldbStore $this, String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        int nid = $this.numericId(persistenceId);
        return Future$.MODULE$.apply((Function0)new Serializable($this, nid, fromSequenceNr, toSequenceNr, max, replayCallback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int nid$2;
            private final long fromSequenceNr$1;
            private final long toSequenceNr$1;
            private final long max$1;
            private final Function1 replayCallback$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.replayMessages(this.nid$2, this.fromSequenceNr$1, this.toSequenceNr$1, this.max$1, this.replayCallback$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nid$2 = nid$2;
                this.fromSequenceNr$1 = fromSequenceNr$1;
                this.toSequenceNr$1 = toSequenceNr$1;
                this.max$1 = max$1;
                this.replayCallback$1 = replayCallback$1;
            }
        }, (ExecutionContext)$this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static void replayMessages(LeveldbStore $this, int persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        $this.withIterator(new Serializable($this, persistenceId, fromSequenceNr, toSequenceNr, max, replayCallback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int persistenceId$1;
            private final long fromSequenceNr$2;
            private final long toSequenceNr$2;
            private final long max$2;
            private final Function1 replayCallback$2;

            public final void apply(DBIterator iter) {
                Key startKey = new Key(this.persistenceId$1, this.fromSequenceNr$2 < 1L ? 1L : this.fromSequenceNr$2, 0);
                iter.seek(Key$.MODULE$.keyToBytes(startKey));
                LeveldbRecovery$class.go$1(this.$outer, iter, startKey, 0L, this.replayCallback$2, this.toSequenceNr$2, this.max$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.persistenceId$1 = persistenceId$1;
                this.fromSequenceNr$2 = fromSequenceNr$2;
                this.toSequenceNr$2 = toSequenceNr$2;
                this.max$2 = max$2;
                this.replayCallback$2 = replayCallback$2;
            }
        });
    }

    public static long readHighestSequenceNr(LeveldbStore $this, int persistenceId) {
        ReadOptions ro = $this.leveldbSnapshot();
        try {
            byte[] byArray = $this.leveldb().get(Key$.MODULE$.keyToBytes(Key$.MODULE$.counterKey(persistenceId)), ro);
            long l = byArray == null ? 0L : Key$.MODULE$.counterFromBytes(byArray);
            return l;
        }
        finally {
            ro.snapshot().close();
        }
    }

    public static final void go$1(LeveldbStore $this, DBIterator iter, Key key, long ctr, Function1 replayCallback, long toSequenceNr$2, long max$2) {
        block7: {
            BoxedUnit boxedUnit;
            while (iter.hasNext()) {
                Map.Entry nextEntry = (Map.Entry)iter.next();
                Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
                if (nextKey.sequenceNr() > toSequenceNr$2) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (nextKey.channelId() != 0) {
                        key = nextKey;
                        continue;
                    }
                    if (key.persistenceId() == nextKey.persistenceId()) {
                        PersistentRepr msg = $this.persistentFromBytes((byte[])nextEntry.getValue());
                        boolean del = LeveldbRecovery$class.deletion$1($this, iter, nextKey);
                        List cnf = LeveldbRecovery$class.confirms$1($this, iter, nextKey, (List)Nil$.MODULE$);
                        if (ctr < max$2) {
                            List x$2 = cnf;
                            boolean x$3 = del;
                            long x$4 = msg.update$default$1();
                            String x$5 = msg.update$default$2();
                            int x$6 = msg.update$default$4();
                            Delivered x$7 = msg.update$default$6();
                            ActorRef x$8 = msg.update$default$7();
                            ActorRef x$9 = msg.update$default$8();
                            replayCallback.apply((Object)msg.update(x$4, x$5, x$3, x$6, (Seq<String>)x$2, x$7, x$8, x$9));
                            ++ctr;
                            key = nextKey;
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                break block7;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final List confirms$1(LeveldbStore $this, DBIterator iter, Key key, List channelIds) {
        List list;
        block2: {
            while (iter.hasNext()) {
                Map.Entry nextEntry = iter.peekNext();
                Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
                if (key.persistenceId() == nextKey.persistenceId() && key.sequenceNr() == nextKey.sequenceNr()) {
                    String nextValue = new String((byte[])nextEntry.getValue(), "UTF-8");
                    iter.next();
                    String string = nextValue;
                    channelIds = channelIds.$colon$colon((Object)string);
                    key = nextKey;
                    continue;
                }
                list = channelIds;
                break block2;
            }
            list = channelIds;
        }
        return list;
    }

    private static final boolean deletion$1(LeveldbStore $this, DBIterator iter, Key key) {
        boolean bl;
        if (iter.hasNext()) {
            Map.Entry nextEntry = iter.peekNext();
            Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
            if (key.persistenceId() == nextKey.persistenceId() && key.sequenceNr() == nextKey.sequenceNr() && Key$.MODULE$.isDeletionKey(nextKey)) {
                iter.next();
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static void $init$(LeveldbStore $this) {
    }
}

