/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorPath;
import akka.actor.ActorSelection$;
import akka.persistence.AtLeastOnceDelivery;
import akka.persistence.AtLeastOnceDelivery$Internal$RedeliveryTick$;
import akka.persistence.JournalProtocol$ReplayMessagesSuccess$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public abstract class AtLeastOnceDelivery$class {
    public static FiniteDuration redeliverInterval(AtLeastOnceDelivery $this) {
        return $this.akka$persistence$AtLeastOnceDelivery$$defaultRedeliverInterval();
    }

    public static int warnAfterNumberOfUnconfirmedAttempts(AtLeastOnceDelivery $this) {
        return $this.akka$persistence$AtLeastOnceDelivery$$defaultWarnAfterNumberOfUnconfirmedAttempts();
    }

    public static int maxUnconfirmedMessages(AtLeastOnceDelivery $this) {
        return $this.akka$persistence$AtLeastOnceDelivery$$defaultMaxUnconfirmedMessages();
    }

    private static long nextDeliverySequenceNr(AtLeastOnceDelivery $this) {
        $this.akka$persistence$AtLeastOnceDelivery$$deliverySequenceNr_$eq($this.akka$persistence$AtLeastOnceDelivery$$deliverySequenceNr() + 1L);
        return $this.akka$persistence$AtLeastOnceDelivery$$deliverySequenceNr();
    }

    public static void deliver(AtLeastOnceDelivery $this, ActorPath destination, Function1 deliveryIdToMessage) {
        if ($this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().size() >= $this.maxUnconfirmedMessages()) {
            throw new AtLeastOnceDelivery.MaxUnconfirmedMessagesExceededException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many unconfirmed messages, maximum allowed is [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.maxUnconfirmedMessages())})));
        }
        long deliveryId = AtLeastOnceDelivery$class.nextDeliverySequenceNr($this);
        long now = $this.recoveryRunning() ? System.nanoTime() - $this.redeliverInterval().toNanos() : System.nanoTime();
        AtLeastOnceDelivery.Internal.Delivery d = new AtLeastOnceDelivery.Internal.Delivery(destination, deliveryIdToMessage.apply((Object)BoxesRunTime.boxToLong((long)deliveryId)), now, 0);
        if ($this.recoveryRunning()) {
            $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)$this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().updated((Object)BoxesRunTime.boxToLong((long)deliveryId), (Object)d));
        } else {
            AtLeastOnceDelivery$class.akka$persistence$AtLeastOnceDelivery$$send($this, deliveryId, d, now);
        }
    }

    public static boolean confirmDelivery(AtLeastOnceDelivery $this, long deliveryId) {
        boolean bl;
        if ($this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().contains((Object)BoxesRunTime.boxToLong((long)deliveryId))) {
            $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)((SortedMap)$this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().$minus((Object)BoxesRunTime.boxToLong((long)deliveryId))));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static int numberOfUnconfirmed(AtLeastOnceDelivery $this) {
        return $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().size();
    }

    private static void redeliverOverdue(AtLeastOnceDelivery $this) {
        long now = System.nanoTime();
        long deadline = now - $this.redeliverInterval().toNanos();
        ObjectRef warnings = new ObjectRef((Object)package$.MODULE$.Vector().empty());
        $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().foreach((Function1)new Serializable($this, now, deadline, warnings){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AtLeastOnceDelivery $outer;
            private final long now$1;
            private final long deadline$1;
            private final ObjectRef warnings$1;

            public final void apply(Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> x0$1) {
                Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    long deliveryId = tuple2._1$mcJ$sp();
                    AtLeastOnceDelivery.Internal.Delivery delivery = (AtLeastOnceDelivery.Internal.Delivery)tuple2._2();
                    if (delivery.timestamp() <= this.deadline$1) {
                        AtLeastOnceDelivery$class.akka$persistence$AtLeastOnceDelivery$$send(this.$outer, deliveryId, delivery, this.now$1);
                        if (delivery.attempt() == this.$outer.warnAfterNumberOfUnconfirmedAttempts()) {
                            this.warnings$1.elem = (Vector)((Vector)this.warnings$1.elem).$colon$plus((Object)new AtLeastOnceDelivery.UnconfirmedDelivery(deliveryId, delivery.destination(), delivery.message()), Vector$.MODULE$.canBuildFrom());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
                this.deadline$1 = deadline$1;
                this.warnings$1 = warnings$1;
            }
        });
        if (((Vector)warnings.elem).nonEmpty()) {
            akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new AtLeastOnceDelivery.UnconfirmedWarning((scala.collection.immutable.Seq<AtLeastOnceDelivery.UnconfirmedDelivery>)((Vector)warnings.elem)), $this.self());
        }
    }

    public static void akka$persistence$AtLeastOnceDelivery$$send(AtLeastOnceDelivery $this, long deliveryId, AtLeastOnceDelivery.Internal.Delivery d, long timestamp) {
        ActorSelection$.MODULE$.toScala($this.context().actorSelection(d.destination())).$bang(d.message(), $this.self());
        long x$1 = timestamp;
        int x$2 = d.attempt() + 1;
        ActorPath x$3 = d.copy$default$1();
        Object x$4 = d.copy$default$2();
        $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)$this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().updated((Object)BoxesRunTime.boxToLong((long)deliveryId), (Object)d.copy(x$3, x$4, x$1, x$2)));
    }

    public static AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot getDeliverySnapshot(AtLeastOnceDelivery $this) {
        return new AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot($this.akka$persistence$AtLeastOnceDelivery$$deliverySequenceNr(), (scala.collection.immutable.Seq<AtLeastOnceDelivery.UnconfirmedDelivery>)((scala.collection.immutable.Seq)$this.akka$persistence$AtLeastOnceDelivery$$unconfirmed().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final AtLeastOnceDelivery.UnconfirmedDelivery apply(Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> x0$2) {
                Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> tuple2 = x0$2;
                if (tuple2 != null) {
                    long deliveryId = tuple2._1$mcJ$sp();
                    AtLeastOnceDelivery.Internal.Delivery d = (AtLeastOnceDelivery.Internal.Delivery)tuple2._2();
                    AtLeastOnceDelivery.UnconfirmedDelivery unconfirmedDelivery = new AtLeastOnceDelivery.UnconfirmedDelivery(deliveryId, d.destination(), d.message());
                    return unconfirmedDelivery;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()))));
    }

    public static void setDeliverySnapshot(AtLeastOnceDelivery $this, AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snapshot) {
        $this.akka$persistence$AtLeastOnceDelivery$$deliverySequenceNr_$eq(snapshot.currentDeliveryId());
        long now = System.nanoTime();
        $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)((SortedMap)snapshot.unconfirmedDeliveries().map((Function1)new Serializable($this, now){
            public static final long serialVersionUID = 0L;
            private final long now$2;

            public final Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> apply(AtLeastOnceDelivery.UnconfirmedDelivery d) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)d.deliveryId())), (Object)new AtLeastOnceDelivery.Internal.Delivery(d.destination(), d.message(), this.now$2, 0));
            }
            {
                this.now$2 = now$2;
            }
        }, scala.collection.package$.MODULE$.breakOut(SortedMap$.MODULE$.canBuildFrom((Ordering)Ordering.Long$.MODULE$)))));
    }

    public static void aroundPreRestart(AtLeastOnceDelivery $this, Throwable reason, Option message) {
        $this.akka$persistence$AtLeastOnceDelivery$$redeliverTask().cancel();
        $this.akka$persistence$AtLeastOnceDelivery$$super$aroundPreRestart(reason, (Option<Object>)message);
    }

    public static void aroundPostStop(AtLeastOnceDelivery $this) {
        $this.akka$persistence$AtLeastOnceDelivery$$redeliverTask().cancel();
        $this.akka$persistence$AtLeastOnceDelivery$$super$aroundPostStop();
    }

    public static void aroundReceive(AtLeastOnceDelivery $this, PartialFunction receive2, Object message) {
        Object object = message;
        JournalProtocol$ReplayMessagesSuccess$ journalProtocol$ReplayMessagesSuccess$ = JournalProtocol$ReplayMessagesSuccess$.MODULE$;
        Object object2 = object;
        if (!(journalProtocol$ReplayMessagesSuccess$ != null ? !journalProtocol$ReplayMessagesSuccess$.equals(object2) : object2 != null)) {
            AtLeastOnceDelivery$class.redeliverOverdue($this);
            $this.akka$persistence$AtLeastOnceDelivery$$super$aroundReceive((PartialFunction<Object, BoxedUnit>)receive2, message);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AtLeastOnceDelivery$Internal$RedeliveryTick$ atLeastOnceDelivery$Internal$RedeliveryTick$ = AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$;
            Object object3 = object;
            if (!(atLeastOnceDelivery$Internal$RedeliveryTick$ != null ? !atLeastOnceDelivery$Internal$RedeliveryTick$.equals(object3) : object3 != null)) {
                AtLeastOnceDelivery$class.redeliverOverdue($this);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.akka$persistence$AtLeastOnceDelivery$$super$aroundReceive((PartialFunction<Object, BoxedUnit>)receive2, message);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static void $init$(AtLeastOnceDelivery $this) {
        $this.akka$persistence$AtLeastOnceDelivery$_setter_$akka$persistence$AtLeastOnceDelivery$$defaultRedeliverInterval_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().redeliverInterval());
        $this.akka$persistence$AtLeastOnceDelivery$_setter_$akka$persistence$AtLeastOnceDelivery$$defaultWarnAfterNumberOfUnconfirmedAttempts_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().warnAfterNumberOfUnconfirmedAttempts());
        $this.akka$persistence$AtLeastOnceDelivery$_setter_$akka$persistence$AtLeastOnceDelivery$$defaultMaxUnconfirmedMessages_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().maxUnconfirmedMessages());
        FiniteDuration interval = $this.redeliverInterval().$div(2L);
        $this.akka$persistence$AtLeastOnceDelivery$_setter_$akka$persistence$AtLeastOnceDelivery$$redeliverTask_$eq($this.context().system().scheduler().schedule(interval, interval, $this.self(), (Object)AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$, (ExecutionContext)$this.context().dispatcher(), $this.self()));
        $this.akka$persistence$AtLeastOnceDelivery$$deliverySequenceNr_$eq(0L);
        $this.akka$persistence$AtLeastOnceDelivery$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)SortedMap$.MODULE$.empty((Ordering)Ordering.Long$.MODULE$));
    }
}

