/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.NormalRelativeUrlResolver;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.CacheUtil;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.core.settings.XmlSettingsParser;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.osgi.core.OsgiLatestStrategy;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.ErrorCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestCompatibleConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.latest.LatestTimeStrategy;
import org.apache.ivy.plugins.lock.ArtifactLockStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.report.LogReportOutputter;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.DualResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class IvySettings
implements SortEngineSettings,
PublishEngineSettings,
ParserSettings,
DeliverEngineSettings,
CheckEngineSettings,
InstallEngineSettings,
ResolverSettings,
ResolveEngineSettings,
RetrieveEngineSettings,
RepositoryManagementEngineSettings {
    private static final long INTERUPT_TIMEOUT = 2000L;
    private Map typeDefs = new HashMap();
    private Map resolversMap = new HashMap();
    private DependencyResolver defaultResolver;
    private DependencyResolver dictatorResolver = null;
    private String defaultResolverName;
    private File defaultCache;
    private String defaultBranch = null;
    private boolean checkUpToDate = true;
    private ModuleRules moduleSettings = new ModuleRules();
    private Map conflictsManager = new HashMap();
    private Map latestStrategies = new HashMap();
    private Map lockStrategies = new HashMap();
    private Map namespaces = new HashMap();
    private Map matchers = new HashMap();
    private Map reportOutputters = new HashMap();
    private Map versionMatchers = new HashMap();
    private Map circularDependencyStrategies = new HashMap();
    private Map repositoryCacheManagers = new HashMap();
    private Map signatureGenerators = new HashMap();
    private List triggers = new ArrayList();
    private IvyVariableContainer variableContainer = new IvyVariableContainerImpl();
    private boolean validate = true;
    private LatestStrategy defaultLatestStrategy = null;
    private LockStrategy defaultLockStrategy = null;
    private ConflictManager defaultConflictManager = null;
    private CircularDependencyStrategy circularDependencyStrategy = null;
    private RepositoryCacheManager defaultRepositoryCacheManager = null;
    private ResolutionCacheManager resolutionCacheManager = null;
    private List listingIgnore = new ArrayList();
    private boolean repositoriesConfigured;
    private boolean useRemoteConfig = false;
    private File defaultUserDir;
    private File baseDir = new File(".").getAbsoluteFile();
    private List classpathURLs = new ArrayList();
    private ClassLoader classloader;
    private Boolean debugConflictResolution;
    private boolean logNotConvertedExclusionRule;
    private VersionMatcher versionMatcher;
    private StatusManager statusManager;
    private Boolean debugLocking;
    private Boolean dumpMemoryUsage;
    private String defaultCacheIvyPattern;
    private String defaultCacheArtifactPattern;
    private boolean defaultUseOrigin;
    private String defaultResolveMode = "default";

    public IvySettings() {
        this(new IvyVariableContainerImpl());
    }

    public IvySettings(IvyVariableContainer variableContainer) {
        this.setVariableContainer(variableContainer);
        this.setVariable("ivy.default.settings.dir", this.getDefaultSettingsDir(), true);
        this.setVariable("ivy.basedir", this.getBaseDir().getAbsolutePath());
        this.setDeprecatedVariable("ivy.default.conf.dir", "ivy.default.settings.dir");
        String ivyTypeDefs = System.getProperty("ivy.typedef.files");
        if (ivyTypeDefs != null) {
            String[] files = ivyTypeDefs.split("\\,");
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.typeDefs(new FileInputStream(Checks.checkAbsolute(files[i].trim(), "ivy.typedef.files")), true);
                    continue;
                }
                catch (FileNotFoundException e) {
                    Message.warn("typedefs file not found: " + files[i].trim());
                    continue;
                }
                catch (IOException e) {
                    Message.warn("problem with typedef file: " + files[i].trim() + ": " + e.getMessage());
                }
            }
        } else {
            try {
                this.typeDefs(IvySettings.getSettingsURL("typedef.properties").openStream(), true);
            }
            catch (IOException e) {
                Message.warn("impossible to load default type defs");
            }
        }
        LatestLexicographicStrategy latestLexicographicStrategy = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        OsgiLatestStrategy osgiLatestStrategy = new OsgiLatestStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", latestLexicographicStrategy);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addLatestStrategy("latest-osgi", osgiLatestStrategy);
        this.addLockStrategy("no-lock", new NoLockStrategy());
        this.addLockStrategy("artifact-lock", new ArtifactLockStrategy(this.debugLocking()));
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-compatible", new LatestCompatibleConflictManager("latest-compatible", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.INSTANCE);
        this.addMatcher(RegexpPatternMatcher.INSTANCE);
        this.addMatcher(ExactOrRegexpPatternMatcher.INSTANCE);
        try {
            Class<?> globClazz = IvySettings.class.getClassLoader().loadClass("org.apache.ivy.plugins.matcher.GlobPatternMatcher");
            Field instanceField = globClazz.getField("INSTANCE");
            this.addMatcher((PatternMatcher)instanceField.get(null));
        }
        catch (Exception e) {
            Message.info("impossible to define glob matcher: org.apache.ivy.plugins.matcher.GlobPatternMatcher was not found.");
        }
        this.addReportOutputter(new LogReportOutputter());
        this.addReportOutputter(new XmlReportOutputter());
        this.configureDefaultCircularDependencyStrategies();
        this.listingIgnore.add(".cvsignore");
        this.listingIgnore.add("CVS");
        this.listingIgnore.add(".svn");
        this.listingIgnore.add("maven-metadata.xml");
        this.listingIgnore.add("maven-metadata.xml.md5");
        this.listingIgnore.add("maven-metadata.xml.sha1");
        this.addSystemProperties();
    }

    private void addSystemProperties() {
        try {
            this.addAllVariables((Map)System.getProperties().clone());
        }
        catch (AccessControlException ex) {
            Message.verbose("access denied to getting all system properties: they won't be available as Ivy variables.\nset " + ex.getPermission() + " permission if you want to access them");
        }
    }

    public void configureRepositories(boolean remote) {
        if (!this.repositoriesConfigured) {
            Properties props;
            block9: {
                props = new Properties();
                boolean configured = false;
                if (this.useRemoteConfig && remote) {
                    try {
                        URL url = new URL("http://ant.apache.org/ivy/repository.properties");
                        Message.verbose("configuring repositories with " + url);
                        props.load(URLHandlerRegistry.getDefault().openStream(url));
                        configured = true;
                    }
                    catch (Exception ex) {
                        Message.verbose("unable to use remote repository configuration: " + ex.getMessage());
                        props = new Properties();
                    }
                }
                if (!configured) {
                    InputStream repositoryPropsStream = null;
                    try {
                        repositoryPropsStream = IvySettings.getSettingsURL("repository.properties").openStream();
                        props.load(repositoryPropsStream);
                    }
                    catch (IOException e) {
                        Message.error("unable to use internal repository configuration: " + e.getMessage());
                        if (repositoryPropsStream == null) break block9;
                        try {
                            repositoryPropsStream.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            this.addAllVariables(props, false);
            this.repositoriesConfigured = true;
        }
    }

    public void typeDefs(InputStream stream) throws IOException {
        this.typeDefs(stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typeDefs(InputStream stream, boolean silentFail) throws IOException {
        try {
            Properties p = new Properties();
            p.load(stream);
            this.typeDefs(p, silentFail);
        }
        finally {
            stream.close();
        }
    }

    public void typeDefs(Properties p) {
        this.typeDefs(p, false);
    }

    public void typeDefs(Properties p, boolean silentFail) {
        Iterator<Object> iter = p.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.typeDef(name, p.getProperty(name), silentFail);
        }
    }

    public void load(File settingsFile) throws ParseException, IOException {
        Message.info(":: loading settings :: file = " + settingsFile);
        long start = System.currentTimeMillis();
        this.setSettingsVariables(settingsFile);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        try {
            new XmlSettingsParser(this).parse(settingsFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("given file cannot be transformed to url: " + settingsFile);
            iae.initCause(e);
            throw iae;
        }
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - start) + "ms)");
        this.dumpSettings();
    }

    public void load(URL settingsURL) throws ParseException, IOException {
        Message.info(":: loading settings :: url = " + settingsURL);
        long start = System.currentTimeMillis();
        this.setSettingsVariables(settingsURL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        new XmlSettingsParser(this).parse(settingsURL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - start) + "ms)");
        this.dumpSettings();
    }

    public void defaultInit() throws IOException {
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.getDefaultCache();
        this.loadDefaultProperties();
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        this.dumpSettings();
    }

    public void loadDefault() throws ParseException, IOException {
        this.load(IvySettings.getDefaultSettingsURL());
    }

    public void loadDefault14() throws ParseException, IOException {
        this.load(IvySettings.getDefault14SettingsURL());
    }

    private void loadDefaultProperties() throws IOException {
        this.loadProperties(IvySettings.getDefaultPropertiesURL(), false);
    }

    public static URL getDefaultPropertiesURL() {
        return IvySettings.getSettingsURL("ivy.properties");
    }

    public static URL getDefaultSettingsURL() {
        return IvySettings.getSettingsURL("ivysettings.xml");
    }

    public static URL getDefault14SettingsURL() {
        return IvySettings.getSettingsURL("ivysettings-1.4.xml");
    }

    private String getDefaultSettingsDir() {
        String ivysettingsLocation = IvySettings.getDefaultSettingsURL().toExternalForm();
        return ivysettingsLocation.substring(0, ivysettingsLocation.length() - "ivysettings.xml".length() - 1);
    }

    private static URL getSettingsURL(String file) {
        return XmlSettingsParser.class.getResource(file);
    }

    public void setSettingsVariables(File settingsFile) {
        try {
            this.setVariable("ivy.settings.dir", new File(settingsFile.getAbsolutePath()).getParent());
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            this.setVariable("ivy.settings.file", settingsFile.getAbsolutePath());
            this.setDeprecatedVariable("ivy.conf.file", "ivy.settings.file");
            this.setVariable("ivy.settings.url", settingsFile.toURI().toURL().toExternalForm());
            this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("given file cannot be transformed to url: " + settingsFile);
            iae.initCause(e);
            throw iae;
        }
    }

    private void setDeprecatedVariable(String deprecatedKey, String newKey) {
        this.setVariable(deprecatedKey, this.getVariable(newKey));
    }

    public void setSettingsVariables(URL settingsURL) {
        String settingsURLStr = settingsURL.toExternalForm();
        this.setVariable("ivy.settings.url", settingsURLStr);
        this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        int slashIndex = settingsURLStr.lastIndexOf(47);
        if (slashIndex != -1) {
            this.setVariable("ivy.settings.dir", settingsURLStr.substring(0, slashIndex));
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
        } else {
            Message.warn("settings url does not contain any slash (/): ivy.settings.dir variable not set");
        }
    }

    private void dumpSettings() {
        Iterator<Object> iter;
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        Message.verbose("\tdefault resolver: " + this.getDefaultResolver());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.doValidate());
        Message.debug("\tcheck up2date: " + this.isCheckUpToDate());
        if (!this.classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this.classpathURLs.size() + " custom classpath urls:");
            iter = this.classpathURLs.iterator();
            while (iter.hasNext()) {
                Message.debug("\t\t" + iter.next());
            }
        }
        Message.verbose("\t-- " + this.resolversMap.size() + " resolvers:");
        iter = this.resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.dumpSettings();
        }
        Message.debug("\tmodule settings:");
        this.moduleSettings.dump("\t\t");
    }

    public void loadProperties(URL url) throws IOException {
        this.loadProperties(url, true);
    }

    public void loadProperties(URL url, boolean overwrite) throws IOException {
        this.loadProperties(url.openStream(), overwrite);
    }

    public void loadProperties(File file) throws IOException {
        this.loadProperties(file, true);
    }

    public void loadProperties(File file, boolean overwrite) throws IOException {
        this.loadProperties(new FileInputStream(file), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(InputStream stream, boolean overwrite) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            this.addAllVariables(properties, overwrite);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setVariable(String varName, String value) {
        this.setVariable(varName, value, true);
    }

    public void setVariable(String varName, String value, boolean overwrite) {
        this.variableContainer.setVariable(varName, value, overwrite);
    }

    public void addAllVariables(Map variables) {
        this.addAllVariables(variables, true);
    }

    public void addAllVariables(Map variables, boolean overwrite) {
        Iterator iter = variables.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String val = (String)variables.get(key);
            this.setVariable(key, val, overwrite);
        }
    }

    public String substitute(String str) {
        return IvyPatternHelper.substituteVariables(str, this.variableContainer);
    }

    public Map substitute(Map strings) {
        LinkedHashMap substituted = new LinkedHashMap();
        Iterator it = strings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            substituted.put(entry.getKey(), this.substitute((String)entry.getValue()));
        }
        return substituted;
    }

    public IvyVariableContainer getVariables() {
        return this.variableContainer;
    }

    public Class typeDef(String name, String className) {
        return this.typeDef(name, className, false);
    }

    public Class typeDef(String name, String className, boolean silentFail) {
        Class clazz = this.classForName(className, silentFail);
        if (clazz != null) {
            this.typeDefs.put(name, clazz);
        }
        return clazz;
    }

    private Class classForName(String className, boolean silentFail) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (silentFail) {
                Message.info("impossible to define new type: class not found: " + className + " in " + this.classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + className + " in " + this.classpathURLs + " nor Ivy classloader");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = this.classpathURLs.isEmpty() ? Ivy.class.getClassLoader() : new URLClassLoader(this.classpathURLs.toArray(new URL[this.classpathURLs.size()]), Ivy.class.getClassLoader());
        }
        return this.classloader;
    }

    public void addClasspathURL(URL url) {
        this.classpathURLs.add(url);
        this.classloader = null;
    }

    public Map getTypeDefs() {
        return this.typeDefs;
    }

    public Class getTypeDef(String name) {
        return (Class)this.typeDefs.get(name);
    }

    public void addConfigured(DependencyResolver resolver) {
        this.addResolver(resolver);
    }

    public void addConfigured(ModuleDescriptorParser parser) {
        ModuleDescriptorParserRegistry.getInstance().addParser(parser);
    }

    public void addConfigured(SignatureGenerator generator) {
        this.addSignatureGenerator(generator);
    }

    public void addSignatureGenerator(SignatureGenerator generator) {
        this.init(generator);
        this.signatureGenerators.put(generator.getName(), generator);
    }

    public SignatureGenerator getSignatureGenerator(String name) {
        return (SignatureGenerator)this.signatureGenerators.get(name);
    }

    public void addResolver(DependencyResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("null resolver");
        }
        this.init(resolver);
        this.resolversMap.put(resolver.getName(), resolver);
        if (resolver instanceof ChainResolver) {
            List subresolvers = ((ChainResolver)resolver).getResolvers();
            Iterator iter = subresolvers.iterator();
            while (iter.hasNext()) {
                DependencyResolver dr = (DependencyResolver)iter.next();
                this.addResolver(dr);
            }
        } else if (resolver instanceof DualResolver) {
            DependencyResolver artifactResolver;
            DependencyResolver ivyResolver = ((DualResolver)resolver).getIvyResolver();
            if (ivyResolver != null) {
                this.addResolver(ivyResolver);
            }
            if ((artifactResolver = ((DualResolver)resolver).getArtifactResolver()) != null) {
                this.addResolver(artifactResolver);
            }
        }
    }

    public void setDefaultCache(File cacheDirectory) {
        this.setVariable("ivy.cache.dir", cacheDirectory.getAbsolutePath(), false);
        this.defaultCache = cacheDirectory;
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.defaultCache);
        }
    }

    public void setDefaultResolver(String resolverName) {
        this.checkResolverName(resolverName);
        if (resolverName != null && !resolverName.equals(this.defaultResolverName)) {
            this.defaultResolver = null;
        }
        this.defaultResolverName = resolverName;
    }

    private void checkResolverName(String resolverName) {
        if (resolverName != null && !this.resolversMap.containsKey(resolverName)) {
            throw new IllegalArgumentException("no resolver found called " + resolverName + ": check your settings");
        }
    }

    public void addModuleConfiguration(Map attributes, PatternMatcher matcher, String resolverName, String branch, String conflictManager, String resolveMode) {
        this.checkResolverName(resolverName);
        this.moduleSettings.defineRule(new MapMatcher(attributes, matcher), new ModuleSettings(resolverName, branch, conflictManager, resolveMode));
    }

    public File resolveFile(String fileName) {
        return FileUtil.resolveFile(this.baseDir, fileName);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir.getAbsoluteFile();
        this.setVariable("ivy.basedir", this.baseDir.getAbsolutePath());
        this.setVariable("basedir", this.baseDir.getAbsolutePath(), false);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDefaultIvyUserDir() {
        if (this.defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.home"), "ivy.home"));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this.defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy2"));
                Message.verbose("no default ivy user dir defined: set to " + this.defaultUserDir);
            }
        }
        return this.defaultUserDir;
    }

    public void setDefaultIvyUserDir(File defaultUserDir) {
        this.defaultUserDir = defaultUserDir;
        this.setVariable("ivy.default.ivy.user.dir", this.defaultUserDir.getAbsolutePath());
        this.setVariable("ivy.home", this.defaultUserDir.getAbsolutePath());
    }

    public File getDefaultCache() {
        if (this.defaultCache == null) {
            String cache = this.getVariable("ivy.cache.dir");
            if (cache != null) {
                this.defaultCache = Checks.checkAbsolute(cache, "ivy.cache.dir");
            } else {
                this.setDefaultCache(new File(this.getDefaultIvyUserDir(), "cache"));
                Message.verbose("no default cache defined: set to " + this.defaultCache);
            }
        }
        return this.defaultCache;
    }

    public void setDefaultRepositoryCacheBasedir(String repositoryCacheRoot) {
        this.setVariable("ivy.cache.repository", repositoryCacheRoot, true);
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.getDefaultRepositoryCacheBasedir());
        }
    }

    public void setDefaultResolutionCacheBasedir(String resolutionCacheRoot) {
        this.setVariable("ivy.cache.resolution", resolutionCacheRoot, true);
        if (this.resolutionCacheManager != null && this.resolutionCacheManager instanceof DefaultResolutionCacheManager) {
            ((DefaultResolutionCacheManager)this.resolutionCacheManager).setBasedir(this.getDefaultResolutionCacheBasedir());
        }
    }

    public File getDefaultRepositoryCacheBasedir() {
        String repositoryCacheRoot = this.getVariable("ivy.cache.repository");
        if (repositoryCacheRoot != null) {
            return Checks.checkAbsolute(repositoryCacheRoot, "ivy.cache.repository");
        }
        return this.getDefaultCache();
    }

    public File getDefaultResolutionCacheBasedir() {
        String resolutionCacheRoot = this.getVariable("ivy.cache.resolution");
        if (resolutionCacheRoot != null) {
            return Checks.checkAbsolute(resolutionCacheRoot, "ivy.cache.resolution");
        }
        return this.getDefaultCache();
    }

    public void setDictatorResolver(DependencyResolver resolver) {
        this.dictatorResolver = resolver;
    }

    public DependencyResolver getResolver(ModuleRevisionId mrid) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        String resolverName = this.getResolverName(mrid);
        return this.getResolver(resolverName);
    }

    public DependencyResolver getResolver(String resolverName) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        DependencyResolver resolver = (DependencyResolver)this.resolversMap.get(resolverName);
        if (resolver == null) {
            Message.error("unknown resolver " + resolverName);
        }
        return resolver;
    }

    public DependencyResolver getDefaultResolver() {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        if (this.defaultResolver == null) {
            this.defaultResolver = (DependencyResolver)this.resolversMap.get(this.defaultResolverName);
        }
        return this.defaultResolver;
    }

    public String getResolverName(ModuleRevisionId mrid) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(mrid, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getResolverName() != null;
            }
        });
        return ms == null ? this.defaultResolverName : ms.getResolverName();
    }

    public String getDefaultBranch(ModuleId moduleId) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getBranch() != null;
            }
        });
        return ms == null ? this.getDefaultBranch() : ms.getBranch();
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getConflictManager() != null;
            }
        });
        if (ms == null) {
            return this.getDefaultConflictManager();
        }
        ConflictManager cm = this.getConflictManager(ms.getConflictManager());
        if (cm == null) {
            throw new IllegalStateException("ivy badly configured: unknown conflict manager " + ms.getConflictManager());
        }
        return cm;
    }

    public String getResolveMode(ModuleId moduleId) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getResolveMode() != null;
            }
        });
        return ms == null ? this.getDefaultResolveMode() : ms.getResolveMode();
    }

    public String getDefaultResolveMode() {
        return this.defaultResolveMode;
    }

    public void setDefaultResolveMode(String defaultResolveMode) {
        this.defaultResolveMode = defaultResolveMode;
    }

    public void addConfigured(ConflictManager cm) {
        this.addConflictManager(cm.getName(), cm);
    }

    public ConflictManager getConflictManager(String name) {
        if ("default".equals(name)) {
            return this.getDefaultConflictManager();
        }
        return (ConflictManager)this.conflictsManager.get(name);
    }

    public void addConflictManager(String name, ConflictManager cm) {
        this.init(cm);
        this.conflictsManager.put(name, cm);
    }

    public void addConfigured(LatestStrategy latest) {
        this.addLatestStrategy(latest.getName(), latest);
    }

    public LatestStrategy getLatestStrategy(String name) {
        if ("default".equals(name)) {
            return this.getDefaultLatestStrategy();
        }
        return (LatestStrategy)this.latestStrategies.get(name);
    }

    public void addLatestStrategy(String name, LatestStrategy latest) {
        this.init(latest);
        this.latestStrategies.put(name, latest);
    }

    public void addConfigured(LockStrategy lockStrategy) {
        this.addLockStrategy(lockStrategy.getName(), lockStrategy);
    }

    public LockStrategy getLockStrategy(String name) {
        if ("default".equals(name)) {
            return this.getDefaultLockStrategy();
        }
        return (LockStrategy)this.lockStrategies.get(name);
    }

    public void addLockStrategy(String name, LockStrategy lockStrategy) {
        this.init(lockStrategy);
        this.lockStrategies.put(name, lockStrategy);
    }

    public void addConfigured(Namespace ns) {
        this.addNamespace(ns);
    }

    public Namespace getNamespace(String name) {
        if ("system".equals(name)) {
            return this.getSystemNamespace();
        }
        return (Namespace)this.namespaces.get(name);
    }

    public Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public void addNamespace(Namespace ns) {
        this.init(ns);
        this.namespaces.put(ns.getName(), ns);
    }

    public void addConfigured(PatternMatcher m) {
        this.addMatcher(m);
    }

    public PatternMatcher getMatcher(String name) {
        return (PatternMatcher)this.matchers.get(name);
    }

    public void addMatcher(PatternMatcher m) {
        this.init(m);
        this.matchers.put(m.getName(), m);
    }

    public void addConfigured(RepositoryCacheManager c) {
        this.addRepositoryCacheManager(c);
    }

    public RepositoryCacheManager getRepositoryCacheManager(String name) {
        return (RepositoryCacheManager)this.repositoryCacheManagers.get(name);
    }

    public void addRepositoryCacheManager(RepositoryCacheManager c) {
        this.init(c);
        this.repositoryCacheManagers.put(c.getName(), c);
    }

    public RepositoryCacheManager[] getRepositoryCacheManagers() {
        return this.repositoryCacheManagers.values().toArray(new RepositoryCacheManager[this.repositoryCacheManagers.size()]);
    }

    public void addConfigured(ReportOutputter outputter) {
        this.addReportOutputter(outputter);
    }

    public ReportOutputter getReportOutputter(String name) {
        return (ReportOutputter)this.reportOutputters.get(name);
    }

    public void addReportOutputter(ReportOutputter outputter) {
        this.init(outputter);
        this.reportOutputters.put(outputter.getName(), outputter);
    }

    public ReportOutputter[] getReportOutputters() {
        return this.reportOutputters.values().toArray(new ReportOutputter[this.reportOutputters.size()]);
    }

    public void addConfigured(VersionMatcher vmatcher) {
        this.addVersionMatcher(vmatcher);
    }

    public VersionMatcher getVersionMatcher(String name) {
        return (VersionMatcher)this.versionMatchers.get(name);
    }

    public void addVersionMatcher(VersionMatcher vmatcher) {
        this.init(vmatcher);
        this.versionMatchers.put(vmatcher.getName(), vmatcher);
        if (this.versionMatcher == null) {
            this.versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this.versionMatcher instanceof ChainVersionMatcher) {
            ChainVersionMatcher chain = (ChainVersionMatcher)this.versionMatcher;
            chain.add(vmatcher);
        }
    }

    public VersionMatcher[] getVersionMatchers() {
        return this.versionMatchers.values().toArray(new VersionMatcher[this.versionMatchers.size()]);
    }

    public VersionMatcher getVersionMatcher() {
        if (this.versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this.versionMatcher;
    }

    public void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this.circularDependencyStrategy == null) {
            this.circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this.circularDependencyStrategy;
    }

    public CircularDependencyStrategy getCircularDependencyStrategy(String name) {
        if ("default".equals(name)) {
            name = "warn";
        }
        return (CircularDependencyStrategy)this.circularDependencyStrategies.get(name);
    }

    public void setCircularDependencyStrategy(CircularDependencyStrategy strategy) {
        this.circularDependencyStrategy = strategy;
    }

    public void addConfigured(CircularDependencyStrategy strategy) {
        this.addCircularDependencyStrategy(strategy);
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy strategy) {
        this.circularDependencyStrategies.put(strategy.getName(), strategy);
    }

    private void configureDefaultCircularDependencyStrategies() {
        this.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
    }

    public StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = StatusManager.newDefaultInstance();
        }
        return this.statusManager;
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    public String[] getIgnorableFilenames() {
        return this.listingIgnore.toArray(new String[this.listingIgnore.size()]);
    }

    public void filterIgnore(Collection names) {
        names.removeAll(this.listingIgnore);
    }

    public boolean isCheckUpToDate() {
        return this.checkUpToDate;
    }

    public void setCheckUpToDate(boolean checkUpToDate) {
        this.checkUpToDate = checkUpToDate;
    }

    public boolean doValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getVariable(String name) {
        return this.variableContainer.getVariable(name);
    }

    public ConflictManager getDefaultConflictManager() {
        if (this.defaultConflictManager == null) {
            this.defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
            ((LatestConflictManager)this.defaultConflictManager).setSettings(this);
        }
        return this.defaultConflictManager;
    }

    public void setDefaultConflictManager(ConflictManager defaultConflictManager) {
        this.defaultConflictManager = defaultConflictManager;
    }

    public LatestStrategy getDefaultLatestStrategy() {
        if (this.defaultLatestStrategy == null) {
            this.defaultLatestStrategy = new LatestRevisionStrategy();
        }
        return this.defaultLatestStrategy;
    }

    public void setDefaultLatestStrategy(LatestStrategy defaultLatestStrategy) {
        this.defaultLatestStrategy = defaultLatestStrategy;
    }

    public LockStrategy getDefaultLockStrategy() {
        if (this.defaultLockStrategy == null) {
            this.defaultLockStrategy = new NoLockStrategy();
        }
        return this.defaultLockStrategy;
    }

    public void setDefaultLockStrategy(LockStrategy defaultLockStrategy) {
        this.defaultLockStrategy = defaultLockStrategy;
    }

    public RepositoryCacheManager getDefaultRepositoryCacheManager() {
        if (this.defaultRepositoryCacheManager == null) {
            this.defaultRepositoryCacheManager = new DefaultRepositoryCacheManager("default-cache", this, this.getDefaultRepositoryCacheBasedir());
            this.addRepositoryCacheManager(this.defaultRepositoryCacheManager);
        }
        return this.defaultRepositoryCacheManager;
    }

    public void setDefaultRepositoryCacheManager(RepositoryCacheManager cache) {
        this.defaultRepositoryCacheManager = cache;
    }

    public ResolutionCacheManager getResolutionCacheManager() {
        if (this.resolutionCacheManager == null) {
            this.resolutionCacheManager = new DefaultResolutionCacheManager(this.getDefaultResolutionCacheBasedir());
        }
        return this.resolutionCacheManager;
    }

    public void setResolutionCacheManager(ResolutionCacheManager resolutionCacheManager) {
        this.resolutionCacheManager = resolutionCacheManager;
    }

    public void addTrigger(Trigger trigger) {
        this.init(trigger);
        this.triggers.add(trigger);
    }

    public List getTriggers() {
        return this.triggers;
    }

    public void addConfigured(Trigger trigger) {
        this.addTrigger(trigger);
    }

    public boolean isUseRemoteConfig() {
        return this.useRemoteConfig;
    }

    public void setUseRemoteConfig(boolean useRemoteConfig) {
        this.useRemoteConfig = useRemoteConfig;
    }

    public boolean logModulesInUse() {
        String var = this.getVariable("ivy.log.modules.in.use");
        return var == null || Boolean.valueOf(var) != false;
    }

    public boolean logModuleWhenFound() {
        String var = this.getVariable("ivy.log.module.when.found");
        return var == null || Boolean.valueOf(var) != false;
    }

    public boolean logResolvedRevision() {
        String var = this.getVariable("ivy.log.resolved.revision");
        return var == null || Boolean.valueOf(var) != false;
    }

    public boolean debugConflictResolution() {
        if (this.debugConflictResolution == null) {
            String var = this.getVariable("ivy.log.conflict.resolution");
            this.debugConflictResolution = var != null && Boolean.valueOf(var) != false;
        }
        return this.debugConflictResolution;
    }

    public final boolean debugLocking() {
        if (this.debugLocking == null) {
            String var = this.getVariable("ivy.log.locking");
            this.debugLocking = var != null && Boolean.valueOf(var) != false;
        }
        return this.debugLocking;
    }

    public boolean dumpMemoryUsage() {
        if (this.dumpMemoryUsage == null) {
            String var = this.getVariable("ivy.log.memory");
            this.dumpMemoryUsage = var != null && Boolean.valueOf(var) != false;
        }
        return this.dumpMemoryUsage;
    }

    public boolean logNotConvertedExclusionRule() {
        return this.logNotConvertedExclusionRule;
    }

    public void setLogNotConvertedExclusionRule(boolean logNotConvertedExclusionRule) {
        this.logNotConvertedExclusionRule = logNotConvertedExclusionRule;
    }

    private void init(Object obj) {
        if (obj instanceof IvySettingsAware) {
            ((IvySettingsAware)obj).setSettings(this);
        } else if (obj instanceof DependencyResolver) {
            ((DependencyResolver)obj).setSettings(this);
        }
    }

    public long getInterruptTimeout() {
        return 2000L;
    }

    public Collection getResolvers() {
        return this.resolversMap.values();
    }

    public Collection getResolverNames() {
        return this.resolversMap.keySet();
    }

    public Collection getMatcherNames() {
        return this.matchers.keySet();
    }

    public IvyVariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    public void setVariableContainer(IvyVariableContainer variables) {
        this.variableContainer = variables;
    }

    public RelativeUrlResolver getRelativeUrlResolver() {
        return new NormalRelativeUrlResolver();
    }

    public void setDefaultCacheIvyPattern(String defaultCacheIvyPattern) {
        CacheUtil.checkCachePattern(defaultCacheIvyPattern);
        this.defaultCacheIvyPattern = defaultCacheIvyPattern;
    }

    public String getDefaultCacheIvyPattern() {
        return this.defaultCacheIvyPattern;
    }

    public void setDefaultCacheArtifactPattern(String defaultCacheArtifactPattern) {
        CacheUtil.checkCachePattern(defaultCacheArtifactPattern);
        this.defaultCacheArtifactPattern = defaultCacheArtifactPattern;
    }

    public String getDefaultCacheArtifactPattern() {
        return this.defaultCacheArtifactPattern;
    }

    public void setDefaultUseOrigin(boolean useOrigin) {
        this.defaultUseOrigin = useOrigin;
    }

    public boolean isDefaultUseOrigin() {
        return this.defaultUseOrigin;
    }

    public void useDeprecatedUseOrigin() {
        Message.deprecated("useOrigin option is deprecated when calling resolve, use useOrigin setting on the cache implementation instead");
        this.setDefaultUseOrigin(true);
    }

    public void validate() {
        this.validateAll(this.resolversMap.values());
        this.validateAll(this.conflictsManager.values());
        this.validateAll(this.latestStrategies.values());
        this.validateAll(this.lockStrategies.values());
        this.validateAll(this.repositoryCacheManagers.values());
        this.validateAll(this.reportOutputters.values());
        this.validateAll(this.circularDependencyStrategies.values());
        this.validateAll(this.versionMatchers.values());
        this.validateAll(this.namespaces.values());
    }

    private void validateAll(Collection values) {
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Validatable)) continue;
            ((Validatable)object).validate();
        }
    }

    public Namespace getContextNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    private static class ModuleSettings {
        private String resolverName;
        private String branch;
        private String conflictManager;
        private String resolveMode;

        public ModuleSettings(String resolver, String branchName, String conflictMgr, String resolveMode) {
            this.resolverName = resolver;
            this.branch = branchName;
            this.conflictManager = conflictMgr;
            this.resolveMode = resolveMode;
        }

        public String toString() {
            return (this.resolverName != null ? "resolver: " + this.resolverName : "") + (this.branch != null ? "branch: " + this.branch : "") + (this.conflictManager != null ? "conflictManager: " + this.conflictManager : "") + (this.resolveMode != null ? "resolveMode: " + this.resolveMode : "");
        }

        public String getBranch() {
            return this.branch;
        }

        public String getResolverName() {
            return this.resolverName;
        }

        public String getConflictManager() {
            return this.conflictManager;
        }

        public String getResolveMode() {
            return this.resolveMode;
        }
    }
}

