/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ning;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.PlayConfig;
import play.api.PlayConfig$;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ning.NingWSClientConfig;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u001b\tAb*\u001b8h/N\u001bE.[3oi\u000e{gNZ5h!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011\u0001\u00028j]\u001eT!!\u0002\u0004\u0002\u0005]\u001c(BA\u0004\t\u0003\u0011a\u0017NY:\u000b\u0005%Q\u0011aA1qS*\t1\"\u0001\u0003qY\u0006L8\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007]ab$D\u0001\u0019\u0015\tI\"$\u0001\u0004j]*,7\r\u001e\u0006\u00027\u0005)!.\u0019<bq&\u0011Q\u0004\u0007\u0002\t!J|g/\u001b3feB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\u0013\u001d&twmV*DY&,g\u000e^\"p]\u001aLw\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003998o\u00117jK:$8i\u001c8gS\u001e\u0004\"!\n\u0014\u000e\u0003\u0011I!a\n\u0003\u0003\u001d]\u001b6\t\\5f]R\u001cuN\u001c4jO\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003W1j\u0011\u0001C\u0005\u0003[!\u0011QbQ8oM&<WO]1uS>t\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\t\u0003WEJ!A\r\u0005\u0003\u0017\u0015sg/\u001b:p]6,g\u000e\u001e\u0005\u0006i\u0001!\t!N\u0001\u0007y%t\u0017\u000e\u001e \u0015\tY:\u0004(\u000f\t\u0003?\u0001AQaI\u001aA\u0002\u0011BQ!K\u001aA\u0002)BQaL\u001aA\u0002AB#aM\u001e\u0011\u0005]a\u0014BA\u001f\u0019\u0005\u0019IeN[3di\")q\b\u0001C\u0001\u0001\u0006\u0019q-\u001a;\u0015\u0003yAQA\u0011\u0001\u0005\u0002\u0001\u000bQ\u0001]1sg\u0016D#\u0001\u0001#\u0011\u0005])\u0015B\u0001$\u0019\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class NingWSClientConfigParser
implements Provider<NingWSClientConfig> {
    private final WSClientConfig wsClientConfig;
    private final Configuration configuration;

    public NingWSClientConfig get() {
        return this.parse();
    }

    public NingWSClientConfig parse() {
        PlayConfig config = (PlayConfig)PlayConfig$.MODULE$.apply(this.configuration).get("play.ws.ning", ConfigLoader$.MODULE$.playConfigLoader());
        boolean allowPoolingConnection = BoxesRunTime.unboxToBoolean((Object)config.get("allowPoolingConnection", ConfigLoader$.MODULE$.booleanLoader()));
        boolean allowSslConnectionPool = BoxesRunTime.unboxToBoolean((Object)config.get("allowSslConnectionPool", ConfigLoader$.MODULE$.booleanLoader()));
        int ioThreadMultiplier = BoxesRunTime.unboxToInt((Object)config.get("ioThreadMultiplier", ConfigLoader$.MODULE$.intLoader()));
        int maximumConnectionsPerHost = BoxesRunTime.unboxToInt((Object)config.get("maxConnectionsPerHost", ConfigLoader$.MODULE$.intLoader()));
        int maximumConnectionsTotal = BoxesRunTime.unboxToInt((Object)config.get("maxConnectionsTotal", ConfigLoader$.MODULE$.intLoader()));
        Duration maxConnectionLifetime = (Duration)config.get("maxConnectionLifetime", ConfigLoader$.MODULE$.durationLoader());
        Duration idleConnectionInPoolTimeout = (Duration)config.get("idleConnectionInPoolTimeout", ConfigLoader$.MODULE$.durationLoader());
        Duration webSocketIdleTimeout = (Duration)config.get("webSocketIdleTimeout", ConfigLoader$.MODULE$.durationLoader());
        int maximumNumberOfRedirects = BoxesRunTime.unboxToInt((Object)config.get("maxNumberOfRedirects", ConfigLoader$.MODULE$.intLoader()));
        int maxRequestRetry = BoxesRunTime.unboxToInt((Object)config.get("maxRequestRetry", ConfigLoader$.MODULE$.intLoader()));
        boolean disableUrlEncoding = BoxesRunTime.unboxToBoolean((Object)config.get("disableUrlEncoding", ConfigLoader$.MODULE$.booleanLoader()));
        return new NingWSClientConfig(this.wsClientConfig, allowPoolingConnection, allowSslConnectionPool, ioThreadMultiplier, maximumConnectionsPerHost, maximumConnectionsTotal, maxConnectionLifetime, idleConnectionInPoolTimeout, webSocketIdleTimeout, maximumNumberOfRedirects, maxRequestRetry, disableUrlEncoding);
    }

    @Inject
    public NingWSClientConfigParser(WSClientConfig wsClientConfig, Configuration configuration, Environment environment) {
        this.wsClientConfig = wsClientConfig;
        this.configuration = configuration;
    }
}

