/*
 * Decompiled with CFR 0.152.
 */
package activator.templates.repository;

import activator.cache.CacheProperties;
import activator.cache.Constants$;
import activator.cache.RemoteTemplateRepository;
import activator.hashing.Hash$;
import activator.package$;
import activator.package$RichIO$;
import activator.templates.repository.Layout;
import activator.templates.repository.RepositoryException;
import akka.event.LoggingAdapter;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import sbt.IO$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001%\u00111$\u0016:j%\u0016lw\u000e^3UK6\u0004H.\u0019;f%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u000b\u0019\t\u0011\u0002^3na2\fG/Z:\u000b\u0003\u001d\t\u0011\"Y2uSZ\fGo\u001c:\u0004\u0001M\u0019\u0001A\u0003\t\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g!\t\tB#D\u0001\u0013\u0015\t\u0019b!A\u0003dC\u000eDW-\u0003\u0002\u0016%\tA\"+Z7pi\u0016$V-\u001c9mCR,'+\u001a9pg&$xN]=\t\u0011]\u0001!\u0011!Q\u0001\na\tAAY1tKB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0004]\u0016$(\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u00111!\u0016*J\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013a\u00017pOB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006KZ,g\u000e\u001e\u0006\u0002O\u0005!\u0011m[6b\u0013\tICE\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ris\u0006\r\t\u0003]\u0001i\u0011A\u0001\u0005\u0006/)\u0002\r\u0001\u0007\u0005\u0006C)\u0002\rA\t\u0005\be\u0001\u0011\r\u0011\"\u00054\u0003\u0019a\u0017-_8viV\tA\u0007\u0005\u0002/k%\u0011aG\u0001\u0002\u0007\u0019\u0006Lx.\u001e;\t\ra\u0002\u0001\u0015!\u00035\u0003\u001da\u0017-_8vi\u0002BQA\u000f\u0001\u0005\nm\n\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\u0004y}\"\u0005CA\u0006>\u0013\tqDB\u0001\u0003V]&$\b\"\u0002!:\u0001\u0004\t\u0015aA;sYB\u0011\u0011DQ\u0005\u0003\u0007j\u00111!\u0016*M\u0011\u0015)\u0015\b1\u0001G\u0003\u0011!Wm\u001d;\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0012AA5p\u0013\tY\u0005J\u0001\u0003GS2,\u0007\"B'\u0001\t\u0013q\u0015AB3ySN$8\u000f\u0006\u0002P%B\u00111\u0002U\u0005\u0003#2\u0011qAQ8pY\u0016\fg\u000eC\u0003A\u0019\u0002\u0007\u0011\tC\u0003U\u0001\u0011EQ+\u0001\u0011nC.,\u0007K]8ys\u0006\u0014G.Z\"mS\u0016tGoQ8oM&<WO]1uS>tG#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!C1nCj|g.Y<t\u0015\u0005Y\u0016aA2p[&\u0011Q\f\u0017\u0002\u0014\u00072LWM\u001c;D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006?\u0002!\t\u0002Y\u0001\u000b[\u0006\\Wm\u00117jK:$H#A1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017AA:4\u0015\t1\u0007,\u0001\u0005tKJ4\u0018nY3t\u0013\tA7M\u0001\bB[\u0006TxN\\*4\u00072LWM\u001c;\t\u000b)\u0004A\u0011B6\u0002\u001b\rdW-\u00198M_\u000e\fG/[8o)\ta7\u000f\u0005\u0002na:\u00111B\\\u0005\u0003_2\ta\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011q\u000e\u0004\u0005\u0006i&\u0004\r\u0001\\\u0001\u0005a\u0006$\b\u000eC\u0003w\u0001\u0011Eq/\u0001\be_^tGn\\1e\rJ|WnU\u001a\u0015\u0007qB\u0018\u0010C\u0003Ak\u0002\u0007\u0001\u0004C\u0003Fk\u0002\u0007a\tC\u0003|\u0001\u0011EA0\u0001\u0007fq&\u001cHo\u001d$s_6\u001c6\u0007\u0006\u0002P{\")\u0001I\u001fa\u00011!1q\u0010\u0001C\u0005\u0003\u0003\tQ\u0003Z8x]2|\u0017\r\u001a+ss&twmU\u001aGSJ\u001cH\u000fF\u0003G\u0003\u0007\t9\u0001\u0003\u0004\u0002\u0006y\u0004\r\u0001G\u0001\u0004kJL\u0007BBA\u0005}\u0002\u0007a)\u0001\u0004u_\u001aKG.\u001a\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0003M)\u00070[:ugR\u0013\u00180\u001b8h'N2\u0015N]:u)\ry\u0015\u0011\u0003\u0005\b\u0003\u000b\tY\u00011\u0001\u0019\u0011\u001d\t)\u0002\u0001C\t\u0003/\tqbZ3u\u0005V\u001c7.\u001a;B]\u0012\\U-\u001f\u000b\u0005\u00033\ty\u0002E\u0003\f\u00037aG.C\u0002\u0002\u001e1\u0011a\u0001V;qY\u0016\u0014\u0004B\u0002!\u0002\u0014\u0001\u0007\u0001\u0004C\u0004\u0002$\u0001!\t!!\n\u0002#I,7o\u001c7wKR+W\u000e\u001d7bi\u0016$v\u000eF\u0003G\u0003O\tY\u0003C\u0004\u0002*\u0005\u0005\u0002\u0019\u00017\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0004\u0002.\u0005\u0005\u0002\u0019\u0001$\u0002\u00111|7-\u00197ESJDq!!\r\u0001\t\u0003\t\u0019$A\u000biCNtUm^%oI\u0016D\bK]8qKJ$\u0018.Z:\u0015\u0007=\u000b)\u0004C\u0004\u00028\u0005=\u0002\u0019\u00017\u0002\u0017\r,(O]3oi\"\u000b7\u000f\u001b\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003Y\u0011Xm]8mm\u0016d\u0015\r^3ti&sG-\u001a=ICNDG#\u00017\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D\u0005!\u0012N\u001a(fo&sG-\u001a=Qe>\u0004XM\u001d;jKN$B!!\u0012\u0002XQ\u0019A(a\u0012\t\u0011\u0005%\u0013q\ba\u0001\u0003\u0017\n!b\u001c8OK^Le\u000eZ3y!\u0019Y\u0011QJA)y%\u0019\u0011q\n\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\t\u0002T%\u0019\u0011Q\u000b\n\u0003\u001f\r\u000b7\r[3Qe>\u0004XM\u001d;jKNDq!a\u000e\u0002@\u0001\u0007A\u000eC\u0004\u0002\\\u0001!I!!\u0018\u00025\u0011|wO\u001c7pC\u0012tUm^%oI\u0016D\bK]8qKJ$\u0018.Z:\u0016\t\u0005}\u0013\u0011\u000e\u000b\u0005\u0003C\n\u0019\u000b\u0006\u0003\u0002d\u0005}E\u0003BA3\u0003w\u0002B!a\u001a\u0002j1\u0001A\u0001CA6\u00033\u0012\r!!\u001c\u0003\u0003Q\u000bB!a\u001c\u0002vA\u00191\"!\u001d\n\u0007\u0005MDBA\u0004O_RD\u0017N\\4\u0011\u0007-\t9(C\u0002\u0002z1\u00111!\u00118z\u0011!\ti(!\u0017A\u0002\u0005}\u0014!D8o\u001d>$h*Z<J]\u0012,\u0007\u0010E\u0004\f\u0003\u001b\n\t)!\u001a\u0011\u000b-\t\u0019)a\"\n\u0007\u0005\u0015EB\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\u000bIJ\u0004\u0003\u0002\f\u0006Ue\u0002BAG\u0003'k!!a$\u000b\u0007\u0005E\u0005\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0019\u0011q\u0013\u0007\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u00182A\u0001\"!\u0013\u0002Z\u0001\u0007\u0011\u0011\u0015\t\b\u0017\u00055\u0013\u0011KA3\u0011\u001d\t9$!\u0017A\u00021Dq!a*\u0001\t\u0003\tI+\u0001\bsKN|GN^3J]\u0012,\u0007\u0010V8\u0015\u000bq\nY+a,\t\u000f\u00055\u0016Q\u0015a\u0001\r\u0006q\u0011N\u001c3fq\u0012K'o\u0014:GS2,\u0007bBAY\u0003K\u0003\r\u0001\\\u0001\nS:$W\r\u001f%bg\"Dq!!.\u0001\t\u0003\t9,\u0001\fsKN|GN^3J]\u0012,\u0007\u0010\u0015:pa\u0016\u0014H/[3t)\r1\u0015\u0011\u0018\u0005\b\u0003w\u000b\u0019\f1\u0001G\u00039awnY1m!J|\u0007o\u001d$jY\u0016Dq!a0\u0001\t\u0003\n\t-A\u000esKN|GN^3NS:LW.\u00197BGRLg/\u0019;pe\u0012K7\u000f\u001e\u000b\u0006\r\u0006\r\u0017Q\u0019\u0005\b\u0003\u0013\ti\f1\u0001G\u0011\u001d\t9-!0A\u00021\f\u0001#Y2uSZ\fGo\u001c:WKJ\u001c\u0018n\u001c8\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\u0006\tB/Z7qY\u0006$XMQ;oI2,WKU%\u0015\u000fa\ty-!5\u0002b\"9\u0011qYAe\u0001\u0004a\u0007\u0002CAj\u0003\u0013\u0004\r!!6\u0002\tU,\u0018\u000e\u001a\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\u001c\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003?\fIN\u0001\u0003V+&#\u0005bBAr\u0003\u0013\u0004\r\u0001\\\u0001\ri\u0016l\u0007\u000f\\1uK:\u000bW.\u001a\u0005\b\u0003O\u0004A\u0011IAu\u00035\tW\u000f\u001e5pe2{wm\\+S\u0013R\u0019\u0001$a;\t\u0011\u0005M\u0017Q\u001da\u0001\u0003+Dq!a<\u0001\t\u0003\n\t0\u0001\u000buK6\u0004H.\u0019;f\u0005VtG\r\\3Fq&\u001cHo\u001d\u000b\b\u001f\u0006M\u0018Q_A|\u0011\u001d\t9-!<A\u00021D\u0001\"a5\u0002n\u0002\u0007\u0011Q\u001b\u0005\b\u0003G\fi\u000f1\u0001m\u0011\u001d\tY\u0010\u0001C!\u0003{\fa\u0002^3na2\fG/\u001a.jaV\u0013\u0016\nF\u0002\u0019\u0003\u007fD\u0001\"a5\u0002z\u0002\u0007\u0011Q\u001b")
public class UriRemoteTemplateRepository
implements RemoteTemplateRepository {
    private final URI base;
    public final LoggingAdapter activator$templates$repository$UriRemoteTemplateRepository$$log;
    private final Layout layout;

    public Layout layout() {
        return this.layout;
    }

    public void activator$templates$repository$UriRemoteTemplateRepository$$download(URL url, File dest) {
        this.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading url ", " underneath base ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, this.base})));
        try {
            IO$.MODULE$.download(url, dest);
            return;
        }
        catch (Exception exception) {
            this.activator$templates$repository$UriRemoteTemplateRepository$$log.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download ", ": ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, exception.getClass().getName(), exception.getMessage()})));
            throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download ", ": ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, exception.getClass().getName(), exception.getMessage()})), exception);
        }
    }

    private boolean exists(URL url) {
        this.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking HEAD for url ", " underneath base ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, this.base})));
        try {
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                boolean bl;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("HEAD");
                int n = httpURLConnection.getResponseCode();
                switch (n) {
                    default: {
                        this.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response code ", " from HEAD on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), url})));
                        bl = false;
                        break;
                    }
                    case 200: {
                        bl = true;
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            throw new Exception(new StringBuilder().append((Object)"Got weird non-http connection ").append((Object)uRLConnection).toString());
        }
        catch (Exception exception) {
            this.activator$templates$repository$UriRemoteTemplateRepository$$log.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download ", ": ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, exception.getClass().getName(), exception.getMessage()})));
            throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download ", ": ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, exception.getClass().getName(), exception.getMessage()})), exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClientConfiguration makeProxyableClientConfiguration() {
        void var1_1;
        ClientConfiguration config = new ClientConfiguration().withProtocol(Protocol.HTTPS);
        this.doIf$1("http.proxyHost", (Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final ClientConfiguration config$1;

            public final void apply(String x$1) {
                this.config$1.setProxyHost(x$1);
            }
            {
                this.config$1 = config$1;
            }
        });
        this.doIf$1("http.proxyPort", (Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final ClientConfiguration config$1;

            public final void apply(String portString) {
                this.config$1.setProxyPort(new StringOps(Predef$.MODULE$.augmentString(portString)).toInt());
            }
            {
                this.config$1 = config$1;
            }
        });
        this.doIf$1("http.proxyUser", (Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final ClientConfiguration config$1;

            public final void apply(String x$1) {
                this.config$1.setProxyUsername(x$1);
            }
            {
                this.config$1 = config$1;
            }
        });
        this.doIf$1("http.proxyPassword", (Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final ClientConfiguration config$1;

            public final void apply(String x$1) {
                this.config$1.setProxyPassword(x$1);
            }
            {
                this.config$1 = config$1;
            }
        });
        config.setConnectionTimeout(5000);
        return var1_1;
    }

    public AmazonS3Client makeClient() {
        return new AmazonS3Client((AWSCredentials)new AnonymousAWSCredentials(), this.makeProxyableClientConfiguration());
    }

    private String cleanLocation(String path) {
        return path.startsWith("/") ? (String)new StringOps(Predef$.MODULE$.augmentString(path)).drop(1) : path;
    }

    public void downloadFromS3(URI url, File dest) {
        try {
            this.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading S3 bucket ", " underneath base ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, this.base})));
            AmazonS3Client client = this.makeClient();
            Tuple2<String, String> tuple2 = this.getBucketAndKey(url);
            if (tuple2 != null) {
                Tuple2 tuple22;
                String bucket = (String)tuple2._1();
                String key = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)bucket, (Object)key);
                String bucket2 = (String)tuple23._1();
                String key2 = (String)tuple23._2();
                GetObjectRequest request = new GetObjectRequest(bucket2, key2);
                client.getObject(request, dest);
                return;
            }
            throw new MatchError(tuple2);
        }
        catch (Exception exception) {
            throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download ", " from s3: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, exception.getClass().getName(), exception.getMessage()})), exception);
        }
    }

    public boolean existsFromS3(URI url) {
        AmazonServiceException amazonServiceException2;
        block4: {
            boolean bl;
            try {
                Tuple2 tuple2;
                this.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking existence of ", " underneath base ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, this.base})));
                AmazonS3Client client = this.makeClient();
                Tuple2<String, String> tuple22 = this.getBucketAndKey(url);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                String bucket = (String)tuple22._1();
                String key = (String)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)bucket, (Object)key);
                String bucket2 = (String)tuple23._1();
                String key2 = (String)tuple23._2();
                GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucket2, key2);
                client.getObjectMetadata(request);
                bl = true;
            }
            catch (Exception exception) {
                throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check existence of ", " on s3: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, exception.getClass().getName(), exception.getMessage()})), exception);
            }
            catch (AmazonServiceException amazonServiceException2) {
                if (amazonServiceException2.getStatusCode() != 404) break block4;
                this.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"404 on S3 object ", ": ", ": ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, BoxesRunTime.boxToInteger((int)amazonServiceException2.getStatusCode()), amazonServiceException2.getErrorCode(), amazonServiceException2.getMessage()})));
                bl = false;
            }
            return bl;
        }
        throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check existence of ", " on s3: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, ((Object)((Object)amazonServiceException2)).getClass().getName(), amazonServiceException2.getMessage()})), amazonServiceException2);
    }

    private File downloadTryingS3First(URI uri, File toFile) {
        try {
            this.downloadFromS3(uri, toFile);
        }
        catch (RepositoryException repositoryException) {
            this.activator$templates$repository$UriRemoteTemplateRepository$$log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to grab s3 bucket, attempting to use http to '", "'. (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri, repositoryException.msg()})));
            this.activator$templates$repository$UriRemoteTemplateRepository$$download(uri.toURL(), toFile);
        }
        return toFile;
    }

    private boolean existsTryingS3First(URI uri) {
        boolean bl;
        try {
            bl = this.existsFromS3(uri);
        }
        catch (RepositoryException repositoryException) {
            this.activator$templates$repository$UriRemoteTemplateRepository$$log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to grab s3 bucket, attempting to use http to '", "'. (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri, repositoryException.msg()})));
            bl = this.exists(uri.toURL());
        }
        return bl;
    }

    public Tuple2<String, String> getBucketAndKey(URI url) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)url.getHost()), (Object)this.cleanLocation(url.getRawPath()));
    }

    @Override
    public File resolveTemplateTo(String templateId, File localDir) {
        IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable(this, templateId, localDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UriRemoteTemplateRepository $outer;
            private final String templateId$1;
            private final File localDir$1;

            public final Set<File> apply(File tmpDir) {
                File tmpFile = new File(tmpDir, "template.zip");
                this.$outer.activator$templates$repository$UriRemoteTemplateRepository$$download(this.$outer.layout().template(this.templateId$1).toURL(), tmpFile);
                return (Set)package$RichIO$.MODULE$.createViaTemporary$extension(package$.MODULE$.RichIO(IO$.MODULE$), this.localDir$1, new Serializable(this, tmpFile){
                    public static final long serialVersionUID = 0L;
                    private final File tmpFile$1;

                    public final Set<File> apply(File templateDir) {
                        return IO$.MODULE$.unzip(this.tmpFile$1, templateDir, IO$.MODULE$.unzip$default$3(), IO$.MODULE$.unzip$default$4());
                    }
                    {
                        this.tmpFile$1 = tmpFile$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.templateId$1 = templateId$1;
                this.localDir$1 = localDir$1;
            }
        });
        return localDir;
    }

    @Override
    public boolean hasNewIndexProperties(String currentHash) {
        return BoxesRunTime.unboxToBoolean(this.downloadNewIndexProperties(currentHash, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CacheProperties x$3) {
                return true;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Throwable> x$4) {
                return false;
            }
        }));
    }

    @Override
    public String resolveLatestIndexHash() {
        return (String)this.downloadNewIndexProperties("", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CacheProperties props) {
                return (String)props.cacheIndexHash().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new RepositoryException("index properties file didn't have a hash in it", null);
                    }
                });
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Option<Throwable> optionalThrowable) {
                return (Nothing$)optionalThrowable.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply(Throwable x$5) {
                        throw x$5;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new RepositoryException("Unable to download latest index hash", null);
                    }
                });
            }
        });
    }

    @Override
    public void ifNewIndexProperties(String currentHash, Function1<CacheProperties, BoxedUnit> onNewIndex) {
        this.downloadNewIndexProperties(currentHash, (Function1)onNewIndex, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Option<Throwable> x$6) {
            }
        });
    }

    private <T> T downloadNewIndexProperties(String currentHash, Function1<CacheProperties, T> onNewIndex, Function1<Option<Throwable>, T> onNotNewIndex) {
        Object object;
        try {
            object = IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable(this, currentHash, onNewIndex, onNotNewIndex){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UriRemoteTemplateRepository $outer;
                private final String currentHash$1;
                private final Function1 onNewIndex$1;
                private final Function1 onNotNewIndex$1;

                public final T apply(File tmpDir) {
                    Object object;
                    File indexProps = new File(tmpDir, "index.properties");
                    this.$outer.resolveIndexProperties(indexProps);
                    CacheProperties props = new CacheProperties(indexProps);
                    String newHash = (String)props.cacheIndexHash().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Nothing$ apply() {
                            throw new RepositoryException("Downloaded catalog properties didn't contain a new index hash", null);
                        }
                    });
                    if (this.differentCache$1(newHash) && this.recentEnough$1(props)) {
                        this.$outer.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a new template catalog with hash ", " (we had ", " before)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHash, this.currentHash$1})));
                        object = this.onNewIndex$1.apply((Object)props);
                    } else {
                        if (this.differentCache$1(newHash)) {
                            throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Template catalog has been updated, but we can only use catalogs with version ", ".", " and we found ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Constants$.MODULE$.INDEX_BINARY_MAJOR_VERSION()), BoxesRunTime.boxToInteger((int)Constants$.MODULE$.INDEX_BINARY_INCREMENT_VERSION()), BoxesRunTime.boxToInteger((int)props.cacheIndexBinaryMajorVersion()), BoxesRunTime.boxToInteger((int)props.cacheIndexBinaryIncrementVersion())})), null);
                        }
                        this.$outer.activator$templates$repository$UriRemoteTemplateRepository$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Template catalog is unchanged since we last downloaded it, we already have ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentHash$1})));
                        object = this.onNotNewIndex$1.apply((Object)None$.MODULE$);
                    }
                    return (T)object;
                }

                private final boolean recentEnough$1(CacheProperties props$1) {
                    return props$1.cacheIndexBinaryMajorVersion() == Constants$.MODULE$.INDEX_BINARY_MAJOR_VERSION() && props$1.cacheIndexBinaryIncrementVersion() >= Constants$.MODULE$.INDEX_BINARY_INCREMENT_VERSION();
                }

                private final boolean differentCache$1(String newHash$1) {
                    String string = newHash$1;
                    String string2 = this.currentHash$1;
                    return string != null ? !string.equals(string2) : string2 != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentHash$1 = currentHash$1;
                    this.onNewIndex$1 = onNewIndex$1;
                    this.onNotNewIndex$1 = onNotNewIndex$1;
                }
            });
        }
        catch (Throwable throwable) {
            Object object2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.activator$templates$repository$UriRemoteTemplateRepository$$log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download new template catalog properties: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getClass().getName(), e.getMessage()})));
            object = object2 = onNotNewIndex.apply((Object)new Some((Object)e));
        }
        return (T)object;
    }

    @Override
    public void resolveIndexTo(File indexDirOrFile, String indexHash) {
        IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable(this, indexDirOrFile, indexHash){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UriRemoteTemplateRepository $outer;
            private final File indexDirOrFile$1;
            private final String indexHash$1;

            /*
             * WARNING - void declaration
             */
            public final Set<File> apply(File tmpDir) {
                void var4_4;
                void var3_3;
                String zipHash;
                File indexZip = new File(tmpDir, "index.zip");
                URL url = this.$outer.layout().index(this.indexHash$1).toURL();
                this.$outer.activator$templates$repository$UriRemoteTemplateRepository$$download(url, indexZip);
                String string = zipHash = activator.hashing.package$.MODULE$.hash((Object)indexZip, Hash$.MODULE$.fileSha1Hasher());
                String string2 = this.indexHash$1;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return (Set)package$RichIO$.MODULE$.createViaTemporary$extension(package$.MODULE$.RichIO(IO$.MODULE$), this.indexDirOrFile$1, new Serializable(this, indexZip){
                        public static final long serialVersionUID = 0L;
                        private final File indexZip$1;

                        public final Set<File> apply(File indexExpanded) {
                            return IO$.MODULE$.unzip(this.indexZip$1, indexExpanded, IO$.MODULE$.unzip$default$3(), IO$.MODULE$.unzip$default$4());
                        }
                        {
                            this.indexZip$1 = indexZip$1;
                        }
                    });
                }
                throw new RepositoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected hash of ", " to be ", " but it was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3, this.indexHash$1, var4_4})), null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.indexDirOrFile$1 = indexDirOrFile$1;
                this.indexHash$1 = indexHash$1;
            }
        });
    }

    @Override
    public File resolveIndexProperties(File localPropsFile) {
        return this.downloadTryingS3First(this.layout().currentIndexTag(), localPropsFile);
    }

    @Override
    public File resolveMinimalActivatorDist(File toFile, String activatorVersion) {
        return this.downloadTryingS3First(this.layout().minimalActivatorDist(activatorVersion), toFile);
    }

    @Override
    public URI templateBundleURI(String activatorVersion, UUID uuid, String templateName) {
        return this.layout().templateBundle(activatorVersion, uuid.toString(), templateName);
    }

    @Override
    public URI authorLogoURI(UUID uuid) {
        return this.layout().authorLogo(uuid.toString());
    }

    @Override
    public boolean templateBundleExists(String activatorVersion, UUID uuid, String templateName) {
        return this.existsTryingS3First(this.templateBundleURI(activatorVersion, uuid, templateName));
    }

    @Override
    public URI templateZipURI(UUID uuid) {
        return this.layout().template(uuid.toString());
    }

    private final void doIf$1(String prop, Function1 f) {
        scala.sys.package$.MODULE$.props().get(prop).foreach(f);
    }

    public UriRemoteTemplateRepository(URI base, LoggingAdapter log) {
        this.base = base;
        this.activator$templates$repository$UriRemoteTemplateRepository$$log = log;
        this.layout = new Layout(base);
    }
}

