/*
 * Decompiled with CFR 0.152.
 */
package activator.cache;

import activator.cache.IndexStoredTemplateMetadata;
import activator.cache.LongString$;
import activator.cache.TemplateMetadata;
import activator.cache.TemplateMetadata$;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.Version;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class LuceneIndex$ {
    public static final LuceneIndex$ MODULE$;
    private final String FIELD_ID;
    private final String FIELD_NAME;
    private final String FIELD_TITLE;
    private final String FIELD_DESC;
    private final String FIELD_TS;
    private final String FIELD_CREATION_TIME;
    private final String FIELD_TAGS;
    private final String FIELD_FEATURED;
    private final String FIELD_USAGE_COUNT;
    private final String FIELD_AUTHOR_NAME;
    private final String FIELD_AUTHOR_LINK;
    private final String FIELD_AUTHOR_LOGO;
    private final String FIELD_AUTHOR_BIO;
    private final String FIELD_AUTHOR_TWITTER;
    private final String FIELD_TEMPLATE_TEMPLATE;
    private final String FIELD_SOURCE_LINK;
    private final String FIELD_CATEGORY;
    private final String FIELD_TRUE_VALUE;
    private final String FIELD_FALSE_VALUE;
    private final String FIELD_NONE_VALUE;
    private final Version LUCENE_VERSION;
    private final StandardAnalyzer analyzer;

    static {
        new LuceneIndex$();
    }

    public String FIELD_ID() {
        return this.FIELD_ID;
    }

    public String FIELD_NAME() {
        return this.FIELD_NAME;
    }

    public String FIELD_TITLE() {
        return this.FIELD_TITLE;
    }

    public String FIELD_DESC() {
        return this.FIELD_DESC;
    }

    public String FIELD_TS() {
        return this.FIELD_TS;
    }

    public String FIELD_CREATION_TIME() {
        return this.FIELD_CREATION_TIME;
    }

    public String FIELD_TAGS() {
        return this.FIELD_TAGS;
    }

    public String FIELD_FEATURED() {
        return this.FIELD_FEATURED;
    }

    public String FIELD_USAGE_COUNT() {
        return this.FIELD_USAGE_COUNT;
    }

    public String FIELD_AUTHOR_NAME() {
        return this.FIELD_AUTHOR_NAME;
    }

    public String FIELD_AUTHOR_LINK() {
        return this.FIELD_AUTHOR_LINK;
    }

    public String FIELD_AUTHOR_LOGO() {
        return this.FIELD_AUTHOR_LOGO;
    }

    public String FIELD_AUTHOR_BIO() {
        return this.FIELD_AUTHOR_BIO;
    }

    public String FIELD_AUTHOR_TWITTER() {
        return this.FIELD_AUTHOR_TWITTER;
    }

    public String FIELD_TEMPLATE_TEMPLATE() {
        return this.FIELD_TEMPLATE_TEMPLATE;
    }

    public String FIELD_SOURCE_LINK() {
        return this.FIELD_SOURCE_LINK;
    }

    public String FIELD_CATEGORY() {
        return this.FIELD_CATEGORY;
    }

    public String FIELD_TRUE_VALUE() {
        return this.FIELD_TRUE_VALUE;
    }

    public String FIELD_FALSE_VALUE() {
        return this.FIELD_FALSE_VALUE;
    }

    public String FIELD_NONE_VALUE() {
        return this.FIELD_NONE_VALUE;
    }

    public Version LUCENE_VERSION() {
        return this.LUCENE_VERSION;
    }

    public StandardAnalyzer analyzer() {
        return this.analyzer;
    }

    public IndexStoredTemplateMetadata documentToMetadata(Document doc) {
        None$ none$;
        String id = doc.get(this.FIELD_ID());
        String name = doc.get(this.FIELD_NAME());
        String title = doc.get(this.FIELD_TITLE());
        long ts = new StringOps(Predef$.MODULE$.augmentString(doc.get(this.FIELD_TS()))).toLong();
        long creationTime = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)doc.get(this.FIELD_CREATION_TIME())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return TemplateMetadata$.MODULE$.LEGACY_CREATION_TIME();
            }
        }));
        String desc = doc.get(this.FIELD_DESC());
        String authorName = doc.get(this.FIELD_AUTHOR_NAME());
        String authorLink = doc.get(this.FIELD_AUTHOR_LINK());
        Option authorLogo = Option$.MODULE$.apply((Object)doc.get(this.FIELD_AUTHOR_LOGO()));
        Option authorBio = Option$.MODULE$.apply((Object)doc.get(this.FIELD_AUTHOR_BIO()));
        Option authorTwitter = Option$.MODULE$.apply((Object)doc.get(this.FIELD_AUTHOR_TWITTER()));
        String[] tags = doc.get(this.FIELD_TAGS()).split(",");
        String string = doc.get(this.FIELD_USAGE_COUNT());
        String string2 = this.FIELD_NONE_VALUE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            none$ = None$.MODULE$;
        } else {
            Option<Object> option = LongString$.MODULE$.unapply(string);
            if (option.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                long num = BoxesRunTime.unboxToLong((Object)option.get());
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)num));
            }
        }
        None$ usageCount = none$;
        String string4 = doc.get(this.FIELD_FEATURED());
        String string5 = this.FIELD_TRUE_VALUE();
        boolean featured2 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        String string6 = doc.get(this.FIELD_TEMPLATE_TEMPLATE());
        String string7 = this.FIELD_TRUE_VALUE();
        boolean templateTemplate = !(string6 != null ? !string6.equals(string7) : string7 != null);
        Option sourceLink = Option$.MODULE$.apply((Object)doc.get(this.FIELD_SOURCE_LINK()));
        String category = (String)Option$.MODULE$.apply((Object)doc.get(this.FIELD_CATEGORY())).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return TemplateMetadata.Category$.MODULE$.UNKNOWN();
            }
        });
        return new IndexStoredTemplateMetadata(id, name, title, desc, authorName, authorLink, authorLogo, authorBio, authorTwitter, (Seq)Predef$.MODULE$.wrapRefArray((Object[])tags), ts, creationTime, featured2, (Option)usageCount, templateTemplate, (String)sourceLink.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "http://typesafe.com/";
            }
        }), category);
    }

    /*
     * WARNING - void declaration
     */
    public Document metadataToDocument(IndexStoredTemplateMetadata metadata2) {
        void var2_2;
        Document doc = new Document();
        doc.add((IndexableField)new StringField(this.FIELD_ID(), metadata2.id(), Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_NAME(), metadata2.name(), Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_TITLE(), metadata2.title(), Field.Store.YES));
        doc.add((IndexableField)new LongField(this.FIELD_TS(), metadata2.timeStamp(), Field.Store.YES));
        doc.add((IndexableField)new LongField(this.FIELD_CREATION_TIME(), metadata2.creationTime(), Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_DESC(), metadata2.description(), Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_AUTHOR_NAME(), metadata2.authorName(), Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_AUTHOR_LINK(), metadata2.authorLink(), Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_TAGS(), metadata2.tags().mkString(","), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_FEATURED(), this.booleanToString(metadata2.featured()), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_USAGE_COUNT(), this.usageToString((Option<Object>)metadata2.usageCount()), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_TEMPLATE_TEMPLATE(), this.booleanToString(metadata2.templateTemplate()), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_SOURCE_LINK(), metadata2.sourceLink(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_CATEGORY(), metadata2.category(), Field.Store.YES));
        metadata2.authorLogo().foreach((Function1)new Serializable(doc){
            public static final long serialVersionUID = 0L;
            private final Document doc$1;

            public final void apply(String logo) {
                this.doc$1.add((IndexableField)new StringField(LuceneIndex$.MODULE$.FIELD_AUTHOR_LOGO(), logo, Field.Store.YES));
            }
            {
                this.doc$1 = doc$1;
            }
        });
        metadata2.authorBio().foreach((Function1)new Serializable(doc){
            public static final long serialVersionUID = 0L;
            private final Document doc$1;

            public final void apply(String bio) {
                this.doc$1.add((IndexableField)new TextField(LuceneIndex$.MODULE$.FIELD_AUTHOR_BIO(), bio, Field.Store.YES));
            }
            {
                this.doc$1 = doc$1;
            }
        });
        metadata2.authorTwitter().foreach((Function1)new Serializable(doc){
            public static final long serialVersionUID = 0L;
            private final Document doc$1;

            public final void apply(String twitter) {
                this.doc$1.add((IndexableField)new StringField(LuceneIndex$.MODULE$.FIELD_AUTHOR_TWITTER(), twitter, Field.Store.YES));
            }
            {
                this.doc$1 = doc$1;
            }
        });
        return var2_2;
    }

    private String booleanToString(boolean featured2) {
        return featured2 ? this.FIELD_TRUE_VALUE() : this.FIELD_FALSE_VALUE();
    }

    private String usageToString(Option<Object> usage) {
        Option<Object> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = usage;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    long num = BoxesRunTime.unboxToLong((Object)some.x());
                    string = ((Object)BoxesRunTime.boxToLong((long)num)).toString();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                string = this.FIELD_NONE_VALUE();
            }
            return string;
        }
        throw new MatchError(option);
    }

    private LuceneIndex$() {
        MODULE$ = this;
        this.FIELD_ID = "id";
        this.FIELD_NAME = "name";
        this.FIELD_TITLE = "title";
        this.FIELD_DESC = "description";
        this.FIELD_TS = "timestamp";
        this.FIELD_CREATION_TIME = "creationTime";
        this.FIELD_TAGS = "tags";
        this.FIELD_FEATURED = "featured";
        this.FIELD_USAGE_COUNT = "usageCount";
        this.FIELD_AUTHOR_NAME = "authorName";
        this.FIELD_AUTHOR_LINK = "authorLink";
        this.FIELD_AUTHOR_LOGO = "authorLogo";
        this.FIELD_AUTHOR_BIO = "authorBio";
        this.FIELD_AUTHOR_TWITTER = "authorTwitter";
        this.FIELD_TEMPLATE_TEMPLATE = "templateTemplate";
        this.FIELD_SOURCE_LINK = "sourceLink";
        this.FIELD_CATEGORY = "category";
        this.FIELD_TRUE_VALUE = "true";
        this.FIELD_FALSE_VALUE = "false";
        this.FIELD_NONE_VALUE = "None";
        this.LUCENE_VERSION = Version.LUCENE_43;
        this.analyzer = new StandardAnalyzer(this.LUCENE_VERSION());
    }
}

