/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webjars.MultipleMatchesException;
import org.webjars.urlprotocols.UrlProtocolHandler;

public class WebJarAssetLocator {
    public static final String WEBJARS_PACKAGE = "META-INF.resources.webjars";
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static final Comparator<String> IGNORE_CASE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private static Pattern WEBJAR_EXTRACTOR_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]*)/([^/]*)/(.*)$");
    final SortedMap<String, String> fullPathIndex;

    private static void aggregateFile(File file, Set<String> aggregatedChildren, Pattern filterExpr) {
        String path = file.getPath().replace('\\', '/');
        String relativePath = path.substring(path.indexOf(WEBJARS_PATH_PREFIX));
        if (filterExpr.matcher(relativePath).matches()) {
            aggregatedChildren.add(relativePath);
        }
    }

    static Set<URL> listParentURLsWithResource(ClassLoader[] classLoaders, String resource) {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader classLoader : classLoaders) {
            try {
                Enumeration<URL> enumeration = classLoader.getResources(resource);
                while (enumeration.hasMoreElements()) {
                    urls.add(enumeration.nextElement());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    private static Set<String> getAssetPaths(Pattern filterExpr, ClassLoader ... classLoaders) {
        HashSet<String> assetPaths = new HashSet<String>();
        Set<URL> urls = WebJarAssetLocator.listParentURLsWithResource(classLoaders, WEBJARS_PATH_PREFIX);
        ServiceLoader<UrlProtocolHandler> urlProtocolHandlers = ServiceLoader.load(UrlProtocolHandler.class);
        block0: for (URL url : urls) {
            for (UrlProtocolHandler urlProtocolHandler : urlProtocolHandlers) {
                Set<String> assetPathSet;
                if (!urlProtocolHandler.accepts(url.getProtocol()) || (assetPathSet = urlProtocolHandler.getAssetPaths(url, filterExpr, classLoaders)) == null) continue;
                assetPaths.addAll(assetPathSet);
                continue block0;
            }
        }
        return assetPaths;
    }

    public static SortedMap<String, String> getFullPathIndex(Pattern filterExpr, ClassLoader ... classLoaders) {
        Set<String> assetPaths = WebJarAssetLocator.getAssetPaths(filterExpr, classLoaders);
        TreeMap<String, String> assetPathIndex = new TreeMap<String, String>();
        for (String assetPath : assetPaths) {
            assetPathIndex.put(WebJarAssetLocator.reversePath(assetPath), assetPath);
        }
        return assetPathIndex;
    }

    private static String reversePath(String assetPath) {
        String[] assetPathComponents = assetPath.split("/");
        StringBuilder reversedAssetPath = new StringBuilder();
        for (int i = assetPathComponents.length - 1; i >= 0; --i) {
            reversedAssetPath.append(assetPathComponents[i]);
            reversedAssetPath.append('/');
        }
        return reversedAssetPath.toString();
    }

    public WebJarAssetLocator() {
        this(WebJarAssetLocator.getFullPathIndex(Pattern.compile(".*"), WebJarAssetLocator.class.getClassLoader()));
    }

    public WebJarAssetLocator(SortedMap<String, String> fullPathIndex) {
        this.fullPathIndex = fullPathIndex;
    }

    public WebJarAssetLocator(Set<String> assetPaths) {
        this.fullPathIndex = new TreeMap<String, String>();
        for (String assetPath : assetPaths) {
            this.fullPathIndex.put(WebJarAssetLocator.reversePath(assetPath), assetPath);
        }
    }

    private String throwNotFoundException(String partialPath) {
        throw new IllegalArgumentException(partialPath + " could not be found. Make sure you've added the corresponding WebJar and please check for typos.");
    }

    public String getFullPath(String partialPath) {
        return this.getFullPath(this.fullPathIndex, partialPath);
    }

    public String getFullPath(String webjar, String partialPath) {
        return this.getFullPath(this.filterPathIndexByPrefix(this.fullPathIndex, "META-INF/resources/webjars/" + webjar), partialPath);
    }

    private String getFullPath(SortedMap<String, String> pathIndex, String partialPath) {
        Iterator<Map.Entry<String, String>> fullPathTailIter;
        Map.Entry<String, String> fullPathEntry;
        String reversePartialPath;
        SortedMap<String, String> fullPathTail;
        if (partialPath.charAt(0) == '/') {
            partialPath = partialPath.substring(1);
        }
        if ((fullPathTail = pathIndex.tailMap(reversePartialPath = WebJarAssetLocator.reversePath(partialPath))).size() == 0) {
            this.throwNotFoundException(partialPath);
        }
        if (!(fullPathEntry = (fullPathTailIter = fullPathTail.entrySet().iterator()).next()).getKey().startsWith(reversePartialPath)) {
            this.throwNotFoundException(partialPath);
        }
        String fullPath = fullPathEntry.getValue();
        if (fullPathTailIter.hasNext()) {
            Map.Entry<String, String> next;
            ArrayList<String> matches = null;
            while (fullPathTailIter.hasNext() && (next = fullPathTailIter.next()).getKey().startsWith(reversePartialPath)) {
                if (matches == null) {
                    matches = new ArrayList<String>();
                }
                matches.add(next.getValue());
            }
            if (matches != null) {
                matches.add(fullPath);
                throw new MultipleMatchesException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.", matches);
            }
        }
        return fullPath;
    }

    private SortedMap<String, String> filterPathIndexByPrefix(SortedMap<String, String> pathIndex, String prefix) {
        TreeMap<String, String> filteredPathIndex = new TreeMap<String, String>();
        for (String key : pathIndex.keySet()) {
            String value = (String)pathIndex.get(key);
            if (!value.startsWith(prefix)) continue;
            filteredPathIndex.put(key, value);
        }
        return filteredPathIndex;
    }

    public SortedMap<String, String> getFullPathIndex() {
        return this.fullPathIndex;
    }

    public Set<String> listAssets() {
        return this.listAssets("");
    }

    public Set<String> listAssets(String folderPath) {
        Collection<String> allAssets = this.fullPathIndex.values();
        TreeSet<String> assets = new TreeSet<String>(IGNORE_CASE_COMPARATOR);
        String prefix = WEBJARS_PATH_PREFIX + (!folderPath.startsWith("/") ? "/" : "") + folderPath;
        for (String asset : allAssets) {
            if (!asset.startsWith(folderPath) && !asset.startsWith(prefix)) continue;
            assets.add(asset);
        }
        return assets;
    }

    public Map<String, String> getWebJars() {
        HashMap<String, String> webjars = new HashMap<String, String>();
        for (String webjarFile : this.fullPathIndex.values()) {
            Map.Entry<String, String> webjar = WebJarAssetLocator.getWebJar(webjarFile);
            if (webjar == null || webjars.containsKey(webjar.getKey())) continue;
            webjars.put(webjar.getKey(), webjar.getValue());
        }
        return webjars;
    }

    public static Map.Entry<String, String> getWebJar(String path) {
        Matcher matcher = WEBJAR_EXTRACTOR_PATTERN.matcher(path);
        if (matcher.find()) {
            String id = matcher.group(1);
            String version = matcher.group(2);
            return new AbstractMap.SimpleEntry<String, String>(id, version);
        }
        return null;
    }
}

