/*
 * Decompiled with CFR 0.152.
 */
package org.irundaia.sass;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.irundaia.sass.CompilationFailure;
import org.irundaia.sass.CompilationFailure$;
import org.irundaia.sass.CompilationSuccess;
import org.irundaia.sass.CompilerSettings;
import org.irundaia.sass.Context;
import org.irundaia.sass.Context$;
import org.irundaia.sass.Output;
import org.irundaia.sass.Output$;
import org.irundaia.sass.SourceMap;
import org.irundaia.sass.SourceMap$;
import org.irundaia.sass.jna.SassLibrary;
import play.api.libs.json.Json$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class SassCompiler$ {
    public static final SassCompiler$ MODULE$;
    private final Charset charset;

    static {
        new SassCompiler$();
    }

    public Charset charset() {
        return this.charset;
    }

    public Either<CompilationFailure, CompilationSuccess> compile(Path sass, Path sourceDir, Path targetDir, CompilerSettings compilerSettings) {
        Path targetSource = sourceDir.relativize(sass);
        Path css = this.sourceWithExtn$1("css", sass, targetDir, targetSource);
        Path sourceMap = this.sourceWithExtn$1("css.map", sass, targetDir, targetSource);
        Files.createDirectories(css.getParent(), new FileAttribute[0]);
        Either<CompilationFailure, Output> output = this.doCompile(sass, css, sourceMap, compilerSettings);
        return output.right().map((Function1)new Serializable(sass, compilerSettings, css, sourceMap){
            public static final long serialVersionUID = 0L;
            private final Path sass$1;
            private final CompilerSettings compilerSettings$1;
            private final Path css$1;
            private final Path sourceMap$1;

            public final CompilationSuccess apply(Output x0$1) {
                Output output = x0$1;
                SassCompiler$.MODULE$.org$irundaia$sass$SassCompiler$$outputCss(output, this.css$1);
                SassCompiler$.MODULE$.org$irundaia$sass$SassCompiler$$outputSourceMap(this.sass$1, this.sourceMap$1, output, this.compilerSettings$1);
                CompilationSuccess compilationSuccess = SassCompiler$.MODULE$.determineCompilationDependencies(output, this.sass$1, this.css$1, this.sourceMap$1);
                return compilationSuccess;
            }
            {
                this.sass$1 = sass$1;
                this.compilerSettings$1 = compilerSettings$1;
                this.css$1 = css$1;
                this.sourceMap$1 = sourceMap$1;
            }
        });
    }

    public Either<CompilationFailure, Output> doCompile(Path source, Path target, Path map, CompilerSettings compilerSettings) {
        Context context = Context$.MODULE$.apply(source);
        compilerSettings.applySettings(source, context.options());
        context.options().inputPath_$eq(source);
        context.options().outputPath_$eq(target);
        context.options().sourceMapPath_$eq(map);
        int compileStatus = SassLibrary.INSTANCE.sass_compile_file_context(context.nativeContext());
        Output output = Output$.MODULE$.apply(context);
        context.cleanup();
        return compileStatus != 0 ? package$.MODULE$.Left().apply((Object)CompilationFailure$.MODULE$.apply(output)) : package$.MODULE$.Right().apply((Object)output);
    }

    public Path org$irundaia$sass$SassCompiler$$outputCss(Output compilationResult, Path css) {
        return Files.write(css, compilationResult.css().getBytes(this.charset()), new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object org$irundaia$sass$SassCompiler$$outputSourceMap(Path source, Path sourceMap, Output output, CompilerSettings compilerSettings) {
        void var8_11;
        Option option = Option$.MODULE$.apply((Object)output.sourceMap());
        if (option instanceof Some) {
            Some some = (Some)option;
            String sourceMapContent = (String)some.x();
            if (compilerSettings.generateSourceMaps()) {
                String revisedMap = this.fixSourceMap(sourceMapContent, compilerSettings, sourceMap.getParent());
                Path path = Files.write(sourceMap, revisedMap.getBytes(this.charset()), new OpenOption[0]);
                return var8_11;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return var8_11;
    }

    public CompilationSuccess determineCompilationDependencies(Output compilationResult, Path sass, Path css, Path sourceMap) {
        Option option;
        block4: {
            CompilationSuccess compilationSuccess;
            block3: {
                Set filesWritten;
                block2: {
                    filesWritten = Files.exists(sourceMap, new LinkOption[0]) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{css, sourceMap})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{css}));
                    option = Option$.MODULE$.apply((Object)compilationResult.sourceMap());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String sourceMapContent = (String)some.x();
                    compilationSuccess = new CompilationSuccess((Set<Path>)this.normalizeFiles(css.getParent(), (Iterable<String>)((SourceMap)Json$.MODULE$.parse(sourceMapContent).as(SourceMap$.MODULE$.sourceMapFormat())).sources()).toSet(), (Set<Path>)filesWritten);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                compilationSuccess = new CompilationSuccess((Set<Path>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{sass.normalize()}))), (Set<Path>)filesWritten);
            }
            return compilationSuccess;
        }
        throw new MatchError((Object)option);
    }

    private String fixSourceMap(String originalSourceMap, CompilerSettings compilerSettings, Path baseDir) {
        Seq transformedSources;
        SourceMap parsedSourceMap = (SourceMap)Json$.MODULE$.parse(originalSourceMap).as(SourceMap$.MODULE$.sourceMapFormat());
        Seq x$2 = transformedSources = (Seq)this.normalizeFiles(baseDir, (Iterable<String>)parsedSourceMap.sources()).map((Function1)new Serializable(compilerSettings){
            public static final long serialVersionUID = 0L;
            private final CompilerSettings compilerSettings$2;

            public final String apply(Path x$1) {
                return ((Object)SassCompiler$.MODULE$.org$irundaia$sass$SassCompiler$$convertToRelativePath(x$1, (Iterable<Path>)this.compilerSettings$2.includePaths())).toString();
            }
            {
                this.compilerSettings$2 = compilerSettings$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int x$3 = parsedSourceMap.copy$default$1();
        Option<String> x$4 = parsedSourceMap.copy$default$2();
        String x$5 = parsedSourceMap.copy$default$3();
        String x$6 = parsedSourceMap.copy$default$5();
        Seq<String> x$7 = parsedSourceMap.copy$default$6();
        SourceMap updatedMap = parsedSourceMap.copy(x$3, x$4, x$5, (Seq<String>)x$2, x$6, x$7);
        return Json$.MODULE$.prettyPrint(Json$.MODULE$.toJson((Object)updatedMap, SourceMap$.MODULE$.sourceMapFormat()));
    }

    private Seq<Path> normalizeFiles(Path baseDir, Iterable<String> fileNames) {
        return ((TraversableOnce)fileNames.map((Function1)new Serializable(baseDir){
            public static final long serialVersionUID = 0L;
            private final Path baseDir$1;

            public final Path apply(String p) {
                return this.baseDir$1.resolve(p).normalize();
            }
            {
                this.baseDir$1 = baseDir$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public Path org$irundaia$sass$SassCompiler$$convertToRelativePath(Path path, Iterable<Path> includePaths2) {
        Option option;
        block4: {
            Path path2;
            block3: {
                Path normalizedPath;
                block2: {
                    Option ancestorDir;
                    normalizedPath = path.normalize();
                    option = ancestorDir = includePaths2.find((Function1)new Serializable(normalizedPath){
                        public static final long serialVersionUID = 0L;
                        private final Path normalizedPath$1;

                        public final boolean apply(Path includePath) {
                            return this.normalizedPath$1.startsWith(includePath);
                        }
                        {
                            this.normalizedPath$1 = normalizedPath$1;
                        }
                    });
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    path2 = normalizedPath;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Path ancestor = (Path)some.x();
                path2 = ancestor.relativize(normalizedPath);
            }
            return path2;
        }
        throw new MatchError((Object)option);
    }

    private final Path sourceWithExtn$1(String extn, Path sass$1, Path targetDir$1, Path targetSource$1) {
        return targetDir$1.resolve(targetSource$1).resolveSibling(((Object)sass$1.getFileName()).toString().replaceAll("(.*\\.)\\w+", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$1", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extn}))));
    }

    private SassCompiler$() {
        MODULE$ = this;
        this.charset = StandardCharsets.UTF_8;
    }
}

