/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.stream.javadsl.FileIO;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import play.api.libs.MimeTypes;
import play.api.libs.streams.Streams;
import play.http.HttpEntity;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class StatusHeader
extends Result {
    private static final int defaultChunkSize = 8192;

    public StatusHeader(int n) {
        super(n);
    }

    public Result sendInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Null stream");
        }
        return new Result(this.status(), HttpEntity.chunked(StreamConverters.fromInputStream((Creator & Serializable)() -> inputStream, (int)8192), Optional.empty()));
    }

    public Result sendInputStream(InputStream inputStream, long l) {
        if (inputStream == null) {
            throw new NullPointerException("Null content");
        }
        return new Result(this.status(), (HttpEntity)new HttpEntity.Streamed(StreamConverters.fromInputStream((Creator & Serializable)() -> inputStream, (int)8192), Optional.of(l), Optional.empty()));
    }

    public Result sendResource(String string2) {
        return this.sendResource(string2, true);
    }

    public Result sendResource(String string2, ClassLoader classLoader) {
        return this.sendResource(string2, classLoader, true);
    }

    public Result sendResource(String string2, boolean bl) {
        return this.sendResource(string2, this.getClass().getClassLoader(), bl);
    }

    public Result sendResource(String string2, ClassLoader classLoader, boolean bl) {
        return this.doSendResource(StreamConverters.fromInputStream((Creator & Serializable)() -> classLoader.getResourceAsStream(string2)), Optional.empty(), Optional.of(string2), bl);
    }

    public Result sendPath(Path path) {
        return this.sendPath(path, false);
    }

    public Result sendPath(Path path, boolean bl) {
        return this.sendPath(path, bl, path.getFileName().toString());
    }

    public Result sendPath(Path path, boolean bl, String string2) {
        if (path == null) {
            throw new NullPointerException("null content");
        }
        try {
            return this.doSendResource(FileIO.fromFile((File)path.toFile()), Optional.of(Files.size(path)), Optional.of(string2), bl);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Result sendFile(File file2) {
        return this.sendFile(file2, true);
    }

    public Result sendFile(File file2, boolean bl) {
        if (file2 == null) {
            throw new NullPointerException("null file");
        }
        return this.doSendResource(FileIO.fromFile((File)file2), Optional.of(file2.length()), Optional.of(file2.getName()), bl);
    }

    public Result sendFile(File file2, String string2) {
        if (file2 == null) {
            throw new NullPointerException("null file");
        }
        return this.doSendResource(FileIO.fromFile((File)file2), Optional.of(file2.length()), Optional.of(string2), true);
    }

    private Result doSendResource(Source<ByteString, ?> source, Optional<Long> optional, Optional<String> optional2, boolean bl) {
        Map<String, String> map2 = Collections.singletonMap("Content-Disposition", (bl ? "inline" : "attachment") + (optional2.isPresent() ? "; filename=\"" + optional2.get() + "\"" : ""));
        return new Result(this.status(), map2, new HttpEntity.Streamed(source, optional, optional2.map(string2 -> OptionConverters.toJava(MimeTypes.forFileName(string2)).orElse("application/octet-stream"))));
    }

    public Result chunked(Source<ByteString, ?> source) {
        return new Result(this.status(), HttpEntity.chunked(source, Optional.empty()));
    }

    public <T> Result chunked(Results.Chunks<T> chunks) {
        return new Result(this.status(), HttpEntity.chunked(Source.fromPublisher((Publisher)Streams.enumeratorToPublisher(chunks.enumerator, (Option)Option.empty())).map((Function & Serializable)object -> (ByteString)chunks.writable.transform().apply(object)), OptionConverters.toJava(chunks.writable.contentType())));
    }

    public Result sendJson(JsonNode jsonNode) {
        return this.sendJson(jsonNode, "utf-8");
    }

    public Result sendJson(JsonNode jsonNode, String string2) {
        if (jsonNode == null) {
            throw new NullPointerException("Null content");
        }
        ObjectMapper objectMapper = Json.mapper();
        ByteStringBuilder byteStringBuilder = ByteString$.MODULE$.newBuilder();
        try {
            JsonGenerator jsonGenerator = new JsonFactory((ObjectCodec)objectMapper).createGenerator((Writer)new OutputStreamWriter(byteStringBuilder.asOutputStream(), string2));
            objectMapper.writeValue(jsonGenerator, (Object)jsonNode);
            return new Result(this.status(), (HttpEntity)new HttpEntity.Strict(byteStringBuilder.result(), Optional.of("application/json;charset=" + string2)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Result sendEntity(HttpEntity httpEntity) {
        return new Result(this.status(), httpEntity);
    }
}

