/*
 * Decompiled with CFR 0.152.
 */
package play.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import play.api.Application;
import play.api.Play;
import play.i18n.Lang;
import play.i18n.MessagesApi;
import play.mvc.Http;
import scala.collection.JavaConverters;
import scala.collection.mutable.Buffer;

public class Messages {
    private final Lang lang;
    private final MessagesApi messages;

    private static Lang getLang() {
        Lang lang = null;
        if (Http.Context.current.get() != null) {
            lang = Http.Context.current().lang();
        } else {
            Locale locale = Locale.getDefault();
            lang = new Lang(new play.api.i18n.Lang(locale.getLanguage(), locale.getCountry()));
        }
        return lang;
    }

    private static Messages getMessages(Lang lang) {
        Application application = Play.current();
        MessagesApi messagesApi = application.injector().instanceOf(MessagesApi.class);
        return new Messages(lang, messagesApi);
    }

    private static Buffer<Object> convertArgsToScalaBuffer(Object ... objectArray) {
        return (Buffer)JavaConverters.asScalaBufferConverter(Messages.wrapArgsToListIfNeeded(objectArray)).asScala();
    }

    static <T> List<T> wrapArgsToListIfNeeded(T ... TArray) {
        List list = null;
        list = ArrayUtils.isNotEmpty((Object[])TArray) && TArray.length == 1 && TArray[0] instanceof List ? (List)TArray[0] : Arrays.asList(TArray);
        return list;
    }

    @Deprecated
    public static String get(Lang lang, String string2, Object ... objectArray) {
        return Messages.getMessages(lang).at(string2, objectArray);
    }

    @Deprecated
    public static String get(Lang lang, List<String> list, Object ... objectArray) {
        return Messages.getMessages(lang).at(list, objectArray);
    }

    @Deprecated
    public static String get(String string2, Object ... objectArray) {
        return Messages.getMessages(Messages.getLang()).at(string2, objectArray);
    }

    @Deprecated
    public static String get(List<String> list, Object ... objectArray) {
        return Messages.getMessages(Messages.getLang()).at(list, objectArray);
    }

    @Deprecated
    public static Boolean isDefined(Lang lang, String string2) {
        return Messages.getMessages(lang).isDefinedAt(string2);
    }

    @Deprecated
    public static Boolean isDefined(String string2) {
        return Messages.getMessages(Messages.getLang()).isDefinedAt(string2);
    }

    public Messages(Lang lang, MessagesApi messagesApi) {
        this.lang = lang;
        this.messages = messagesApi;
    }

    public Lang lang() {
        return this.lang;
    }

    public MessagesApi messagesApi() {
        return this.messages;
    }

    public String at(String string2, Object ... objectArray) {
        return this.messages.get((play.api.i18n.Lang)this.lang, string2, objectArray);
    }

    public String at(List<String> list, Object ... objectArray) {
        return this.messages.get((play.api.i18n.Lang)this.lang, list, objectArray);
    }

    public Boolean isDefinedAt(String string2) {
        return this.messages.isDefinedAt(this.lang, string2);
    }
}

