/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.crypto;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import play.api.libs.Codecs$;
import play.api.libs.crypto.CookieSigner;
import play.api.libs.crypto.CryptoConfig;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u0017\t!\u0002*T!D'\"\u000b\u0015gQ8pW&,7+[4oKJT!a\u0001\u0003\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\t)a!\u0001\u0003mS\n\u001c(BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0002\u0013\u0005!\u0001\u000f\\1z\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\r\u0007>|7.[3TS\u001etWM\u001d\u0005\t/\u0001\u0011\t\u0011)A\u00051\u000511m\u001c8gS\u001e\u0004\"aE\r\n\u0005i\u0011!\u0001D\"ssB$xnQ8oM&<\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001f?A\u00111\u0003\u0001\u0005\u0006/m\u0001\r\u0001\u0007\u0015\u00037\u0005\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\r%t'.Z2u\u0015\u00051\u0013!\u00026bm\u0006D\u0018B\u0001\u0015$\u0005\u0019IeN[3di\")!\u0006\u0001C\u0001W\u0005!1/[4o)\ra3'\u000e\t\u0003[Ar!!\u0004\u0018\n\u0005=r\u0011A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\b\t\u000bQJ\u0003\u0019\u0001\u0017\u0002\u000f5,7o]1hK\")a'\u000ba\u0001o\u0005\u00191.Z=\u0011\u00075A$(\u0003\u0002:\u001d\t)\u0011I\u001d:bsB\u0011QbO\u0005\u0003y9\u0011AAQ=uK\")!\u0006\u0001C\u0001}Q\u0011Af\u0010\u0005\u0006iu\u0002\r\u0001\f")
public class HMACSHA1CookieSigner
implements CookieSigner {
    private final CryptoConfig config;

    @Override
    public String sign(String message, byte[] key) {
        Mac mac = (Mac)this.config.provider().fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Mac apply() {
                return Mac.getInstance("HmacSHA1");
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Mac apply(String p) {
                return Mac.getInstance("HmacSHA1", p);
            }
        });
        mac.init(new SecretKeySpec(key, "HmacSHA1"));
        return Codecs$.MODULE$.toHexString(mac.doFinal(message.getBytes("utf-8")));
    }

    @Override
    public String sign(String message) {
        return this.sign(message, this.config.secret().getBytes("utf-8"));
    }

    @Inject
    public HMACSHA1CookieSigner(CryptoConfig config2) {
        this.config = config2;
    }
}

