/*
 * Decompiled with CFR 0.152.
 */
package play.api.data.format;

import java.sql.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.data.FormError;
import play.api.data.FormError$;
import play.api.data.format.Formats$;
import play.api.data.format.Formats$$anon$5$;
import play.api.data.format.Formats$$anonfun$play$api$data$format$Formats$;
import play.api.data.format.Formatter;
import play.api.data.format.Formatter$class;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

public final class Formats$ {
    public static final Formats$ MODULE$;
    private final Formatter<BigDecimal> bigDecimalFormat;
    private final Formatter<java.util.Date> dateFormat;
    private final Formatter<Date> sqlDateFormat;
    private final Formatter<DateTime> jodaDateTimeFormat;
    private final Formatter<LocalDate> jodaLocalDateFormat;

    static {
        new Formats$();
    }

    public <A> Formatter<A> ignoredFormat(A value) {
        return new Formatter<A>(value){
            private final Object value$1;
            private final Option<Tuple2<String, Seq<Object>>> format;

            public Option<Tuple2<String, Seq<Object>>> format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
                this.format = x$1;
            }

            public Right<Nothing$, A> bind(String key, Map<String, String> data) {
                return package$.MODULE$.Right().apply(this.value$1);
            }

            public Map<String, Nothing$> unbind(String key, A value) {
                return Predef$.MODULE$.Map().empty();
            }
            {
                this.value$1 = value$1;
                Formatter$class.$init$(this);
            }
        };
    }

    public Formatter<String> stringFormat() {
        return new Formatter<String>(){
            private final Option<Tuple2<String, Seq<Object>>> format;

            public Option<Tuple2<String, Seq<Object>>> format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
                this.format = x$1;
            }

            public Product bind(String key, Map<String, String> data) {
                return data.get((Object)key).toRight((Function0)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final String key$1;

                    public final Seq<FormError> apply() {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormError[]{FormError$.MODULE$.apply(this.key$1, "error.required", (Seq<Object>)Nil$.MODULE$)}));
                    }
                    {
                        this.key$1 = key$1;
                    }
                });
            }

            public Map<String, String> unbind(String key, String value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)}));
            }
            {
                Formatter$class.$init$(this);
            }
        };
    }

    public Formatter<Object> charFormat() {
        return new Formatter<Object>(){
            private final Option<Tuple2<String, Seq<Object>>> format;

            public Option<Tuple2<String, Seq<Object>>> format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
                this.format = x$1;
            }

            public Product bind(String key, Map<String, String> data) {
                return (Either)data.get((Object)key).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(String s) {
                        if (s.length() != 1) return false;
                        String string2 = s;
                        String string3 = " ";
                        if (string2 == null) {
                            if (string3 == null) return false;
                            return true;
                        } else if (string2.equals(string3)) return false;
                        return true;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Right<Nothing$, Object> apply(String s) {
                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)));
                    }
                }).getOrElse((Function0)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final String key$2;

                    public final Left<Seq<FormError>, Nothing$> apply() {
                        return package$.MODULE$.Left().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormError[]{FormError$.MODULE$.apply(this.key$2, "error.required", (Seq<Object>)Nil$.MODULE$)})));
                    }
                    {
                        this.key$2 = key$2;
                    }
                });
            }

            public Map<String, String> unbind(String key, char value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)((Object)BoxesRunTime.boxToCharacter((char)value)).toString())}));
            }
            {
                Formatter$class.$init$(this);
            }
        };
    }

    public <T> Either<Seq<FormError>, T> play$api$data$format$Formats$$parsing(Function1<String, T> parse2, String errMsg, Seq<Object> errArgs, String key, Map<String, String> data) {
        return this.stringFormat().bind(key, data).right().flatMap((Function1)new Serializable(parse2, errMsg, errArgs, key){
            public static final long serialVersionUID = 0L;
            public final Function1 parse$1;
            public final String errMsg$1;
            public final Seq errArgs$1;
            public final String key$3;

            public final Product apply(String s) {
                return Exception$.MODULE$.allCatch().either((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$play$api$data$format$Formats$$parsing$1 $outer;
                    private final String s$1;

                    public final T apply() {
                        return (T)this.$outer.parse$1.apply((Object)this.s$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.s$1 = s$1;
                    }
                }).left().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$play$api$data$format$Formats$$parsing$1 $outer;

                    public final Seq<FormError> apply(Throwable e) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormError[]{FormError$.MODULE$.apply(this.$outer.key$3, this.$outer.errMsg$1, (Seq<Object>)this.$outer.errArgs$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.parse$1 = parse$1;
                this.errMsg$1 = errMsg$1;
                this.errArgs$1 = errArgs$1;
                this.key$3 = key$3;
            }
        });
    }

    private <T> Formatter<T> numberFormatter(Function1<String, T> convert, boolean real) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = real ? new Tuple2((Object)"format.real", (Object)"error.real") : new Tuple2((Object)"format.numeric", (Object)"error.number");
        if (tuple2 != null) {
            Tuple2 tuple23;
            String formatString = (String)tuple2._1();
            String errorString = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)formatString, (Object)errorString);
            String formatString2 = (String)tuple24._1();
            String errorString2 = (String)tuple24._2();
            return new Formatter<T>(convert, formatString2, errorString2){
                private final Some<Tuple2<String, Nil$>> format;
                private final Function1 convert$1;
                private final String errorString$1;

                public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
                }

                public Some<Tuple2<String, Nil$>> format() {
                    return this.format;
                }

                public Either<Seq<FormError>, T> bind(String key, Map<String, String> data) {
                    return Formats$.MODULE$.play$api$data$format$Formats$$parsing(this.convert$1, this.errorString$1, (Seq<Object>)Nil$.MODULE$, key, data);
                }

                public Map<String, String> unbind(String key, T value) {
                    return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString())}));
                }
                {
                    this.convert$1 = convert$1;
                    this.errorString$1 = errorString$1;
                    Formatter$class.$init$(this);
                    this.format = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)formatString$1), (Object)Nil$.MODULE$));
                }
            };
        }
        throw new MatchError((Object)tuple2);
    }

    private <T> boolean numberFormatter$default$2() {
        return false;
    }

    public Formatter<Object> longFormat() {
        return this.numberFormatter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
            }
        }, this.numberFormatter$default$2());
    }

    public Formatter<Object> intFormat() {
        return this.numberFormatter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }, this.numberFormatter$default$2());
    }

    public Formatter<Object> shortFormat() {
        return this.numberFormatter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final short apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toShort();
            }
        }, this.numberFormatter$default$2());
    }

    public Formatter<Object> byteFormat() {
        return this.numberFormatter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toByte();
            }
        }, this.numberFormatter$default$2());
    }

    public Formatter<Object> floatFormat() {
        return this.numberFormatter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toFloat();
            }
        }, true);
    }

    public Formatter<Object> doubleFormat() {
        return this.numberFormatter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toDouble();
            }
        }, true);
    }

    public Formatter<BigDecimal> bigDecimalFormat(Option<Tuple2<Object, Object>> precision) {
        return new Formatter<BigDecimal>(precision){
            private final Some<Tuple2<String, Nil$>> format;
            public final Option precision$1;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, BigDecimal> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.stringFormat().bind(key, data).right().flatMap((Function1)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.5 $outer;
                    public final String key$4;

                    public final Product apply(String s) {
                        return Exception$.MODULE$.allCatch().either((Function0)new Serializable(this, s){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon$5$$anonfun$bind$5 $outer;
                            private final String s$2;

                            public final BigDecimal apply() {
                                BigDecimal bd = package$.MODULE$.BigDecimal().apply(this.s$2);
                                return (BigDecimal)this.$outer.play$api$data$format$Formats$$anon$$anonfun$$$outer().precision$1.map((Function1)new Serializable(this, bd){
                                    public static final long serialVersionUID = 0L;
                                    private final BigDecimal bd$1;

                                    public final BigDecimal apply(Tuple2<Object, Object> x0$1) {
                                        Tuple2<Object, Object> tuple2 = x0$1;
                                        if (tuple2 != null) {
                                            int p = tuple2._1$mcI$sp();
                                            int s = tuple2._2$mcI$sp();
                                            if (this.bd$1.precision() - this.bd$1.scale() > p - s) {
                                                throw new ArithmeticException("Invalid precision");
                                            }
                                            BigDecimal bigDecimal = this.bd$1.setScale(s);
                                            return bigDecimal;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        this.bd$1 = bd$1;
                                    }
                                }).getOrElse((Function0)new Serializable(this, bd){
                                    public static final long serialVersionUID = 0L;
                                    private final BigDecimal bd$1;

                                    public final BigDecimal apply() {
                                        return this.bd$1;
                                    }
                                    {
                                        this.bd$1 = bd$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.s$2 = s$2;
                            }
                        }).left().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon$5$$anonfun$bind$5 $outer;

                            public final Seq<FormError> apply(Throwable e) {
                                Option option;
                                block4: {
                                    FormError formError;
                                    FormError[] formErrorArray;
                                    block3: {
                                        block2: {
                                            Some some;
                                            Tuple2 tuple2;
                                            formErrorArray = new FormError[1];
                                            option = this.$outer.play$api$data$format$Formats$$anon$$anonfun$$$outer().precision$1;
                                            if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block2;
                                            int p = tuple2._1$mcI$sp();
                                            int s = tuple2._2$mcI$sp();
                                            formError = FormError$.MODULE$.apply(this.$outer.key$4, "error.real.precision", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{p, s}))));
                                            break block3;
                                        }
                                        if (!None$.MODULE$.equals(option)) break block4;
                                        formError = FormError$.MODULE$.apply(this.$outer.key$4, "error.real", (Seq<Object>)Nil$.MODULE$);
                                    }
                                    formErrorArray[0] = formError;
                                    return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])formErrorArray));
                                }
                                throw new MatchError((Object)option);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anon.5 play$api$data$format$Formats$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.key$4 = key$4;
                    }
                });
            }

            public Map<String, String> unbind(String key, BigDecimal value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)((BigDecimal)this.precision$1.map((Function1)new Serializable(this, value){
                    public static final long serialVersionUID = 0L;
                    private final BigDecimal value$2;

                    public final BigDecimal apply(Tuple2<Object, Object> p) {
                        return this.value$2.setScale(p._2$mcI$sp());
                    }
                    {
                        this.value$2 = value$2;
                    }
                }).getOrElse((Function0)new Serializable(this, value){
                    public static final long serialVersionUID = 0L;
                    private final BigDecimal value$2;

                    public final BigDecimal apply() {
                        return this.value$2;
                    }
                    {
                        this.value$2 = value$2;
                    }
                })).toString())}));
            }
            {
                this.precision$1 = precision$1;
                Formatter$class.$init$(this);
                this.format = new Some((Object)new Tuple2((Object)"format.real", (Object)Nil$.MODULE$));
            }
        };
    }

    public Formatter<BigDecimal> bigDecimalFormat() {
        return this.bigDecimalFormat;
    }

    public Formatter<Object> booleanFormat() {
        return new Formatter<Object>(){
            private final Some<Tuple2<String, Nil$>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, Object> bind(String key, Map<String, String> data) {
                return package$.MODULE$.Right().apply(data.get((Object)key).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "false";
                    }
                })).right().flatMap((Function1)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final String key$5;

                    public final Either<Seq<FormError>, Object> apply(String x0$2) {
                        String string2 = x0$2;
                        Object object = "true".equals(string2) ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true)) : ("false".equals(string2) ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false)) : package$.MODULE$.Left().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormError[]{FormError$.MODULE$.apply(this.key$5, "error.boolean", (Seq<Object>)Nil$.MODULE$)}))));
                        return object;
                    }
                    {
                        this.key$5 = key$5;
                    }
                });
            }

            public Map<String, String> unbind(String key, boolean value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString())}));
            }
            {
                Formatter$class.$init$(this);
                this.format = new Some((Object)new Tuple2((Object)"format.boolean", (Object)Nil$.MODULE$));
            }
        };
    }

    public Formatter<java.util.Date> dateFormat(String pattern2, TimeZone timeZone) {
        return new Formatter<java.util.Date>(pattern2, timeZone){
            private final DateTimeZone jodaTimeZone;
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            private DateTimeZone jodaTimeZone() {
                return this.jodaTimeZone;
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            public java.util.Date play$api$data$format$Formats$$anon$$dateParse(String data) {
                return this.formatter().parseDateTime(data).toDate();
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, java.util.Date> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.play$api$data$format$Formats$$parsing(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.7 $outer;

                    public final java.util.Date apply(String data) {
                        return this.$outer.play$api$data$format$Formats$$anon$$dateParse(data);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "error.date", (Seq<Object>)Nil$.MODULE$, key, data);
            }

            public Map<String, String> unbind(String key, java.util.Date value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)this.formatter().print((ReadableInstant)new DateTime((Object)value).withZone(this.jodaTimeZone())))}));
            }
            {
                Formatter$class.$init$(this);
                this.jodaTimeZone = DateTimeZone.forTimeZone((TimeZone)timeZone$1);
                this.formatter = DateTimeFormat.forPattern((String)pattern$1).withZone(this.jodaTimeZone());
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pattern$1}))));
            }
        };
    }

    public Formatter<java.util.Date> dateFormat() {
        return this.dateFormat;
    }

    public TimeZone dateFormat$default$2() {
        return TimeZone.getDefault();
    }

    public Formatter<Date> sqlDateFormat(String pattern2, TimeZone timeZone) {
        return new Formatter<Date>(pattern2, timeZone){
            private final Formatter<java.util.Date> dateFormatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            private Formatter<java.util.Date> dateFormatter() {
                return this.dateFormatter;
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Product bind(String key, Map<String, String> data) {
                return this.dateFormatter().bind(key, data).right().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Date apply(java.util.Date d) {
                        return new Date(d.getTime());
                    }
                });
            }

            public Map<String, String> unbind(String key, Date value) {
                return this.dateFormatter().unbind(key, value);
            }
            {
                Formatter$class.$init$(this);
                this.dateFormatter = Formats$.MODULE$.dateFormat(pattern$2, timeZone$2);
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pattern$2}))));
            }
        };
    }

    public Formatter<Date> sqlDateFormat() {
        return this.sqlDateFormat;
    }

    public TimeZone sqlDateFormat$default$2() {
        return TimeZone.getDefault();
    }

    public Formatter<DateTime> jodaDateTimeFormat(String pattern2, DateTimeZone timeZone) {
        return new Formatter<DateTime>(pattern2, timeZone){
            private final DateTimeFormatter play$api$data$format$Formats$$anon$$formatter;
            private final Some<Tuple2<String, Seq<String>>> format;
            private final String pattern$3;
            private final DateTimeZone timeZone$3;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            public DateTimeFormatter play$api$data$format$Formats$$anon$$formatter() {
                return this.play$api$data$format$Formats$$anon$$formatter;
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, DateTime> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.play$api$data$format$Formats$$parsing(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.9 $outer;

                    public final DateTime apply(String x$1) {
                        return this.$outer.play$api$data$format$Formats$$anon$$formatter().parseDateTime(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "error.date", (Seq<Object>)Nil$.MODULE$, key, data);
            }

            public Map<String, String> unbind(String key, DateTime value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.withZone(this.timeZone$3).toString(this.pattern$3))}));
            }
            {
                this.pattern$3 = pattern$3;
                this.timeZone$3 = timeZone$3;
                Formatter$class.$init$(this);
                this.play$api$data$format$Formats$$anon$$formatter = DateTimeFormat.forPattern((String)pattern$3).withZone(timeZone$3);
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pattern$3}))));
            }
        };
    }

    public Formatter<DateTime> jodaDateTimeFormat() {
        return this.jodaDateTimeFormat;
    }

    public DateTimeZone jodaDateTimeFormat$default$2() {
        return DateTimeZone.getDefault();
    }

    public Formatter<LocalDate> jodaLocalDateFormat(String pattern2) {
        return new Formatter<LocalDate>(pattern2){
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;
            private final String pattern$4;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            public LocalDate play$api$data$format$Formats$$anon$$jodaLocalDateParse(String data) {
                return LocalDate.parse((String)data, (DateTimeFormatter)this.formatter());
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, LocalDate> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.play$api$data$format$Formats$$parsing(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.10 $outer;

                    public final LocalDate apply(String data) {
                        return this.$outer.play$api$data$format$Formats$$anon$$jodaLocalDateParse(data);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "error.date", (Seq<Object>)Nil$.MODULE$, key, data);
            }

            public Map<String, String> unbind(String key, LocalDate value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString(this.pattern$4))}));
            }
            {
                this.pattern$4 = pattern$4;
                Formatter$class.$init$(this);
                this.formatter = DateTimeFormat.forPattern((String)pattern$4);
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pattern$4}))));
            }
        };
    }

    public Formatter<LocalDate> jodaLocalDateFormat() {
        return this.jodaLocalDateFormat;
    }

    public Formatter<UUID> uuidFormat() {
        return new Formatter<UUID>(){
            private final Some<Tuple2<String, Nil$>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, UUID> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.play$api$data$format$Formats$$parsing(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final UUID apply(String x$1) {
                        return UUID.fromString(x$1);
                    }
                }, "error.uuid", (Seq<Object>)Nil$.MODULE$, key, data);
            }

            public Map<String, String> unbind(String key, UUID value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString())}));
            }
            {
                Formatter$class.$init$(this);
                this.format = new Some((Object)new Tuple2((Object)"format.uuid", (Object)Nil$.MODULE$));
            }
        };
    }

    private Formats$() {
        MODULE$ = this;
        this.bigDecimalFormat = this.bigDecimalFormat((Option<Tuple2<Object, Object>>)None$.MODULE$);
        this.dateFormat = this.dateFormat("yyyy-MM-dd", this.dateFormat$default$2());
        this.sqlDateFormat = this.sqlDateFormat("yyyy-MM-dd", this.sqlDateFormat$default$2());
        this.jodaDateTimeFormat = this.jodaDateTimeFormat("yyyy-MM-dd", this.jodaDateTimeFormat$default$2());
        this.jodaLocalDateFormat = this.jodaLocalDateFormat("yyyy-MM-dd");
    }
}

