/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport.classloader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import play.runsupport.classloader.ApplicationClassLoaderProvider;

public class DelegatingClassLoader
extends ClassLoader {
    private List<String> sharedClasses;
    private ClassLoader buildLoader;
    private ApplicationClassLoaderProvider applicationClassLoaderProvider;

    public DelegatingClassLoader(ClassLoader classLoader, List<String> list, ClassLoader classLoader2, ApplicationClassLoaderProvider applicationClassLoaderProvider) {
        super(classLoader);
        this.sharedClasses = list;
        this.buildLoader = classLoader2;
        this.applicationClassLoaderProvider = applicationClassLoaderProvider;
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.sharedClasses.contains(string)) {
            return this.buildLoader.loadClass(string);
        }
        return super.loadClass(string, bl);
    }

    @Override
    public URL getResource(String string) {
        Method method;
        try {
            method = ClassLoader.class.getDeclaredMethod("findResource", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        method.setAccessible(true);
        ClassLoader classLoader = this.applicationClassLoaderProvider.get();
        URL uRL = null;
        if (classLoader != null) {
            try {
                uRL = (URL)method.invoke((Object)classLoader, string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException);
            }
        }
        return uRL != null ? uRL : super.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration enumeration;
        Method method;
        try {
            method = ClassLoader.class.getDeclaredMethod("findResources", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        method.setAccessible(true);
        ClassLoader classLoader = this.applicationClassLoaderProvider.get();
        if (classLoader != null) {
            try {
                enumeration = (Enumeration)method.invoke((Object)classLoader, string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException);
            }
        } else {
            enumeration = new Vector().elements();
        }
        Enumeration<URL> enumeration2 = super.getResources(string);
        return this.combineResources(enumeration, enumeration2);
    }

    private Enumeration<URL> combineResources(Enumeration<URL> enumeration, Enumeration<URL> enumeration2) {
        HashSet<URL> hashSet = new HashSet<URL>();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            hashSet.add(enumeration2.nextElement());
        }
        return new Vector(hashSet).elements();
    }

    public String toString() {
        return "DelegatingClassLoader, using parent: " + this.getParent();
    }
}

