/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.scaladsl;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.stream.Graph;
import akka.stream.Outlet$;
import akka.stream.OverflowStrategies$Backpressure$;
import akka.stream.OverflowStrategy;
import akka.stream.SourceShape;
import akka.stream.UniformFanInShape;
import akka.stream.actor.ActorPublisher;
import akka.stream.impl.ActorPublisherSource;
import akka.stream.impl.ActorRefSource;
import akka.stream.impl.ConstantFun$;
import akka.stream.impl.EmptyPublisher$;
import akka.stream.impl.ErrorPublisher;
import akka.stream.impl.MaybeSource;
import akka.stream.impl.PublisherSource;
import akka.stream.impl.QueueSource;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.SubscriberSource;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.GraphDSL$Implicits$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.SourceQueue;
import akka.stream.scaladsl.Unfold;
import akka.stream.scaladsl.UnfoldAsync;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Traversable;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.immutable.ParIterable;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Source$ {
    public static final Source$ MODULE$;
    private final Source<Nothing$, NotUsed> _empty;

    static {
        new Source$();
    }

    public <T> SourceShape<T> shape(String name) {
        return new SourceShape(Outlet$.MODULE$.apply(new StringBuilder().append((Object)name).append((Object)".out").toString()));
    }

    public <T> Source<T, NotUsed> fromPublisher(Publisher<T> publisher) {
        return new Source(new PublisherSource<T>(publisher, Stages$DefaultAttributes$.MODULE$.publisherSource(), this.shape("PublisherSource")));
    }

    public <T> Source<T, NotUsed> fromIterator(Function0<Iterator<T>> f) {
        return this.apply(new scala.collection.immutable.Iterable<T>(f){
            private final Function0 f$1;

            public GenericCompanion<scala.collection.immutable.Iterable> companion() {
                return Iterable.class.companion((scala.collection.immutable.Iterable)this);
            }

            public Combiner<T, ParIterable<T>> parCombiner() {
                return Iterable.class.parCombiner((scala.collection.immutable.Iterable)this);
            }

            public scala.collection.immutable.Iterable<T> seq() {
                return Iterable.class.seq((scala.collection.immutable.Iterable)this);
            }

            public Iterable<T> thisCollection() {
                return IterableLike.class.thisCollection((IterableLike)this);
            }

            public Iterable toCollection(Object repr) {
                return IterableLike.class.toCollection((IterableLike)this, (Object)repr);
            }

            public <U> void foreach(Function1<T, U> f) {
                IterableLike.class.foreach((IterableLike)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return IterableLike.class.forall((IterableLike)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return IterableLike.class.exists((IterableLike)this, p);
            }

            public Option<T> find(Function1<T, Object> p) {
                return IterableLike.class.find((IterableLike)this, p);
            }

            public boolean isEmpty() {
                return IterableLike.class.isEmpty((IterableLike)this);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)IterableLike.class.foldRight((IterableLike)this, z, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)IterableLike.class.reduceRight((IterableLike)this, op);
            }

            public Iterable<T> toIterable() {
                return IterableLike.class.toIterable((IterableLike)this);
            }

            public Iterator<T> toIterator() {
                return IterableLike.class.toIterator((IterableLike)this);
            }

            public T head() {
                return (T)IterableLike.class.head((IterableLike)this);
            }

            public Object slice(int from, int until) {
                return IterableLike.class.slice((IterableLike)this, (int)from, (int)until);
            }

            public Object take(int n) {
                return IterableLike.class.take((IterableLike)this, (int)n);
            }

            public Object drop(int n) {
                return IterableLike.class.drop((IterableLike)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableLike.class.takeWhile((IterableLike)this, (Function1)p);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> grouped(int size) {
                return IterableLike.class.grouped((IterableLike)this, (int)size);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> sliding(int size) {
                return IterableLike.class.sliding((IterableLike)this, (int)size);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> sliding(int size, int step) {
                return IterableLike.class.sliding((IterableLike)this, (int)size, (int)step);
            }

            public Object takeRight(int n) {
                return IterableLike.class.takeRight((IterableLike)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableLike.class.dropRight((IterableLike)this, (int)n);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                IterableLike.class.copyToArray((IterableLike)this, (Object)xs, (int)start, (int)len);
            }

            public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<scala.collection.immutable.Iterable<T>, Tuple2<A1, B>, That> bf) {
                return (That)IterableLike.class.zip((IterableLike)this, that, bf);
            }

            public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<scala.collection.immutable.Iterable<T>, Tuple2<A1, B>, That> bf) {
                return (That)IterableLike.class.zipAll((IterableLike)this, that, thisElem, thatElem, bf);
            }

            public <A1, That> That zipWithIndex(CanBuildFrom<scala.collection.immutable.Iterable<T>, Tuple2<A1, Object>, That> bf) {
                return (That)IterableLike.class.zipWithIndex((IterableLike)this, bf);
            }

            public <B> boolean sameElements(GenIterable<B> that) {
                return IterableLike.class.sameElements((IterableLike)this, that);
            }

            public Stream<T> toStream() {
                return IterableLike.class.toStream((IterableLike)this);
            }

            public boolean canEqual(Object that) {
                return IterableLike.class.canEqual((IterableLike)this, (Object)that);
            }

            public Object view() {
                return IterableLike.class.view((IterableLike)this);
            }

            public IterableView<T, scala.collection.immutable.Iterable<T>> view(int from, int until) {
                return IterableLike.class.view((IterableLike)this, (int)from, (int)until);
            }

            public Builder<T, scala.collection.immutable.Iterable<T>> newBuilder() {
                return GenericTraversableTemplate.class.newBuilder((GenericTraversableTemplate)this);
            }

            public <B> Builder<B, scala.collection.immutable.Iterable<B>> genericBuilder() {
                return GenericTraversableTemplate.class.genericBuilder((GenericTraversableTemplate)this);
            }

            public <A1, A2> Tuple2<scala.collection.immutable.Iterable<A1>, scala.collection.immutable.Iterable<A2>> unzip(Function1<T, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.class.unzip((GenericTraversableTemplate)this, asPair);
            }

            public <A1, A2, A3> Tuple3<scala.collection.immutable.Iterable<A1>, scala.collection.immutable.Iterable<A2>, scala.collection.immutable.Iterable<A3>> unzip3(Function1<T, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.class.unzip3((GenericTraversableTemplate)this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.class.flatten((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.class.transpose((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public Object repr() {
                return TraversableLike.class.repr((TraversableLike)this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.class.isTraversableAgain((TraversableLike)this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.class.hasDefiniteSize((TraversableLike)this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.$plus$plus((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(scala.collection.Traversable<B> that, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<T, B> f, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.map((TraversableLike)this, f, bf);
            }

            public <B, That> That flatMap(Function1<T, GenTraversableOnce<B>> f, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.flatMap((TraversableLike)this, f, bf);
            }

            public Object filter(Function1 p) {
                return TraversableLike.class.filter((TraversableLike)this, (Function1)p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.class.filterNot((TraversableLike)this, (Function1)p);
            }

            public <B, That> That collect(PartialFunction<T, B> pf, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.collect((TraversableLike)this, pf, bf);
            }

            public Tuple2<scala.collection.immutable.Iterable<T>, scala.collection.immutable.Iterable<T>> partition(Function1<T, Object> p) {
                return TraversableLike.class.partition((TraversableLike)this, p);
            }

            public <K> Map<K, scala.collection.immutable.Iterable<T>> groupBy(Function1<T, K> f) {
                return TraversableLike.class.groupBy((TraversableLike)this, f);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> cbf) {
                return (That)TraversableLike.class.scan((TraversableLike)this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, T, B> op, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.scanLeft((TraversableLike)this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<T, B, B> op, CanBuildFrom<scala.collection.immutable.Iterable<T>, B, That> bf) {
                return (That)TraversableLike.class.scanRight((TraversableLike)this, z, op, bf);
            }

            public Option<T> headOption() {
                return TraversableLike.class.headOption((TraversableLike)this);
            }

            public Object tail() {
                return TraversableLike.class.tail((TraversableLike)this);
            }

            public T last() {
                return (T)TraversableLike.class.last((TraversableLike)this);
            }

            public Option<T> lastOption() {
                return TraversableLike.class.lastOption((TraversableLike)this);
            }

            public Object init() {
                return TraversableLike.class.init((TraversableLike)this);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.class.sliceWithKnownDelta((TraversableLike)this, (int)from, (int)until, (int)delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.class.sliceWithKnownBound((TraversableLike)this, (int)from, (int)until);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.class.dropWhile((TraversableLike)this, (Function1)p);
            }

            public Tuple2<scala.collection.immutable.Iterable<T>, scala.collection.immutable.Iterable<T>> span(Function1<T, Object> p) {
                return TraversableLike.class.span((TraversableLike)this, p);
            }

            public Tuple2<scala.collection.immutable.Iterable<T>, scala.collection.immutable.Iterable<T>> splitAt(int n) {
                return TraversableLike.class.splitAt((TraversableLike)this, (int)n);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> tails() {
                return TraversableLike.class.tails((TraversableLike)this);
            }

            public Iterator<scala.collection.immutable.Iterable<T>> inits() {
                return TraversableLike.class.inits((TraversableLike)this);
            }

            public scala.collection.Traversable<T> toTraversable() {
                return TraversableLike.class.toTraversable((TraversableLike)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableLike.class.to((TraversableLike)this, cbf);
            }

            public String stringPrefix() {
                return TraversableLike.class.stringPrefix((TraversableLike)this);
            }

            public FilterMonadic<T, scala.collection.immutable.Iterable<T>> withFilter(Function1<T, Object> p) {
                return TraversableLike.class.withFilter((TraversableLike)this, p);
            }

            public Parallel par() {
                return Parallelizable.class.par((Parallelizable)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public Iterator<T> iterator() {
                return (Iterator)this.f$1.apply();
            }

            public String toString() {
                return "() => Iterator";
            }
            {
                this.f$1 = f$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Parallelizable.class.$init$((Parallelizable)this);
                TraversableLike.class.$init$((TraversableLike)this);
                GenericTraversableTemplate.class.$init$((GenericTraversableTemplate)this);
                GenTraversable.class.$init$((GenTraversable)this);
                Traversable.class.$init$((scala.collection.Traversable)this);
                Traversable.class.$init$((Traversable)this);
                GenIterable.class.$init$((GenIterable)this);
                IterableLike.class.$init$((IterableLike)this);
                Iterable.class.$init$((Iterable)this);
                Iterable.class.$init$((scala.collection.immutable.Iterable)this);
            }
        });
    }

    public <T, M> Source<T, M> fromGraph(Graph<SourceShape<T>, M> g) {
        Source source;
        Graph<SourceShape<T>, M> graph = g;
        if (graph instanceof Source) {
            Source source2;
            source = source2 = (Source)graph;
        } else if (graph instanceof akka.stream.javadsl.Source) {
            akka.stream.javadsl.Source source3 = (akka.stream.javadsl.Source)graph;
            source = source3.asScala();
        } else {
            source = new Source(graph.module());
        }
        return source;
    }

    public <T> Source<T, NotUsed> apply(scala.collection.immutable.Iterable<T> iterable) {
        return ((Source)this.single(iterable).mapConcat(ConstantFun$.MODULE$.scalaIdentityFunction())).withAttributes(Stages$DefaultAttributes$.MODULE$.iterableSource());
    }

    public <T> Source<T, NotUsed> fromFuture(Future<T> future) {
        return this.fromGraph(new GraphStages.FutureSource<T>(future));
    }

    public <T> Source<T, NotUsed> fromCompletionStage(CompletionStage<T> future) {
        return this.fromGraph(new GraphStages.FutureSource(FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(future))));
    }

    public <T> Source<T, Cancellable> tick(FiniteDuration initialDelay, FiniteDuration interval, T tick) {
        return this.fromGraph(new GraphStages.TickSource<T>(initialDelay, interval, tick));
    }

    public <T> Source<T, NotUsed> single(T element) {
        return this.fromGraph(new GraphStages.SingleSource<T>(element));
    }

    public <T> Source<T, NotUsed> repeat(T element) {
        Some next = new Some((Object)new Tuple2(element, element));
        return this.unfold((Object)element, (Function1)new Serializable(next){
            public static final long serialVersionUID = 0L;
            private final Some next$1;

            public final Some<Tuple2<T, T>> apply(T x$1) {
                return this.next$1;
            }
            {
                this.next$1 = next$1;
            }
        }).withAttributes(Stages$DefaultAttributes$.MODULE$.repeat());
    }

    public <S, E> Source<E, NotUsed> unfold(S s, Function1<S, Option<Tuple2<S, E>>> f) {
        return this.fromGraph(new Unfold<S, E>(s, f));
    }

    public <S, E> Source<E, NotUsed> unfoldAsync(S s, Function1<S, Future<Option<Tuple2<S, E>>>> f) {
        return this.fromGraph(new UnfoldAsync<S, E>(s, f));
    }

    public <T> Source<T, NotUsed> empty() {
        return this._empty;
    }

    public <T> Source<T, Promise<Option<T>>> maybe() {
        return new Source(new MaybeSource<T>(Stages$DefaultAttributes$.MODULE$.maybeSource(), this.shape("MaybeSource")));
    }

    public <T> Source<T, NotUsed> failed(Throwable cause) {
        return new Source(new PublisherSource(new ErrorPublisher(cause, "FailedSource").apply(), Stages$DefaultAttributes$.MODULE$.failedSource(), this.shape("FailedSource")));
    }

    public <T> Source<T, Subscriber<T>> asSubscriber() {
        return new Source(new SubscriberSource<T>(Stages$DefaultAttributes$.MODULE$.subscriberSource(), this.shape("SubscriberSource")));
    }

    public <T> Source<T, ActorRef> actorPublisher(Props props2) {
        Predef$.MODULE$.require(ActorPublisher.class.isAssignableFrom(props2.actorClass()), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Actor must be ActorPublisher";
            }
        });
        return new Source(new ActorPublisherSource<T>(props2, Stages$DefaultAttributes$.MODULE$.actorPublisherSource(), this.shape("ActorPublisherSource")));
    }

    public <T> Source<T, ActorRef> actorRef(int bufferSize, OverflowStrategy overflowStrategy) {
        Predef$.MODULE$.require(bufferSize >= 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be greater than or equal to 0";
            }
        });
        OverflowStrategy overflowStrategy2 = overflowStrategy;
        OverflowStrategies$Backpressure$ overflowStrategies$Backpressure$ = OverflowStrategies$Backpressure$.MODULE$;
        Predef$.MODULE$.require(overflowStrategy2 != null ? !overflowStrategy2.equals(overflowStrategies$Backpressure$) : overflowStrategies$Backpressure$ != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Backpressure overflowStrategy not supported";
            }
        });
        return new Source(new ActorRefSource<T>(bufferSize, overflowStrategy, Stages$DefaultAttributes$.MODULE$.actorRefSource(), this.shape("ActorRefSource")));
    }

    public <T, U> Source<U, NotUsed> combine(Source<T, ?> first, Source<T, ?> second, Seq<Source<T, ?>> rest, Function1<Object, Graph<UniformFanInShape<T, U>, NotUsed>> strategy) {
        return this.fromGraph(GraphDSL$.MODULE$.create(new Serializable(first, second, rest, strategy){
            public static final long serialVersionUID = 0L;
            private final Source first$1;
            private final Source second$1;
            private final Seq rest$1;
            private final Function1 strategy$1;

            public final SourceShape<U> apply(GraphDSL.Builder<NotUsed> b) {
                UniformFanInShape c = (UniformFanInShape)b.add((Graph)this.strategy$1.apply((Object)BoxesRunTime.boxToInteger((int)(this.rest$1.size() + 2))));
                new GraphDSL.Implicits.SourceArrow<T>(GraphDSL$Implicits$.MODULE$.SourceArrow(this.first$1)).$tilde$greater(c.in(0), b);
                new GraphDSL.Implicits.SourceArrow<T>(GraphDSL$Implicits$.MODULE$.SourceArrow(this.second$1)).$tilde$greater(c.in(1), b);
                return this.combineRest$2(2, this.rest$1.iterator(), c, b);
            }

            private final SourceShape combineRest$2(int idx, Iterator i, UniformFanInShape c$2, GraphDSL.Builder b$2) {
                while (i.hasNext()) {
                    new GraphDSL.Implicits.SourceArrow<T>(GraphDSL$Implicits$.MODULE$.SourceArrow((Graph)i.next())).$tilde$greater(c$2.in(idx), b$2);
                    ++idx;
                }
                return new SourceShape<O>(c$2.out());
            }
            {
                this.first$1 = first$1;
                this.second$1 = second$1;
                this.rest$1 = rest$1;
                this.strategy$1 = strategy$1;
            }
        }));
    }

    public <T> Source<T, SourceQueue<T>> queue(int bufferSize, OverflowStrategy overflowStrategy) {
        return this.fromGraph(new QueueSource(bufferSize, overflowStrategy).withAttributes(Stages$DefaultAttributes$.MODULE$.queueSource()));
    }

    private Source$() {
        MODULE$ = this;
        this._empty = new Source(new PublisherSource<Nothing$>(EmptyPublisher$.MODULE$, Stages$DefaultAttributes$.MODULE$.emptySource(), this.shape("EmptySource")));
    }
}

