/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Attributes;
import akka.stream.IOResult;
import akka.stream.MaterializationContext;
import akka.stream.SourceShape;
import akka.stream.actor.ActorPublisher$;
import akka.stream.impl.SourceModule;
import akka.stream.impl.StreamLayout;
import akka.stream.impl.io.InputStreamPublisher$;
import akka.util.ByteString;
import java.io.InputStream;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0003\u0011)\u0011\u0011#\u00138qkR\u001cFO]3b[N{WO]2f\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005S6\u0004HN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T\u0011!C\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u0017A!A\"D\b\u0016\u001b\u0005!\u0011B\u0001\b\u0005\u00051\u0019v.\u001e:dK6{G-\u001e7f!\t\u00012#D\u0001\u0012\u0015\t\u0011\u0002\"\u0001\u0003vi&d\u0017B\u0001\u000b\u0012\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0004-miR\"A\f\u000b\u0005aI\u0012AC2p]\u000e,(O]3oi*\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d/\t1a)\u001e;ve\u0016\u0004\"AH\u0010\u000e\u0003\u0019I!\u0001\t\u0004\u0003\u0011%{%+Z:vYRD\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0012GJ,\u0017\r^3J]B,Ho\u0015;sK\u0006l7\u0001\u0001\t\u0004K\u0019BS\"A\r\n\u0005\u001dJ\"!\u0003$v]\u000e$\u0018n\u001c81!\tIS&D\u0001+\u0015\t\u00191FC\u0001-\u0003\u0011Q\u0017M^1\n\u00059R#aC%oaV$8\u000b\u001e:fC6D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\nG\",hn[*ju\u0016\u0004\"!\n\u001a\n\u0005MJ\"aA%oi\"AQ\u0007\u0001BC\u0002\u0013\u0005a'\u0001\u0006biR\u0014\u0018NY;uKN,\u0012a\u000e\t\u0003=aJ!!\u000f\u0004\u0003\u0015\u0005#HO]5ckR,7\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u00038\u0003-\tG\u000f\u001e:jEV$Xm\u001d\u0011\t\u0013u\u0002!\u0011!Q\u0001\ny\n\u0015!B:iCB,\u0007c\u0001\u0010@\u001f%\u0011\u0001I\u0002\u0002\f'>,(oY3TQ\u0006\u0004X-\u0003\u0002>\u001b!)1\t\u0001C\u0001\t\u00061A(\u001b8jiz\"R!R$I\u0013*\u0003\"A\u0012\u0001\u000e\u0003\tAQA\t\"A\u0002\u0011BQ\u0001\r\"A\u0002EBQ!\u000e\"A\u0002]BQ!\u0010\"A\u0002yBQ\u0001\u0014\u0001\u0005B5\u000baa\u0019:fCR,GC\u0001(Z!\u0011)s*U\u000b\n\u0005AK\"A\u0002+va2,'\u0007E\u0002S/>i\u0011a\u0015\u0006\u0003)V\u000bqB]3bGRLg/Z:ue\u0016\fWn\u001d\u0006\u0002-\u0006\u0019qN]4\n\u0005a\u001b&!\u0003)vE2L7\u000f[3s\u0011\u0015Q6\n1\u0001\\\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\b/\n\u0005u3!AF'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8D_:$X\r\u001f;\t\u000b}\u0003A\u0011\u000b1\u0002\u00179,w/\u00138ti\u0006t7-\u001a\u000b\u0003\u0017\u0005DQ!\u00100A\u0002yBQa\u0019\u0001\u0005B\u0011\fab^5uQ\u0006#HO]5ckR,7\u000f\u0006\u0002fkB\u0011aM\u001d\b\u0003OBt!\u0001[8\u000f\u0005%tgB\u00016n\u001b\u0005Y'B\u00017$\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003c\u0012\tAb\u0015;sK\u0006lG*Y=pkRL!a\u001d;\u0003\r5{G-\u001e7f\u0015\t\tH\u0001C\u0003wE\u0002\u0007q'\u0001\u0003biR\u0014\b")
public final class InputStreamSource
extends SourceModule<ByteString, Future<IOResult>> {
    private final Function0<InputStream> createInputStream;
    private final int chunkSize;
    private final Attributes attributes;

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public Tuple2<Publisher<ByteString>, Future<IOResult>> create(MaterializationContext context) {
        Publisher publisher;
        ActorMaterializer materializer = ActorMaterializer$.MODULE$.downcast(context.materializer());
        Promise ioResultPromise = Promise$.MODULE$.apply();
        try {
            InputStream is = (InputStream)this.createInputStream.apply();
            Props props2 = InputStreamPublisher$.MODULE$.props(is, (Promise<IOResult>)ioResultPromise, this.chunkSize);
            ActorRef ref = materializer.actorOf(context, props2);
            publisher = ActorPublisher$.MODULE$.apply(ref);
        }
        catch (Exception exception) {
            ioResultPromise.failure((Throwable)exception);
            publisher = new Publisher(exception, this.attributes().nameOrDefault("inputStreamSource"));
        }
        Publisher pub = publisher;
        return new Tuple2(pub, (Object)ioResultPromise.future());
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> newInstance(SourceShape<ByteString> shape) {
        return new InputStreamSource(this.createInputStream, this.chunkSize, this.attributes(), shape);
    }

    @Override
    public StreamLayout.Module withAttributes(Attributes attr) {
        return new InputStreamSource(this.createInputStream, this.chunkSize, attr, this.amendShape(attr));
    }

    public InputStreamSource(Function0<InputStream> createInputStream, int chunkSize, Attributes attributes, SourceShape<ByteString> shape) {
        this.createInputStream = createInputStream;
        this.chunkSize = chunkSize;
        this.attributes = attributes;
        super(shape);
    }
}

