/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.ActorMaterializerSettings;
import akka.stream.Attributes;
import akka.stream.IOResult;
import akka.stream.MaterializationContext;
import akka.stream.SourceShape;
import akka.stream.actor.ActorPublisher$;
import akka.stream.impl.SourceModule;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.StreamLayout;
import akka.stream.impl.io.FilePublisher$;
import akka.util.ByteString;
import java.io.File;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0003\u0011)\u0011!BR5mKN{WO]2f\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005S6\u0004HN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T\u0011!C\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u0017A!A\"D\b\u0016\u001b\u0005!\u0011B\u0001\b\u0005\u00051\u0019v.\u001e:dK6{G-\u001e7f!\t\u00012#D\u0001\u0012\u0015\t\u0011\u0002\"\u0001\u0003vi&d\u0017B\u0001\u000b\u0012\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0004-miR\"A\f\u000b\u0005aI\u0012AC2p]\u000e,(O]3oi*\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d/\t1a)\u001e;ve\u0016\u0004\"AH\u0010\u000e\u0003\u0019I!\u0001\t\u0004\u0003\u0011%{%+Z:vYRD\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0002M\u000e\u0001\u0001CA\u0013*\u001b\u00051#BA\u0002(\u0015\u0005A\u0013\u0001\u00026bm\u0006L!A\u000b\u0014\u0003\t\u0019KG.\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005I1\r[;oWNK'0\u001a\t\u0003]=j\u0011!G\u0005\u0003ae\u00111!\u00138u\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0014AC1uiJL'-\u001e;fgV\tA\u0007\u0005\u0002\u001fk%\u0011aG\u0002\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\b\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u0017\u0005$HO]5ckR,7\u000f\t\u0005\nu\u0001\u0011\t\u0011)A\u0005wy\nQa\u001d5ba\u0016\u00042A\b\u001f\u0010\u0013\tidAA\u0006T_V\u00148-Z*iCB,\u0017B\u0001\u001e\u000e\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q)!\tR#G\u000fB\u00111\tA\u0007\u0002\u0005!)!e\u0010a\u0001I!)Af\u0010a\u0001[!)!g\u0010a\u0001i!)!h\u0010a\u0001w!)\u0011\n\u0001C!\u0015\u000611M]3bi\u0016$\"a\u0013,\u0011\t9be*F\u0005\u0003\u001bf\u0011a\u0001V;qY\u0016\u0014\u0004cA(U\u001f5\t\u0001K\u0003\u0002R%\u0006y!/Z1di&4Xm\u001d;sK\u0006l7OC\u0001T\u0003\ry'oZ\u0005\u0003+B\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\t\u000b]C\u0005\u0019\u0001-\u0002\u000f\r|g\u000e^3yiB\u0011a$W\u0005\u00035\u001a\u0011a#T1uKJL\u0017\r\\5{CRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u00069\u0002!\t&X\u0001\f]\u0016<\u0018J\\:uC:\u001cW\r\u0006\u0002\f=\")!h\u0017a\u0001w!)\u0001\r\u0001C!C\u0006qq/\u001b;i\u0003R$(/\u001b2vi\u0016\u001cHC\u00012s!\t\u0019wN\u0004\u0002e[:\u0011Q\r\u001c\b\u0003M.t!a\u001a6\u000e\u0003!T!![\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002o\t\u0005a1\u000b\u001e:fC6d\u0015-_8vi&\u0011\u0001/\u001d\u0002\u0007\u001b>$W\u000f\\3\u000b\u00059$\u0001\"B:`\u0001\u0004!\u0014\u0001B1uiJ\u0004")
public final class FileSource
extends SourceModule<ByteString, Future<IOResult>> {
    private final File f;
    private final int chunkSize;
    private final Attributes attributes;

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public Tuple2<Publisher<ByteString>, Future<IOResult>> create(MaterializationContext context) {
        ActorMaterializer materializer = ActorMaterializer$.MODULE$.downcast(context.materializer());
        ActorMaterializerSettings settings = materializer.effectiveSettings(context.effectiveAttributes());
        Promise ioResultPromise = Promise$.MODULE$.apply();
        Props props2 = FilePublisher$.MODULE$.props(this.f, (Promise<IOResult>)ioResultPromise, this.chunkSize, settings.initialInputBufferSize(), settings.maxInputBufferSize());
        String dispatcher = context.effectiveAttributes().get(Stages$DefaultAttributes$.MODULE$.IODispatcher(), ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class)).dispatcher();
        ActorRef ref = materializer.actorOf(context, props2.withDispatcher(dispatcher));
        return new Tuple2(ActorPublisher$.MODULE$.apply(ref), (Object)ioResultPromise.future());
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> newInstance(SourceShape<ByteString> shape) {
        return new FileSource(this.f, this.chunkSize, this.attributes(), shape);
    }

    @Override
    public StreamLayout.Module withAttributes(Attributes attr) {
        return new FileSource(this.f, this.chunkSize, attr, this.amendShape(attr));
    }

    public FileSource(File f, int chunkSize, Attributes attributes, SourceShape<ByteString> shape) {
        this.f = f;
        this.chunkSize = chunkSize;
        this.attributes = attributes;
        super(shape);
        Predef$.MODULE$.require(chunkSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chunkSize must be greater than 0";
            }
        });
    }
}

