/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.packager.rpm;

import com.typesafe.sbt.packager.linux.LinuxPackageMapping;
import com.typesafe.sbt.packager.linux.LinuxSymlink$;
import com.typesafe.sbt.packager.rpm.RpmHelper$;
import com.typesafe.sbt.packager.rpm.RpmSpec;
import java.io.File;
import sbt.IO$;
import sbt.Logger;
import sbt.Logger$;
import sbt.Process$;
import sbt.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RpmHelper$ {
    public static final RpmHelper$ MODULE$;
    private final Seq<String> topleveldirs;

    static {
        new RpmHelper$();
    }

    public String hostVendor() {
        return Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rpm", "-E", "%{_host_vendor}"}))).$bang$bang();
    }

    public File buildRpm(RpmSpec spec, File workArea, Logger log) {
        this.buildWorkArea(workArea);
        this.copyFiles(spec, workArea, log);
        this.writeSpecFile(spec, workArea, log);
        this.buildPackage(workArea, spec, log);
        String rpmname = new StringOps(Predef$.MODULE$.augmentString("%s-%s-%s.%s.rpm")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{spec.meta().name(), spec.meta().version(), spec.meta().release(), spec.meta().arch()}));
        return package$.MODULE$.richFile(package$.MODULE$.richFile(package$.MODULE$.richFile(workArea).$div("RPMS")).$div(spec.meta().arch())).$div(rpmname);
    }

    private void copyFiles(RpmSpec spec, File workArea, Logger log) {
        File buildroot = package$.MODULE$.richFile(workArea).$div("tmp-buildroot");
        IO$.MODULE$.createDirectories((Traversable)spec.mappings().flatMap((Function1)new Serializable(buildroot){
            public static final long serialVersionUID = 0L;
            public final File buildroot$1;

            public final Traversable<File> apply(LinuxPackageMapping mapping) {
                return (Traversable)((TraversableLike)mapping.mappings().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, String> check$ifrefutable$1) {
                        Tuple2<File, String> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, String> x$1) {
                        Tuple2<File, String> tuple2 = x$1;
                        if (tuple2 != null) {
                            File file = (File)tuple2._1();
                            boolean bl = file.isDirectory();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.copyFiles.1 $outer;

                    public final Tuple2<Tuple2<File, String>, File> apply(Tuple2<File, String> x$3) {
                        Tuple2<File, String> tuple2 = x$3;
                        if (tuple2 != null) {
                            String dest = (String)tuple2._2();
                            File target = package$.MODULE$.richFile(this.$outer.buildroot$1).$div(dest);
                            Tuple2 tuple22 = new Tuple2(tuple2, (Object)target);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Traversable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply(Tuple2<Tuple2<File, String>, File> x$4) {
                        Tuple2<Tuple2<File, String>, File> tuple2 = x$4;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            File target = (File)tuple2._2();
                            if (tuple22 != null) {
                                File file = target;
                                return file;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, Traversable$.MODULE$.canBuildFrom());
            }
            {
                this.buildroot$1 = buildroot$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
        spec.mappings().foreach((Function1)new Serializable(log, buildroot){
            public static final long serialVersionUID = 0L;
            public final Logger log$1;
            public final File buildroot$1;

            public final void apply(LinuxPackageMapping mapping) {
                ((GenericTraversableTemplate)mapping.mappings().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, String> check$ifrefutable$2) {
                        Tuple2<File, String> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, String> x$5) {
                        Tuple2<File, String> tuple2 = x$5;
                        if (tuple2 != null) {
                            File file = (File)tuple2._1();
                            boolean bl = file.exists() && !file.isDirectory();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.copyFiles.2 $outer;

                    public final Tuple2<Tuple2<File, String>, File> apply(Tuple2<File, String> x$7) {
                        Tuple2<File, String> tuple2 = x$7;
                        if (tuple2 != null) {
                            String dest = (String)tuple2._2();
                            File target = package$.MODULE$.richFile(this.$outer.buildroot$1).$div(dest);
                            Tuple2 tuple22 = new Tuple2(tuple2, (Object)target);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Traversable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, mapping){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.copyFiles.2 $outer;
                    private final LinuxPackageMapping mapping$1;

                    public final void apply(Tuple2<Tuple2<File, String>, File> x$8) {
                        Tuple2<Tuple2<File, String>, File> tuple2 = x$8;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            File target = (File)tuple2._2();
                            if (tuple22 != null) {
                                File file = (File)tuple22._1();
                                RpmHelper$.MODULE$.com$typesafe$sbt$packager$rpm$RpmHelper$$copyWithZip$1(file, target, this.mapping$1.zipped(), this.$outer.log$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mapping$1 = mapping$1;
                    }
                });
            }
            {
                this.log$1 = log$1;
                this.buildroot$1 = buildroot$1;
            }
        });
        LinuxSymlink$.MODULE$.makeSymLinks(spec.symlinks(), buildroot, LinuxSymlink$.MODULE$.makeSymLinks$default$3());
    }

    private File writeSpecFile(RpmSpec spec, File workArea, Logger log) {
        File specdir = package$.MODULE$.richFile(workArea).$div("SPECS");
        File rpmBuildroot = package$.MODULE$.richFile(workArea).$div("buildroot");
        File tmpBuildRoot = package$.MODULE$.richFile(workArea).$div("tmp-buildroot");
        File specfile = package$.MODULE$.richFile(specdir).$div(new StringBuilder().append((Object)spec.meta().name()).append((Object)".spec").toString());
        log.debug((Function0)new Serializable(specfile){
            public static final long serialVersionUID = 0L;
            private final File specfile$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Creating SPEC file: ").append((Object)this.specfile$1.getAbsolutePath()).toString();
            }
            {
                this.specfile$1 = specfile$1;
            }
        });
        IO$.MODULE$.write(specfile, spec.writeSpec(rpmBuildroot, tmpBuildRoot), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
        return specfile;
    }

    private void buildPackage(File workArea, RpmSpec spec, Logger log) {
        File buildRoot = package$.MODULE$.richFile(workArea).$div("buildroot");
        File specsDir = package$.MODULE$.richFile(workArea).$div("SPECS");
        boolean gpg = false;
        IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable(workArea, spec, log, buildRoot, specsDir, gpg){
            public static final long serialVersionUID = 0L;
            private final File workArea$2;
            private final RpmSpec spec$1;
            private final Logger log$2;
            private final File buildRoot$1;
            private final File specsDir$1;
            private final boolean gpg$1;

            public final void apply(File tmpRpmBuildDir) {
                Seq args = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rpmbuild", "-bb", "--target", new StringBuilder().append((Object)this.spec$1.meta().arch()).append((Object)BoxesRunTime.boxToCharacter((char)'-')).append((Object)this.spec$1.meta().vendor()).append((Object)BoxesRunTime.boxToCharacter((char)'-')).append((Object)this.spec$1.meta().os()).toString(), "--buildroot", this.buildRoot$1.getAbsolutePath(), "--define", new StringBuilder().append((Object)"_topdir ").append((Object)this.workArea$2.getAbsolutePath()).toString(), "--define", new StringBuilder().append((Object)"_tmppath ").append((Object)tmpRpmBuildDir.getAbsolutePath()).toString()}))).$plus$plus((GenTraversableOnce)(this.gpg$1 ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--define", "_gpg_name <insert keyname>", "--sign"})) : Seq$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)this.spec$1.meta().name()).append((Object)".spec").toString()})), Seq$.MODULE$.canBuildFrom());
                this.log$2.debug((Function0)new Serializable(this, args){
                    public static final long serialVersionUID = 0L;
                    private final Seq args$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Executing rpmbuild with: ").append((Object)this.args$1.mkString(" ")).toString();
                    }
                    {
                        this.args$1 = args$1;
                    }
                });
                int n = Process$.MODULE$.apply(args, (Option)new Some((Object)this.specsDir$1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(Logger$.MODULE$.log2PLog(this.log$2));
                switch (n) {
                    default: {
                        throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Unable to run rpmbuild, check output for details. Errorcode ").append((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                    }
                    case 0: 
                }
            }
            {
                this.workArea$2 = workArea$2;
                this.spec$1 = spec$1;
                this.log$2 = log$2;
                this.buildRoot$1 = buildRoot$1;
                this.specsDir$1 = specsDir$1;
                this.gpg$1 = gpg$1;
            }
        });
    }

    private void buildWorkArea(File workArea) {
        Object object = workArea.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)workArea.mkdirs());
        ((IterableLike)this.topleveldirs.map((Function1)new Serializable(workArea){
            public static final long serialVersionUID = 0L;
            private final File workArea$1;

            public final File apply(String x$9) {
                return package$.MODULE$.richFile(this.workArea$1).$div(x$9);
            }
            {
                this.workArea$1 = workArea$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File d) {
                if (d.exists()) {
                    IO$.MODULE$.delete(d);
                }
                return d.mkdir();
            }
        });
    }

    public String evalMacro(String mcro) {
        return Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rpm", "--eval", new StringBuilder().append('%').append((Object)mcro).toString()}))).$bang$bang();
    }

    public final void com$typesafe$sbt$packager$rpm$RpmHelper$$copyWithZip$1(File from, File to, boolean zipped, Logger log$1) {
        log$1.debug((Function0)new Serializable(from, to){
            public static final long serialVersionUID = 0L;
            private final File from$1;
            private final File to$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Copying %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.from$1, this.to$1}));
            }
            {
                this.from$1 = from$1;
                this.to$1 = to$1;
            }
        });
        if (zipped) {
            IO$.MODULE$.gzip(from, to);
        } else {
            IO$.MODULE$.copyFile(from, to, true);
        }
    }

    private RpmHelper$() {
        MODULE$ = this;
        this.topleveldirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BUILD", "RPMS", "SOURCES", "SPECS", "SRPMS", "tmp-buildroot", "buildroot"}));
    }
}

