/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.FormField;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionsCollection;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass(domClasses={HtmlSelect.class})
public class HTMLSelectElement
extends FormField {
    private HTMLOptionsCollection optionsArray_;

    public void initialize() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        htmlSelect.setScriptObject(this);
        if (this.optionsArray_ == null) {
            this.optionsArray_ = new HTMLOptionsCollection(this);
            this.optionsArray_.initialize(htmlSelect);
        }
    }

    @JsxFunction
    public void remove(int index) {
        this.put(index, null, null);
    }

    @JsxFunction
    public void add(HTMLOptionElement newOptionObject, Object arg2) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_ADD_SECOND_PARAM_IS_INDEX)) {
            this.add_IE(newOptionObject, arg2);
        } else {
            this.add_FF(newOptionObject, arg2);
        }
        this.ensureSelectedIndex();
    }

    @Override
    public Object appendChild(Object childObject) {
        Object object = super.appendChild(childObject);
        this.ensureSelectedIndex();
        return object;
    }

    @Override
    public Object insertBeforeImpl(Object[] args) {
        Object object = super.insertBeforeImpl(args);
        this.ensureSelectedIndex();
        return object;
    }

    @JsxFunction
    public HTMLOptionElement item(int index) {
        if (index < 0) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_ITEM_THROWS_IF_NEGATIVE)) {
                throw Context.reportRuntimeError((String)("Invalid index for select node: " + index));
            }
            return null;
        }
        int length = this.getLength();
        if (index > length) {
            return null;
        }
        return (HTMLOptionElement)this.getHtmlSelect().getOption(index).getScriptObject();
    }

    protected void add_IE(HTMLOptionElement newOptionObject, Object index) {
        HtmlOption beforeOption;
        if (index == null) {
            throw new EvaluatorException("Null not supported as index.");
        }
        if (Context.getUndefinedValue().equals(index)) {
            beforeOption = null;
        } else {
            HtmlSelect select = this.getHtmlSelect();
            int intIndex = (Integer)Context.jsToJava((Object)index, Integer.class);
            beforeOption = intIndex >= select.getOptionSize() ? null : select.getOption(intIndex);
        }
        this.addBefore(newOptionObject, beforeOption);
    }

    protected void add_FF(HTMLOptionElement newOptionObject, Object beforeOptionObject) {
        HtmlOption beforeOption;
        if (beforeOptionObject == null) {
            beforeOption = null;
        } else if (Context.getUndefinedValue().equals(beforeOptionObject)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_ADD_SECOND_PARAM_IS_REQUIRED)) {
                throw Context.reportRuntimeError((String)"Not enough arguments [SelectElement.add]");
            }
            beforeOption = null;
        } else if (beforeOptionObject instanceof Number) {
            HtmlSelect select = this.getHtmlSelect();
            int intIndex = (Integer)Context.jsToJava((Object)beforeOptionObject, Integer.class);
            beforeOption = intIndex >= select.getOptionSize() ? null : select.getOption(intIndex);
        } else {
            beforeOption = (HtmlOption)((HTMLOptionElement)beforeOptionObject).getDomNodeOrDie();
        }
        this.addBefore(newOptionObject, beforeOption);
    }

    protected void addBefore(HTMLOptionElement newOptionObject, HtmlOption beforeOption) {
        HtmlSelect select = this.getHtmlSelect();
        HtmlOption htmlOption = newOptionObject.getDomNodeOrNull();
        if (htmlOption == null) {
            htmlOption = (HtmlOption)HTMLParser.getFactory("option").createElement(select.getPage(), "option", null);
        }
        if (beforeOption == null) {
            select.appendChild(htmlOption);
        } else {
            beforeOption.insertBefore(htmlOption);
        }
    }

    @Override
    public String getType() {
        String type = this.getHtmlSelect().isMultipleSelectEnabled() ? "select-multiple" : "select-one";
        return type;
    }

    @JsxGetter
    public HTMLOptionsCollection getOptions() {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_;
    }

    @JsxGetter
    public int getSelectedIndex() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        List<HtmlOption> selectedOptions = htmlSelect.getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return -1;
        }
        List<HtmlOption> allOptions = htmlSelect.getOptions();
        return allOptions.indexOf(selectedOptions.get(0));
    }

    @JsxSetter
    public void setSelectedIndex(int index) {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        if (index != 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_SELECTED_INDEX_THROWS_IF_BAD) && (index < -1 || index >= htmlSelect.getOptionSize())) {
            throw Context.reportRuntimeError((String)("Invalid index for select node: " + index));
        }
        for (HtmlOption itemToUnSelect : htmlSelect.getSelectedOptions()) {
            htmlSelect.setSelectedAttribute(itemToUnSelect, false);
        }
        if (index < 0) {
            return;
        }
        List<HtmlOption> allOptions = htmlSelect.getOptions();
        if (index < allOptions.size()) {
            HtmlOption itemToSelect = allOptions.get(index);
            htmlSelect.setSelectedAttribute(itemToSelect, true, false);
        }
    }

    @Override
    public String getValue() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        List<HtmlOption> selectedOptions = htmlSelect.getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return "";
        }
        return ((HTMLOptionElement)selectedOptions.get(0).getScriptObject()).getValue();
    }

    @JsxGetter
    public int getLength() {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_.getLength();
    }

    @JsxSetter
    public void setLength(int newLength) {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        this.optionsArray_.setLength(newLength);
    }

    public Object get(int index, Scriptable start) {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_.get(index, start);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        this.optionsArray_.put(index, start, newValue);
    }

    private HtmlSelect getHtmlSelect() {
        return (HtmlSelect)this.getDomNodeOrDie();
    }

    @Override
    public void setValue(String newValue) {
        this.getHtmlSelect().setSelectedAttribute(newValue, true);
    }

    @JsxGetter
    public int getSize() {
        int size = 0;
        String sizeAttribute = this.getDomNodeOrDie().getAttribute("size");
        if (sizeAttribute != DomElement.ATTRIBUTE_NOT_DEFINED && sizeAttribute != DomElement.ATTRIBUTE_VALUE_EMPTY) {
            try {
                size = Integer.parseInt(sizeAttribute);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setAttribute("size", size);
    }

    @JsxGetter
    public boolean getMultiple() {
        return this.getDomNodeOrDie().hasAttribute("multiple");
    }

    @JsxSetter
    public void setMultiple(boolean multiple) {
        if (multiple) {
            this.getDomNodeOrDie().setAttribute("multiple", "multiple");
        } else {
            this.getDomNodeOrDie().removeAttribute("multiple");
        }
    }

    private void ensureSelectedIndex() {
        HtmlSelect select = this.getHtmlSelect();
        if (select.getOptionSize() == 0) {
            this.setSelectedIndex(-1);
        } else if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
    }
}

