/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.HtmlMeter;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClasses={HtmlMeter.class}, browsers={@WebBrowser(value=BrowserName.FF, minVersion=16.0f), @WebBrowser(value=BrowserName.CHROME)})
public class HTMLMeterElement
extends HTMLElement {
    @JsxGetter
    public double getValue() {
        return this.getAttributeAsDouble("value", 0.0);
    }

    @JsxGetter
    public double getMin() {
        return this.getAttributeAsDouble("min", 0.0);
    }

    @JsxGetter
    public double getMax() {
        return this.getAttributeAsDouble("max", 1.0);
    }

    @JsxGetter
    public double getLow() {
        double val = this.getAttributeAsDouble("low", Double.MAX_VALUE);
        if (val == Double.MAX_VALUE) {
            return this.getMin();
        }
        return val;
    }

    @JsxGetter
    public double getHigh() {
        double val = this.getAttributeAsDouble("high", Double.MIN_VALUE);
        if (val == Double.MIN_VALUE) {
            return this.getMax();
        }
        return val;
    }

    @JsxGetter
    public double getOptimum() {
        double val = this.getAttributeAsDouble("optimum", Double.MAX_VALUE);
        if (val == Double.MAX_VALUE) {
            return this.getValue();
        }
        return val;
    }

    private double getAttributeAsDouble(String attributeName, double defaultValue) {
        try {
            return Double.parseDouble(this.getDomNodeOrDie().getAttribute(attributeName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

