/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.DefaultWrites;
import play.api.libs.json.DefaultWrites$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.OWrites;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.json.Writes$class;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public abstract class DefaultWrites$class {
    public static Writes arrayWrites(DefaultWrites $this, ClassTag evidence$1, Writes evidence$2) {
        return Writes$.MODULE$.apply(new Serializable($this, evidence$2){
            public static final long serialVersionUID = 0L;
            public final Writes evidence$2$1;

            public final JsArray apply(Object ts) {
                return new JsArray((Seq<JsValue>)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(ts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DefaultWrites$.anonfun.arrayWrites.1 $outer;

                    public final JsValue apply(T x$1) {
                        return Json$.MODULE$.toJson(x$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JsValue.class)))).toSeq());
            }
            {
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public static OWrites mapWrites(DefaultWrites $this, Writes evidence$3) {
        return OWrites$.MODULE$.apply(new Serializable($this, evidence$3){
            public static final long serialVersionUID = 0L;
            public final Writes evidence$3$1;

            public final JsObject apply(Map<String, V> ts) {
                return JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)ts.mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DefaultWrites$.anonfun.mapWrites.1 $outer;

                    public final JsValue apply(V x$2) {
                        return Json$.MODULE$.toJson(x$2, this.$outer.evidence$3$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toSeq());
            }
            {
                this.evidence$3$1 = evidence$3$1;
            }
        });
    }

    public static Writes traversableWrites(DefaultWrites $this, Writes evidence$4) {
        return Writes$.MODULE$.apply(new Serializable($this, evidence$4){
            public static final long serialVersionUID = 0L;
            public final Writes evidence$4$1;

            public final JsArray apply(Traversable<A> as) {
                return new JsArray((Seq<JsValue>)((TraversableOnce)as.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DefaultWrites$.anonfun.traversableWrites.1 $outer;

                    public final JsValue apply(A x$3) {
                        return Json$.MODULE$.toJson(x$3, this.$outer.evidence$4$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Traversable$.MODULE$.canBuildFrom())).toSeq());
            }
            {
                this.evidence$4$1 = evidence$4$1;
            }
        });
    }

    public static Writes OptionWrites(DefaultWrites $this, Writes fmt) {
        return new Writes<Option<T>>($this, fmt){
            private final Writes fmt$1;

            public Writes<Option<T>> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<Option<T>> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(Option<T> o) {
                Option<T> option;
                block4: {
                    JsValue jsValue;
                    block3: {
                        block2: {
                            option = o;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object value = some.x();
                            jsValue = this.fmt$1.writes(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        jsValue = JsNull$.MODULE$;
                    }
                    return jsValue;
                }
                throw new MatchError(option);
            }
            {
                this.fmt$1 = fmt$1;
                Writes$class.$init$(this);
            }
        };
    }

    public static Writes dateWrites(DefaultWrites $this, String pattern2) {
        return new Writes<java.util.Date>($this, pattern2){
            private final String pattern$1;

            public Writes<java.util.Date> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<java.util.Date> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(java.util.Date d) {
                return new JsString(new SimpleDateFormat(this.pattern$1).format(d));
            }
            {
                this.pattern$1 = pattern$1;
                Writes$class.$init$(this);
            }
        };
    }

    public static Writes temporalWrites(DefaultWrites $this, Object formatting, Function1 f) {
        return new Writes<A>($this, formatting, f){
            private final Object formatting$1;
            private final Function1 f$5;

            public Writes<A> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<A> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(A temporal) {
                return new JsString(((DefaultWrites.TemporalFormatter)this.f$5.apply(this.formatting$1)).format(temporal));
            }
            {
                this.formatting$1 = formatting$1;
                this.f$5 = f$5;
                Writes$class.$init$(this);
            }
        };
    }

    public static Writes jodaDateWrites(DefaultWrites $this, String pattern2) {
        return new Writes<DateTime>($this, pattern2){
            private final DateTimeFormatter df;

            public Writes<DateTime> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<DateTime> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            private DateTimeFormatter df() {
                return this.df;
            }

            public JsValue writes(DateTime d) {
                return new JsString(d.toString(this.df()));
            }
            {
                Writes$class.$init$(this);
                this.df = DateTimeFormat.forPattern((String)pattern$2);
            }
        };
    }

    public static Writes jodaLocalDateWrites(DefaultWrites $this, String pattern2) {
        return new Writes<org.joda.time.LocalDate>($this, pattern2){
            private final DateTimeFormatter df;

            public Writes<org.joda.time.LocalDate> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<org.joda.time.LocalDate> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            private DateTimeFormatter df() {
                return this.df;
            }

            public JsValue writes(org.joda.time.LocalDate d) {
                return new JsString(d.toString(this.df()));
            }
            {
                Writes$class.$init$(this);
                this.df = DateTimeFormat.forPattern((String)pattern$3);
            }
        };
    }

    public static Writes jodaLocalTimeWrites(DefaultWrites $this, String pattern2) {
        return new Writes<LocalTime>($this, pattern2){
            private final String pattern$4;

            public Writes<LocalTime> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<LocalTime> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(LocalTime d) {
                return new JsString(d.toString(this.pattern$4));
            }
            {
                this.pattern$4 = pattern$4;
                Writes$class.$init$(this);
            }
        };
    }

    public static Writes sqlDateWrites(DefaultWrites $this, String pattern2) {
        return new Writes<Date>($this, pattern2){
            private final String pattern$5;

            public Writes<Date> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<Date> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(Date d) {
                return new JsString(new SimpleDateFormat(this.pattern$5).format(d));
            }
            {
                this.pattern$5 = pattern$5;
                Writes$class.$init$(this);
            }
        };
    }

    public static Writes enumNameWrites(DefaultWrites $this) {
        return new Writes<Enumeration.Value>($this){

            public Writes<Enumeration.Value> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<Enumeration.Value> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(Enumeration.Value value) {
                return new JsString(value.toString());
            }
            {
                Writes$class.$init$(this);
            }
        };
    }

    public static void $init$(DefaultWrites $this) {
        $this.play$api$libs$json$DefaultWrites$_setter_$DefaultLocalDateTimeWrites_$eq($this.temporalWrites(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE_TIME, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultWrites $outer;

            public final DefaultWrites.TemporalFormatter<LocalDateTime> apply(java.time.format.DateTimeFormatter formatter) {
                return this.$outer.TemporalFormatter().DefaultLocalDateTimeFormatter(formatter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.play$api$libs$json$DefaultWrites$_setter_$DefaultOffsetDateTimeWrites_$eq($this.temporalWrites(java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultWrites $outer;

            public final DefaultWrites.TemporalFormatter<OffsetDateTime> apply(java.time.format.DateTimeFormatter formatter) {
                return this.$outer.TemporalFormatter().DefaultOffsetDateTimeFormatter(formatter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.play$api$libs$json$DefaultWrites$_setter_$DefaultZonedDateTimeWrites_$eq($this.temporalWrites(java.time.format.DateTimeFormatter.ISO_ZONED_DATE_TIME, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultWrites $outer;

            public final DefaultWrites.TemporalFormatter<ZonedDateTime> apply(java.time.format.DateTimeFormatter formatter) {
                return this.$outer.TemporalFormatter().DefaultZonedDateTimeFormatter(formatter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.play$api$libs$json$DefaultWrites$_setter_$DefaultLocalDateWrites_$eq($this.temporalWrites(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultWrites $outer;

            public final DefaultWrites.TemporalFormatter<LocalDate> apply(java.time.format.DateTimeFormatter formatter) {
                return this.$outer.TemporalFormatter().DefaultDateFormatter(formatter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.play$api$libs$json$DefaultWrites$_setter_$DefaultInstantWrites_$eq(new Writes<Instant>($this){

            public Writes<Instant> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<Instant> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(Instant i) {
                return new JsString(i.toString());
            }
            {
                Writes$class.$init$(this);
            }
        });
        $this.play$api$libs$json$DefaultWrites$_setter_$LocalDateTimeNumberWrites_$eq(new Writes<LocalDateTime>($this){

            public Writes<LocalDateTime> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<LocalDateTime> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(LocalDateTime t) {
                return new JsNumber(package$.MODULE$.BigDecimal().valueOf(t.toInstant(ZoneOffset.UTC).toEpochMilli()));
            }
            {
                Writes$class.$init$(this);
            }
        });
        $this.play$api$libs$json$DefaultWrites$_setter_$ZonedDateTimeNumberWrites_$eq(new Writes<ZonedDateTime>($this){

            public Writes<ZonedDateTime> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<ZonedDateTime> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(ZonedDateTime t) {
                return new JsNumber(package$.MODULE$.BigDecimal().valueOf(t.toInstant().toEpochMilli()));
            }
            {
                Writes$class.$init$(this);
            }
        });
        $this.play$api$libs$json$DefaultWrites$_setter_$LocalDateNumberWrites_$eq(new Writes<LocalDate>($this){

            public Writes<LocalDate> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<LocalDate> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(LocalDate t) {
                return new JsNumber(package$.MODULE$.BigDecimal().valueOf(t.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli()));
            }
            {
                Writes$class.$init$(this);
            }
        });
        $this.play$api$libs$json$DefaultWrites$_setter_$InstantNumberWrites_$eq(new Writes<Instant>($this){

            public Writes<Instant> transform(Function1<JsValue, JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public Writes<Instant> transform(Writes<JsValue> transformer) {
                return Writes$class.transform((Writes)this, transformer);
            }

            public JsValue writes(Instant t) {
                return new JsNumber(package$.MODULE$.BigDecimal().valueOf(t.toEpochMilli()));
            }
            {
                Writes$class.$init$(this);
            }
        });
    }
}

