/*
 * Decompiled with CFR 0.152.
 */
package play.core.j;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import play.api.libs.iteratee.Execution;
import play.core.j.FPromiseHelper$;
import play.libs.F;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FPromiseHelper$ {
    public static final FPromiseHelper$ MODULE$;
    private final Timer timer;

    static {
        new FPromiseHelper$();
    }

    private Timer timer() {
        return this.timer;
    }

    public <A> F.Promise<A> pure(A a) {
        return F.Promise.wrap(Future$.MODULE$.successful(a));
    }

    public <A> F.Promise<A> throwing(Throwable t) {
        return F.Promise.wrap(Future$.MODULE$.failed(t));
    }

    public <A> F.Promise<A> promise(Callable<A> callable, ExecutionContext ec) {
        return F.Promise.wrap(Future$.MODULE$.apply((Function0)new Serializable(callable){
            private final Callable callable$1;

            public final A apply() {
                return (A)this.callable$1.call();
            }
            {
                this.callable$1 = callable$1;
            }
        }, ec.prepare()));
    }

    public <A> F.Promise<A> promise(F.Function0<A> function, ExecutionContext ec) {
        return F.Promise.wrap(Future$.MODULE$.apply((Function0)new Serializable(function){
            private final F.Function0 function$1;

            public final A apply() {
                return (A)this.function$1.apply();
            }
            {
                this.function$1 = function$1;
            }
        }, ec.prepare()));
    }

    private <A> F.Promise<A> delayedWith(Function0<A> f2, long delay, TimeUnit unit, ExecutionContext ec) {
        ExecutionContext pec = ec.prepare();
        Promise p = Promise$.MODULE$.apply();
        this.timer().schedule(new TimerTask(f2, pec, p){
            private final Function0 f$1;
            private final ExecutionContext pec$1;
            private final Promise p$1;

            public void run() {
                this.p$1.completeWith(Future$.MODULE$.apply(this.f$1, this.pec$1));
            }
            {
                this.f$1 = f$1;
                this.pec$1 = pec$1;
                this.p$1 = p$1;
            }
        }, unit.toMillis(delay));
        return F.Promise.wrap(p.future());
    }

    public <A> F.Promise<A> delayed(Callable<A> callable, long duration, TimeUnit unit, ExecutionContext ec) {
        return this.delayedWith((Function0<A>)new Serializable(callable){
            private final Callable callable$2;

            public final A apply() {
                return (A)this.callable$2.call();
            }
            {
                this.callable$2 = callable$2;
            }
        }, duration, unit, ec);
    }

    public <A> F.Promise<A> delayed(F.Function0<A> function, long duration, TimeUnit unit, ExecutionContext ec) {
        return this.delayedWith((Function0<A>)new Serializable(function){
            private final F.Function0 function$2;

            public final A apply() {
                return (A)this.function$2.apply();
            }
            {
                this.function$2 = function$2;
            }
        }, duration, unit, ec);
    }

    public <A> A get(F.Promise<A> promise2, long timeout2, TimeUnit unit) {
        return (A)Await$.MODULE$.result(promise2.wrapped(), (Duration)Duration$.MODULE$.apply(timeout2, unit));
    }

    public <A, B> F.Promise<F.Either<A, B>> or(F.Promise<A> left, F.Promise<B> right) {
        Promise p = Promise$.MODULE$.apply();
        left.wrapped().onComplete((Function1)new Serializable(p){
            private final Promise p$2;

            public final boolean apply(Try<A> x0$1) {
                Try<A> try_ = x0$1;
                boolean bl = this.p$2.tryComplete(try_.map((Function1)new Serializable(this){

                    public final F.Either<A, B> apply(A x$1) {
                        return F.Either.Left(x$1);
                    }
                }));
                return bl;
            }
            {
                this.p$2 = p$2;
            }
        }, Execution.Implicits$.MODULE$.trampoline());
        right.wrapped().onComplete((Function1)new Serializable(p){
            private final Promise p$2;

            public final boolean apply(Try<B> x0$2) {
                Try<B> try_ = x0$2;
                boolean bl = this.p$2.tryComplete(try_.map((Function1)new Serializable(this){

                    public final F.Either<A, B> apply(B x$2) {
                        return F.Either.Right(x$2);
                    }
                }));
                return bl;
            }
            {
                this.p$2 = p$2;
            }
        }, Execution.Implicits$.MODULE$.trampoline());
        return F.Promise.wrap(p.future());
    }

    public <A, B> F.Promise<F.Tuple<A, B>> zip(F.Promise<A> pa, F.Promise<B> pb) {
        Future future = pa.wrapped().zip(pb.wrapped()).map((Function1)new Serializable(){

            public final F.Tuple<A, B> apply(Tuple2<A, B> x0$3) {
                Tuple2<A, B> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Object b = tuple2._2();
                    F.Tuple<Object, Object> tuple3 = new F.Tuple<Object, Object>(a, b);
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
        }, Execution.Implicits$.MODULE$.trampoline());
        return F.Promise.wrap(future);
    }

    public <A> F.Promise<List<A>> sequence(Iterable<F.Promise<A>> promises, ExecutionContext ec) {
        Buffer futures = (Buffer)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(promises).asScala()).toBuffer().map((Function1)new Serializable(){

            public final Future<A> apply(F.Promise<A> x$3) {
                return x$3.wrapped();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        ExecutionContext pec = ec.prepare();
        return F.Promise.wrap(Future$.MODULE$.sequence((TraversableOnce)futures, Buffer$.MODULE$.canBuildFrom(), pec).map((Function1)new Serializable(){

            public final List<A> apply(Buffer<A> az) {
                return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(az).asJava();
            }
        }, pec));
    }

    private <A> F.Promise<A> timeoutWith(Try<A> result, long delay, TimeUnit unit) {
        Promise p = Promise$.MODULE$.apply();
        this.timer().schedule(new TimerTask(result, p){
            private final Try result$1;
            private final Promise p$3;

            public void run() {
                this.p$3.complete(this.result$1);
            }
            {
                this.result$1 = result$1;
                this.p$3 = p$3;
            }
        }, unit.toMillis(delay));
        return F.Promise.wrap(p.future());
    }

    public <A> F.Promise<A> timeout(A message, long delay, TimeUnit unit) {
        return this.timeoutWith((Try<A>)new Success(message), delay, unit);
    }

    public <A> F.Promise<A> timeout(long delay, TimeUnit unit) {
        return this.timeoutWith((Try<A>)new Failure((Throwable)new TimeoutException("Timeout in promise")), delay, unit);
    }

    public <A> void onRedeem(F.Promise<A> promise2, F.Callback<A> action, ExecutionContext ec) {
        promise2.wrapped().onSuccess((PartialFunction)new Serializable(action){
            private final F.Callback action$1;

            public final <A1 extends A, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.action$1.invoke(A1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(A x1) {
                A a = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.action$1 = action$1;
            }
        }, ec.prepare());
    }

    public <A, B, T> F.Promise<B> map(F.Promise<A> promise2, F.Function<T, B> function, ExecutionContext ec) {
        return F.Promise.wrap(promise2.wrapped().map((Function1)new Serializable(function){
            private final F.Function function$3;

            public final B apply(A a) {
                return (B)this.function$3.apply(a);
            }
            {
                this.function$3 = function$3;
            }
        }, ec.prepare()));
    }

    public <A, B, T> F.Promise<B> flatMap(F.Promise<A> promise2, F.Function<T, F.Promise<B>> function, ExecutionContext ec) {
        return F.Promise.wrap(promise2.wrapped().flatMap((Function1)new Serializable(function){
            private final F.Function function$4;

            public final Future<B> apply(A a) {
                return ((F.Promise)this.function$4.apply(a)).wrapped();
            }
            {
                this.function$4 = function$4;
            }
        }, ec.prepare()));
    }

    public <A, T> F.Promise<A> filter(F.Promise<A> promise2, F.Predicate<T> predicate, ExecutionContext ec) {
        return F.Promise.wrap(promise2.wrapped().filter((Function1)new Serializable(predicate){
            private final F.Predicate predicate$1;

            public final boolean apply(T a) {
                return this.predicate$1.test(a);
            }
            {
                this.predicate$1 = predicate$1;
            }
        }, ec.prepare()));
    }

    public <A> F.Promise<A> recover(F.Promise<A> promise2, F.Function<Throwable, A> function, ExecutionContext ec) {
        return F.Promise.wrap(promise2.wrapped().recover((PartialFunction)new Serializable(function){
            private final F.Function function$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                R r = this.function$5.apply(A1);
                return (B1)r;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = true;
                return bl;
            }
            {
                this.function$5 = function$5;
            }
        }, ec.prepare()));
    }

    public <A> F.Promise<A> recoverWith(F.Promise<A> promise2, F.Function<Throwable, F.Promise<A>> function, ExecutionContext ec) {
        return F.Promise.wrap(promise2.wrapped().recoverWith((PartialFunction)new Serializable(function){
            private final F.Function function$6;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                Future<A> future = ((F.Promise)this.function$6.apply(A1)).wrapped();
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = true;
                return bl;
            }
            {
                this.function$6 = function$6;
            }
        }, ec.prepare()));
    }

    public <A> F.Promise<A> fallbackTo(F.Promise<A> promise2, F.Promise<A> fallback) {
        return F.Promise.wrap(promise2.wrapped().fallbackTo(fallback.wrapped()));
    }

    public <A> void onFailure(F.Promise<A> promise2, F.Callback<Throwable> action, ExecutionContext ec) {
        promise2.wrapped().onFailure((PartialFunction)new Serializable(action){
            private final F.Callback action$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                this.action$2.invoke(A1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x4) {
                Throwable throwable = x4;
                boolean bl = true;
                return bl;
            }
            {
                this.action$2 = action$2;
            }
        }, ec.prepare());
    }

    public <A, B, T> F.Promise<B> transform(F.Promise<A> promise2, F.Function<T, B> s, F.Function<Throwable, Throwable> f2, ExecutionContext ec) {
        return F.Promise.wrap(promise2.wrapped().transform((Function1)new Serializable(s){
            private final F.Function s$1;

            public final B apply(T a) {
                return (B)this.s$1.apply(a);
            }
            {
                this.s$1 = s$1;
            }
        }, (Function1)new Serializable(f2){
            private final F.Function f$2;

            public final Throwable apply(Throwable a) {
                return (Throwable)this.f$2.apply(a);
            }
            {
                this.f$2 = f$2;
            }
        }, ec.prepare()));
    }

    public <A> Promise<A> empty() {
        return Promise$.MODULE$.apply();
    }

    public <A> Future<A> getFuture(Promise<A> promise2) {
        return promise2.future();
    }

    public <T> Future<Void> completeWith(Promise<T> promise2, Future<T> other, ExecutionContext ec) {
        Promise p = Promise$.MODULE$.apply();
        other.onComplete((Function1)new Serializable(promise2, p){
            public final Promise promise$1;
            private final Promise p$4;

            public final Promise<BoxedUnit> apply(Try<T> x) {
                return this.p$4.complete(Try$.MODULE$.apply((Function0)new Serializable(this, x){
                    private final /* synthetic */ anonfun.completeWith.1 $outer;
                    private final Try x$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.promise$1.complete(this.x$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$5 = x$5;
                    }
                }));
            }
            {
                this.promise$1 = promise$1;
                this.p$4 = p$4;
            }
        }, ec);
        return p.future().map((Function1)new Serializable(){

            public final Null$ apply(BoxedUnit x$4) {
                return null;
            }
        }, ec);
    }

    public <T> Future<Object> tryCompleteWith(Promise<T> promise2, Future<T> other, ExecutionContext ec) {
        Promise p = Promise$.MODULE$.apply();
        other.onComplete((Function1)new Serializable(promise2, p){
            public final Promise promise$2;
            private final Promise p$5;

            public final Promise<Object> apply(Try<T> x) {
                return this.p$5.complete(Try$.MODULE$.apply((Function0)new Serializable(this, x){
                    private final /* synthetic */ anonfun.tryCompleteWith.1 $outer;
                    private final Try x$6;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.promise$2.tryComplete(this.x$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$6 = x$6;
                    }
                }));
            }
            {
                this.promise$2 = promise$2;
                this.p$5 = p$5;
            }
        }, ec);
        return p.future();
    }

    private FPromiseHelper$() {
        MODULE$ = this;
        this.timer = new Timer();
    }
}

