/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.util.concurrent.ExecutionException;
import play.api.Application;
import play.api.Application$;
import play.api.Configuration;
import play.api.DefaultGlobal$;
import play.api.Logger$;
import play.api.PlayException;
import play.api.Plugin;
import play.api.UsefulException;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.core.Router;
import play.core.SourceMapper;
import play.utils.PlayIO$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.io.Codec$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.control.NonFatal$;

public abstract class Application$class {
    public static Option plugin(Application $this, Class pluginClass) {
        return $this.plugins().find((Function1)new Serializable($this, pluginClass){
            private final Class pluginClass$1;

            public final boolean apply(Plugin p) {
                return this.pluginClass$1.isAssignableFrom(p.getClass());
            }
            {
                this.pluginClass$1 = pluginClass$1;
            }
        }).map((Function1)new Serializable($this){

            public final T apply(Plugin x$6) {
                return (T)x$6;
            }
        });
    }

    public static Option plugin(Application $this, ClassTag ct) {
        return $this.plugin(ct.runtimeClass());
    }

    public static Option routes(Application $this) {
        return $this.loadRoutes();
    }

    public static Option loadRoutes(Application $this) {
        Option option;
        try {
            Configuration qual$1 = $this.configuration();
            String x$14 = "application.router";
            Option<Set<String>> x$15 = qual$1.getString$default$2();
            option = new Some((Object)((Router.Routes)$this.classloader().loadClass((String)qual$1.getString(x$14, x$15).map((Function1)new Serializable($this){

                public final String apply(String x$7) {
                    return new StringBuilder().append((Object)x$7).append((Object)"$").toString();
                }
            }).getOrElse((Function0)new Serializable($this){

                public final String apply() {
                    return "Routes$";
                }
            })).getDeclaredField("MODULE$").get(null))).map((Function1)new Serializable($this){
                private final /* synthetic */ Application $outer;

                public final Router.Routes apply(Router.Routes router) {
                    Configuration qual$2 = this.$outer.configuration();
                    String x$16 = "application.context";
                    Option<Set<String>> x$17 = qual$2.getString$default$2();
                    router.setPrefix((String)qual$2.getString(x$16, x$17).map((Function1)new Serializable(this){
                        private final /* synthetic */ Application$.anonfun.loadRoutes.3 $outer;

                        public final String apply(String prefix) {
                            if (prefix.startsWith("/")) {
                                return prefix;
                            }
                            Configuration qual$3 = this.$outer.play$api$Application$$anonfun$$$outer().configuration();
                            String x$18 = "application.context";
                            String x$19 = "Invalid application context";
                            Option<Throwable> x$20 = qual$3.reportError$default$3();
                            throw qual$3.reportError(x$18, x$19, x$20);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }).getOrElse((Function0)new Serializable(this){

                        public final String apply() {
                            return "/";
                        }
                    }));
                    return router;
                }

                public /* synthetic */ Application play$api$Application$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            Configuration qual$4 = $this.configuration();
            String x$21 = "application.router";
            Option<Set<String>> x$22 = qual$4.getString$default$2();
            option = qual$4.getString(x$21, x$22).map((Function1)new Serializable($this){
                private final /* synthetic */ Application $outer;

                public final Nothing$ apply(String routerName) {
                    Configuration qual$5 = this.$outer.configuration();
                    String x$23 = "application.router";
                    String x$24 = new StringBuilder().append((Object)"Router not found: ").append((Object)routerName).toString();
                    Option<Throwable> x$25 = qual$5.reportError$default$3();
                    throw qual$5.reportError(x$23, x$24, x$25);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return option;
    }

    public static Future handleError(Application $this, RequestHeader request, Throwable e) {
        Future<Result> future;
        try {
            Future<Result> future2;
            Throwable throwable = e;
            if (throwable instanceof UsefulException) {
                UsefulException usefulException = (UsefulException)throwable;
                throw usefulException;
            }
            if (!(throwable instanceof ExecutionException)) {
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    Option source = $this.sources().flatMap((Function1)new Serializable($this, throwable2){
                        private final Throwable x4$1;

                        public final Option<Tuple2<File, Option<Object>>> apply(SourceMapper x$8) {
                            return x$8.sourceFor(this.x4$1);
                        }
                        {
                            this.x4$1 = x4$1;
                        }
                    });
                    throw new PlayException.ExceptionSource($this, source, throwable2){
                        private final Option source$1;

                        public Integer line() {
                            return (Integer)this.source$1.flatMap((Function1)new Serializable(this){

                                public final Option<Object> apply(Tuple2<File, Option<Object>> x$9) {
                                    return (Option)x$9._2();
                                }
                            }).map((Function1)new Serializable(this){

                                public final Integer apply(int x$10) {
                                    return BoxesRunTime.boxToInteger((int)x$10);
                                }
                            }).orNull(Predef$.MODULE$.$conforms());
                        }

                        public Null$ position() {
                            return null;
                        }

                        public String input() {
                            return (String)this.source$1.map((Function1)new Serializable(this){

                                public final File apply(Tuple2<File, Option<Object>> x$11) {
                                    return (File)x$11._1();
                                }
                            }).map((Function1)new Serializable(this){

                                public final String apply(File file2) {
                                    return PlayIO$.MODULE$.readFileAsString(file2, Codec$.MODULE$.fallbackSystemCodec());
                                }
                            }).orNull(Predef$.MODULE$.$conforms());
                        }

                        public String sourceName() {
                            return (String)this.source$1.map((Function1)new Serializable(this){

                                public final String apply(Tuple2<File, Option<Object>> x$12) {
                                    return ((File)x$12._1()).getAbsolutePath();
                                }
                            }).orNull(Predef$.MODULE$.$conforms());
                        }
                        {
                            this.source$1 = source$1;
                            super("Execution exception", new StringOps(Predef$.MODULE$.augmentString("[%s: %s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x4$1.getClass().getSimpleName(), x4$1.getMessage()})), x4$1);
                        }
                    };
                }
                throw new MatchError((Object)throwable);
            }
            ExecutionException executionException = (ExecutionException)throwable;
            future = future2 = $this.handleError(request, executionException.getCause());
        }
        catch (Throwable throwable) {
            Future<Result> future3;
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e2 = (Throwable)option.get();
            try {
                Logger$.MODULE$.error((Function0<String>)new Serializable($this, e2, request){
                    private final Throwable e$1;
                    private final RequestHeader request$1;

                    public final String apply() {
                        String string;
                        StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("\n        |\n        |! %sInternal server error, for (%s) [%s] ->\n        |")).stripMargin()));
                        Object[] objectArray = new Object[3];
                        Throwable throwable = this.e$1;
                        if (throwable instanceof PlayException) {
                            PlayException playException = (PlayException)throwable;
                            string = new StringBuilder().append((Object)"@").append((Object)playException.id).append((Object)" - ").toString();
                        } else {
                            string = "";
                        }
                        objectArray[0] = string;
                        objectArray[1] = this.request$1.method();
                        objectArray[2] = this.request$1.uri();
                        return stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    }
                    {
                        this.e$1 = e$1;
                        this.request$1 = request$1;
                    }
                }, (Function0<Throwable>)new Serializable($this, e2){
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                future3 = $this.global().onError(request, e2);
            }
            catch (Throwable throwable4) {
                Throwable throwable5 = throwable4;
                Option option2 = NonFatal$.MODULE$.unapply(throwable5);
                if (option2.isEmpty()) {
                    throw throwable4;
                }
                Throwable e3 = (Throwable)option2.get();
                Future<Result> future4 = DefaultGlobal$.MODULE$.onError(request, e3);
                future3 = future4;
            }
            Future<Result> future5 = future3;
            future = future5;
        }
        return future;
    }

    public static File getFile(Application $this, String relativePath) {
        return new File($this.path(), relativePath);
    }

    public static Option getExistingFile(Application $this, String relativePath) {
        return Option$.MODULE$.apply((Object)$this.getFile(relativePath)).filter((Function1)new Serializable($this){

            public final boolean apply(File x$13) {
                return x$13.exists();
            }
        });
    }

    public static Option resource(Application $this, String name2) {
        return Option$.MODULE$.apply((Object)$this.classloader().getResource((String)Option$.MODULE$.apply((Object)name2).map((Function1)new Serializable($this){

            public final String apply(String x0$3) {
                String string = x0$3;
                String string2 = string.startsWith("/") ? (String)new StringOps(Predef$.MODULE$.augmentString(string)).drop(1) : string;
                return string2;
            }
        }).get()));
    }

    public static Option resourceAsStream(Application $this, String name2) {
        return Option$.MODULE$.apply((Object)$this.classloader().getResourceAsStream((String)Option$.MODULE$.apply((Object)name2).map((Function1)new Serializable($this){

            public final String apply(String x0$4) {
                String string = x0$4;
                String string2 = string.startsWith("/") ? (String)new StringOps(Predef$.MODULE$.augmentString(string)).drop(1) : string;
                return string2;
            }
        }).get()));
    }

    public static void $init$(Application $this) {
        Set validValues = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF", "INHERITED"}));
        Application$.anonfun.1 setLevel = new Application$.anonfun.1($this);
        Logger$.MODULE$.configure((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application.home"), (Object)$this.path().getAbsolutePath())}))), (Map<String, Level>)((Map)$this.configuration().getConfig("logger").map((Function1)new Application$.anonfun.2($this, validValues, (Function1)setLevel)).getOrElse((Function0)new Application$.anonfun.3($this))), $this.mode());
    }
}

