/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ning;

import com.fasterxml.jackson.databind.JsonNode;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.generators.FileBodyGenerator;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.core.parsers.FormUrlEncodedParser;
import play.libs.F;
import play.libs.Json;
import play.libs.oauth.OAuth;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import play.libs.ws.WSSignatureCalculator;
import play.libs.ws.ning.NingWSClient;
import play.libs.ws.ning.NingWSResponse;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class NingWSRequest
implements WSRequest {
    private final String url;
    private String method = "GET";
    private Object body = null;
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> queryParameters = new HashMap<String, Collection<String>>();
    private String username = null;
    private String password = null;
    private WSAuthScheme scheme = null;
    private WSSignatureCalculator calculator = null;
    private NingWSClient client = null;
    private int timeout = 0;
    private Boolean followRedirects = null;
    private String virtualHost = null;

    public NingWSRequest(NingWSClient ningWSClient, String string) {
        this.client = ningWSClient;
        URI uRI = URI.create(string);
        this.url = string;
        String string2 = uRI.getUserInfo();
        if (string2 != null) {
            this.setAuth(string2);
        }
        if (uRI.getQuery() != null) {
            this.setQueryString(uRI.getQuery());
        }
    }

    @Override
    public NingWSRequest setHeader(String string, String string2) {
        if (this.headers.containsKey(string)) {
            Collection<String> collection = this.headers.get(string);
            collection.add(string2);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.headers.put(string, arrayList);
        }
        return this;
    }

    @Override
    public WSRequest setQueryString(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length > 2) {
                throw new RuntimeException(new MalformedURLException("QueryString parameter should not have more than 2 = per part"));
            }
            if (stringArray2.length >= 2) {
                this.setQueryParameter(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (stringArray2.length == 1 && string2.charAt(0) != '=') {
                this.setQueryParameter(stringArray2[0], null);
                continue;
            }
            throw new RuntimeException(new MalformedURLException("QueryString part should not start with an = and not be empty"));
        }
        return this;
    }

    @Override
    public WSRequest setQueryParameter(String string, String string2) {
        if (this.queryParameters.containsKey(string)) {
            Collection<String> collection = this.queryParameters.get(string);
            collection.add(string2);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.queryParameters.put(string, arrayList);
        }
        return this;
    }

    @Override
    public WSRequest setAuth(String string) {
        this.scheme = WSAuthScheme.BASIC;
        if (string.equals("")) {
            throw new RuntimeException(new MalformedURLException("userInfo should not be empty"));
        }
        int n = string.indexOf(":");
        if (n == 0) {
            this.username = "";
            this.password = string.substring(1);
        } else if (n == -1) {
            this.username = string;
            this.password = "";
        } else {
            this.username = string.substring(0, n);
            this.password = string.substring(n + 1);
        }
        return this;
    }

    @Override
    public WSRequest setAuth(String string, String string2) {
        this.username = string;
        this.password = string2;
        this.scheme = WSAuthScheme.BASIC;
        return this;
    }

    @Override
    public WSRequest setAuth(String string, String string2, WSAuthScheme wSAuthScheme) {
        this.username = string;
        this.password = string2;
        this.scheme = wSAuthScheme;
        return this;
    }

    @Override
    public WSRequest sign(WSSignatureCalculator wSSignatureCalculator) {
        this.calculator = wSSignatureCalculator;
        return this;
    }

    @Override
    public WSRequest setFollowRedirects(Boolean bl) {
        this.followRedirects = bl;
        return this;
    }

    @Override
    public WSRequest setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    @Override
    public WSRequest setRequestTimeout(long l) {
        if (l < -1L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout must be between -1 and 2147483647 inclusive");
        }
        this.timeout = (int)l;
        return this;
    }

    @Override
    public WSRequest setContentType(String string) {
        return this.setHeader("Content-Type", string);
    }

    @Override
    public WSRequest setMethod(String string) {
        this.method = string;
        return this;
    }

    @Override
    public WSRequest setBody(String string) {
        this.body = string;
        return this;
    }

    @Override
    public WSRequest setBody(JsonNode jsonNode) {
        this.body = jsonNode;
        return this;
    }

    @Override
    public WSRequest setBody(InputStream inputStream) {
        this.body = inputStream;
        return this;
    }

    @Override
    public WSRequest setBody(File file) {
        this.body = file;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Map<String, Collection<String>> getHeaders() {
        return new HashMap<String, Collection<String>>(this.headers);
    }

    @Override
    public Map<String, Collection<String>> getQueryParameters() {
        return new HashMap<String, Collection<String>>(this.queryParameters);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public WSAuthScheme getScheme() {
        return this.scheme;
    }

    @Override
    public WSSignatureCalculator getCalculator() {
        return this.calculator;
    }

    @Override
    public long getRequestTimeout() {
        return this.timeout;
    }

    @Override
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public F.Promise<WSResponse> get() {
        return this.execute("GET");
    }

    @Override
    public F.Promise<WSResponse> patch(String string) {
        this.setMethod("PATCH");
        this.setBody(string);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> patch(JsonNode jsonNode) {
        this.setMethod("PATCH");
        this.setBody(jsonNode);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> patch(InputStream inputStream) {
        this.setMethod("PATCH");
        this.setBody(inputStream);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> patch(File file) {
        this.setMethod("PATCH");
        this.setBody(file);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> post(String string) {
        this.setMethod("POST");
        this.setBody(string);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> post(JsonNode jsonNode) {
        this.setMethod("POST");
        this.setBody(jsonNode);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> post(InputStream inputStream) {
        this.setMethod("POST");
        this.setBody(inputStream);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> post(File file) {
        this.setMethod("POST");
        this.setBody(file);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> put(String string) {
        this.setMethod("PUT");
        this.setBody(string);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> put(JsonNode jsonNode) {
        this.setMethod("PUT");
        this.setBody(jsonNode);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> put(InputStream inputStream) {
        this.setMethod("PUT");
        this.setBody(inputStream);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> put(File file) {
        this.setMethod("PUT");
        this.setBody(file);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> delete() {
        return this.execute("DELETE");
    }

    @Override
    public F.Promise<WSResponse> head() {
        return this.execute("HEAD");
    }

    @Override
    public F.Promise<WSResponse> options() {
        return this.execute("OPTIONS");
    }

    @Override
    public F.Promise<WSResponse> execute(String string) {
        this.setMethod(string);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> execute() {
        Request request = this.buildRequest();
        return this.execute(request);
    }

    Request buildRequest() {
        Object object;
        RequestBuilder requestBuilder = new RequestBuilder(this.method);
        requestBuilder.setUrl(this.url);
        requestBuilder.setQueryParams((Map)new FluentStringsMap(this.queryParameters));
        requestBuilder.setHeaders(this.headers);
        if (this.body != null) {
            if (this.body instanceof String) {
                Object object2;
                String string;
                object = (String)this.body;
                FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap(this.headers);
                String string2 = fluentCaseInsensitiveStringsMap.getFirstValue("Content-Type");
                if (string2 == null) {
                    string2 = "text/plain";
                }
                if ((string = AsyncHttpProviderUtils.parseCharset((String)string2)) == null) {
                    string = "utf-8";
                    object2 = new ArrayList();
                    object2.add(string2 + "; charset=utf-8");
                    fluentCaseInsensitiveStringsMap.replace((Object)"Content-Type", object2);
                }
                try {
                    object2 = ((String)object).getBytes(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                if (string2.equals("application/x-www-form-urlencoded")) {
                    Map map = FormUrlEncodedParser.parseAsJava((String)object, (String)"utf-8");
                    for (String string3 : map.keySet()) {
                        List list = (List)map.get(string3);
                        for (String string4 : list) {
                            requestBuilder.addFormParam(string3, string4);
                        }
                    }
                } else {
                    requestBuilder.setBody((String)object);
                }
                requestBuilder.setHeaders(fluentCaseInsensitiveStringsMap);
                requestBuilder.setBodyEncoding(string);
            } else if (this.body instanceof JsonNode) {
                object = (JsonNode)this.body;
                FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap(this.headers);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("application/json; charset=utf-8");
                fluentCaseInsensitiveStringsMap.replace((Object)"Content-Type", arrayList);
                String string = Json.stringify((JsonNode)object);
                try {
                    byte[] byArray = string.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                requestBuilder.setBody(string);
                requestBuilder.setHeaders(fluentCaseInsensitiveStringsMap);
                requestBuilder.setBodyEncoding("utf-8");
            } else if (this.body instanceof File) {
                object = (File)this.body;
                FileBodyGenerator fileBodyGenerator = new FileBodyGenerator((File)object);
                requestBuilder.setBody((BodyGenerator)fileBodyGenerator);
            } else if (this.body instanceof InputStream) {
                object = (InputStream)this.body;
                InputStreamBodyGenerator inputStreamBodyGenerator = new InputStreamBodyGenerator((InputStream)object);
                requestBuilder.setBody((BodyGenerator)inputStreamBodyGenerator);
            } else {
                throw new IllegalStateException("Impossible body: " + this.body);
            }
        }
        if (this.timeout == -1 || this.timeout > 0) {
            requestBuilder.setRequestTimeout(this.timeout);
        }
        if (this.followRedirects != null) {
            requestBuilder.setFollowRedirects(this.followRedirects.booleanValue());
        }
        if (this.virtualHost != null) {
            requestBuilder.setVirtualHost(this.virtualHost);
        }
        if (this.username != null && this.password != null && this.scheme != null) {
            requestBuilder.setRealm(this.auth(this.username, this.password, this.scheme));
        }
        if (this.calculator != null) {
            if (this.calculator instanceof OAuth.OAuthCalculator) {
                object = ((OAuth.OAuthCalculator)this.calculator).getCalculator();
                requestBuilder.setSignatureCalculator((SignatureCalculator)object);
            } else {
                throw new IllegalStateException("Use OAuth.OAuthCalculator");
            }
        }
        return requestBuilder.build();
    }

    private F.Promise<WSResponse> execute(Request request) {
        final Promise promise = Promise$.MODULE$.apply();
        try {
            AsyncHttpClient asyncHttpClient = (AsyncHttpClient)this.client.getUnderlying();
            asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) {
                    Response response2 = response;
                    promise.success((Object)new NingWSResponse(response2));
                    return response;
                }

                public void onThrowable(Throwable throwable) {
                    promise.failure(throwable);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            promise.failure((Throwable)runtimeException);
        }
        return F.Promise.wrap((Future)promise.future());
    }

    Realm auth(String string, String string2, WSAuthScheme wSAuthScheme) {
        Realm.AuthScheme authScheme = Realm.AuthScheme.valueOf((String)wSAuthScheme.name());
        return new Realm.RealmBuilder().setScheme(authScheme).setPrincipal(string).setPassword(string2).setUsePreemptiveAuth(true).build();
    }
}

