/*
 * Decompiled with CFR 0.152.
 */
package play.libs.oauth;

import com.ning.http.client.oauth.OAuthSignatureCalculator;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthException;
import play.libs.ws.WSSignatureCalculator;

public class OAuth {
    private ServiceInfo info;
    private OAuthProvider provider;

    public OAuth(ServiceInfo serviceInfo) {
        this(serviceInfo, true);
    }

    public OAuth(ServiceInfo serviceInfo, boolean bl) {
        this.info = serviceInfo;
        this.provider = new CommonsHttpOAuthProvider(serviceInfo.requestTokenURL, serviceInfo.accessTokenURL, serviceInfo.authorizationURL);
        this.provider.setOAuth10a(bl);
    }

    public ServiceInfo getInfo() {
        return this.info;
    }

    public OAuthProvider getProvider() {
        return this.provider;
    }

    public RequestToken retrieveRequestToken(String string) {
        DefaultOAuthConsumer defaultOAuthConsumer = new DefaultOAuthConsumer(this.info.key.key, this.info.key.secret);
        try {
            this.provider.retrieveRequestToken((OAuthConsumer)defaultOAuthConsumer, string, new String[0]);
            return new RequestToken(defaultOAuthConsumer.getToken(), defaultOAuthConsumer.getTokenSecret());
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException(oAuthException);
        }
    }

    public RequestToken retrieveAccessToken(RequestToken requestToken, String string) {
        DefaultOAuthConsumer defaultOAuthConsumer = new DefaultOAuthConsumer(this.info.key.key, this.info.key.secret);
        defaultOAuthConsumer.setTokenWithSecret(requestToken.token, requestToken.secret);
        try {
            this.provider.retrieveAccessToken((OAuthConsumer)defaultOAuthConsumer, string, new String[0]);
            return new RequestToken(defaultOAuthConsumer.getToken(), defaultOAuthConsumer.getTokenSecret());
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException(oAuthException);
        }
    }

    public String redirectUrl(String string) {
        return oauth.signpost.OAuth.addQueryParameters((String)this.provider.getAuthorizationWebsiteUrl(), (String[])new String[]{"oauth_token", string});
    }

    public static class OAuthCalculator
    implements WSSignatureCalculator {
        private OAuthSignatureCalculator calculator;

        public OAuthCalculator(ConsumerKey consumerKey, RequestToken requestToken) {
            com.ning.http.client.oauth.ConsumerKey consumerKey2 = new com.ning.http.client.oauth.ConsumerKey(consumerKey.key, consumerKey.secret);
            com.ning.http.client.oauth.RequestToken requestToken2 = new com.ning.http.client.oauth.RequestToken(requestToken.token, requestToken.secret);
            this.calculator = new OAuthSignatureCalculator(consumerKey2, requestToken2);
        }

        public OAuthSignatureCalculator getCalculator() {
            return this.calculator;
        }
    }

    public static class ServiceInfo {
        public String requestTokenURL;
        public String accessTokenURL;
        public String authorizationURL;
        public ConsumerKey key;

        public ServiceInfo(String string, String string2, String string3, ConsumerKey consumerKey) {
            this.requestTokenURL = string;
            this.accessTokenURL = string2;
            this.authorizationURL = string3;
            this.key = consumerKey;
        }
    }

    public static class RequestToken {
        public String token;
        public String secret;

        public RequestToken(String string, String string2) {
            this.token = string;
            this.secret = string2;
        }
    }

    public static class ConsumerKey {
        public String key;
        public String secret;

        public ConsumerKey(String string, String string2) {
            this.key = string;
            this.secret = string2;
        }
    }
}

