/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())));
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), ZonedDateTime::withZoneSameInstant);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;

    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter parser, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust) {
        super(supportedType, parser);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? (d, z) -> d : adjust;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, DateTimeFormatter f) {
        super(base.handledType(), f);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
    }

    @Override
    protected JsonDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dtf);
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                return this._fromDecimal(context, parser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(context, parser.getLongValue());
            }
            case 6: {
                Temporal value;
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                int dots = this._countPeriods(string);
                if (dots >= 0) {
                    try {
                        if (dots == 0) {
                            return this._fromLong(context, Long.parseLong(string));
                        }
                        if (dots == 1) {
                            return this._fromDecimal(context, new BigDecimal(string));
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                try {
                    TemporalAccessor acc = this._formatter.parse(string);
                    value = (Temporal)this.parsedToValue.apply(acc);
                    if (context.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)) {
                        return (T)((Temporal)this.adjust.apply(value, this.getZone(context)));
                    }
                }
                catch (DateTimeException e) {
                    throw this._peelDTE(e);
                }
                return (T)value;
            }
        }
        throw context.mappingException("Expected type float, integer, or string.");
    }

    protected int _countPeriods(String str) {
        int commas = 0;
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                ++commas;
                continue;
            }
            return -1;
        }
        return commas;
    }

    protected T _fromLong(DeserializationContext context, long timestamp) {
        if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(timestamp, 0, this.getZone(context))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(timestamp, this.getZone(context))));
    }

    protected T _fromDecimal(DeserializationContext context, BigDecimal value) {
        long seconds = value.longValue();
        int nanoseconds = DecimalUtils.extractNanosecondDecimal(value, seconds);
        return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(seconds, nanoseconds, this.getZone(context))));
    }

    private ZoneId getZone(DeserializationContext context) {
        return this._valueClass == Instant.class ? null : context.getTimeZone().toZoneId();
    }

    private static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        private FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    private static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        private FromIntegerArguments(long value, ZoneId zoneId) {
            this.value = value;
            this.zoneId = zoneId;
        }
    }
}

