/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.packager.universal;

import com.typesafe.sbt.packager.permissions$;
import com.typesafe.sbt.packager.permissions$OctalString$;
import com.typesafe.sbt.packager.universal.ZipHelper;
import com.typesafe.sbt.packager.universal.ZipHelper$FileMapping$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import sbt.IO$;
import sbt.Process$;
import sbt.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ZipHelper$ {
    public static final ZipHelper$ MODULE$;

    static {
        new ZipHelper$();
    }

    public void zipNative(Traversable<Tuple2<File, String>> sources, File outputZip) {
        IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable(sources, outputZip){
            public static final long serialVersionUID = 0L;
            private final Traversable sources$1;
            private final File outputZip$1;

            public final void apply(File dir) {
                String name = this.outputZip$1.getName();
                File zipDir = package$.MODULE$.richFile(dir).$div(name.endsWith(".zip") ? (String)new StringOps(Predef$.MODULE$.augmentString(name)).dropRight(4) : name);
                Traversable files = (Traversable)this.sources$1.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, String> check$ifrefutable$1) {
                        Tuple2<File, String> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).map((Function1)new Serializable(this, zipDir){
                    public static final long serialVersionUID = 0L;
                    private final File zipDir$1;

                    public final Tuple2<File, File> apply(Tuple2<File, String> x$1) {
                        Tuple2<File, String> tuple2 = x$1;
                        if (tuple2 != null) {
                            File file = (File)tuple2._1();
                            String name = (String)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)file), (Object)package$.MODULE$.richFile(this.zipDir$1).$div(name));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.zipDir$1 = zipDir$1;
                    }
                }, Traversable$.MODULE$.canBuildFrom());
                IO$.MODULE$.copy(files, IO$.MODULE$.copy$default$2(), IO$.MODULE$.copy$default$3());
                files.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, File> check$ifrefutable$2) {
                        Tuple2<File, File> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, File> x$2) {
                        Tuple2<File, File> tuple2 = x$2;
                        if (tuple2 != null) {
                            File src = (File)tuple2._1();
                            boolean bl = src.canExecute();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<File, File> x$3) {
                        Tuple2<File, File> tuple2 = x$3;
                        if (tuple2 != null) {
                            File target = (File)tuple2._2();
                            boolean bl = target.setExecutable(true, true);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                String[] dirFileNames = (String[])Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)zipDir.listFiles()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File[] apply() {
                        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$4) {
                        return x$4.getName();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                int n = Process$.MODULE$.apply((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zip", "-r", name}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])dirFileNames), Seq$.MODULE$.canBuildFrom()), zipDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
                switch (n) {
                    default: {
                        throw scala.sys.package$.MODULE$.error("Failed to run native zip application!");
                    }
                    case 0: 
                }
                IO$.MODULE$.copyFile(package$.MODULE$.richFile(zipDir).$div(name), this.outputZip$1, IO$.MODULE$.copyFile$default$3());
            }
            {
                this.sources$1 = sources$1;
                this.outputZip$1 = outputZip$1;
            }
        });
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip) {
        Seq mappings = (Seq)((TraversableLike)sources.toSeq().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<File, String> check$ifrefutable$3) {
                Tuple2<File, String> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<File, String>, Object> apply(Tuple2<File, String> x$6) {
                Tuple2<File, String> tuple2 = x$6;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    int perm = file.isDirectory() || file.canExecute() ? permissions$OctalString$.MODULE$.oct$extension(permissions$.MODULE$.OctalString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0755"}))), (Seq<Object>)Nil$.MODULE$) : permissions$OctalString$.MODULE$.oct$extension(permissions$.MODULE$.OctalString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0644"}))), (Seq<Object>)Nil$.MODULE$);
                    Tuple2 tuple22 = new Tuple2(tuple2, (Object)BoxesRunTime.boxToInteger((int)perm));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZipHelper.FileMapping apply(Tuple2<Tuple2<File, String>, Object> x$7) {
                Tuple2<Tuple2<File, String>, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int perm = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        File file = (File)tuple22._1();
                        String name = (String)tuple22._2();
                        ZipHelper.FileMapping fileMapping = new ZipHelper.FileMapping(file, name, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)perm)));
                        return fileMapping;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.archive((Seq<ZipHelper.FileMapping>)mappings, outputZip);
    }

    public void zipNIO(Traversable<Tuple2<File, String>> sources, File outputZip) {
        Predef$.MODULE$.require(!outputZip.isDirectory(), (Function0)new Serializable(outputZip){
            public static final long serialVersionUID = 0L;
            private final File outputZip$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Specified output file ").append((Object)this.outputZip$2).append((Object)" is a directory.").toString();
            }
            {
                this.outputZip$2 = outputZip$2;
            }
        });
        Seq mappings = (Seq)sources.toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZipHelper.FileMapping apply(Tuple2<File, String> x0$1) {
                Tuple2<File, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String name = (String)tuple2._2();
                    ZipHelper.FileMapping fileMapping = new ZipHelper.FileMapping(file, name, ZipHelper$FileMapping$.MODULE$.apply$default$3());
                    return fileMapping;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        File outputDir = outputZip.getParentFile();
        IO$.MODULE$.createDirectory(outputDir);
        this.withZipFilesystem(outputZip, this.withZipFilesystem$default$2(), (Function1<FileSystem, BoxedUnit>)new Serializable(mappings){
            public static final long serialVersionUID = 0L;
            private final Seq mappings$1;

            public final void apply(FileSystem system) {
                this.mappings$1.foreach((Function1)new Serializable(this, system){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem system$1;

                    public final Path apply(ZipHelper.FileMapping x0$2) {
                        ZipHelper.FileMapping fileMapping;
                        block4: {
                            Path path;
                            block3: {
                                block2: {
                                    fileMapping = x0$2;
                                    if (fileMapping == null) break block2;
                                    File dir = fileMapping.file();
                                    String name = fileMapping.name();
                                    if (!dir.isDirectory()) break block2;
                                    path = Files.createDirectories(this.system$1.getPath(name, new String[0]), new FileAttribute[0]);
                                    break block3;
                                }
                                if (fileMapping == null) break block4;
                                File file = fileMapping.file();
                                String name = fileMapping.name();
                                Path dest = this.system$1.getPath(name, new String[0]);
                                Option$.MODULE$.apply((Object)dest.getParent()).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Path apply(Path x$8) {
                                        return Files.createDirectories(x$8, new FileAttribute[0]);
                                    }
                                });
                                path = Files.copy(file.toPath(), dest, StandardCopyOption.COPY_ATTRIBUTES);
                            }
                            return path;
                        }
                        throw new MatchError((Object)fileMapping);
                    }
                    {
                        this.system$1 = system$1;
                    }
                });
            }
            {
                this.mappings$1 = mappings$1;
            }
        });
    }

    private void archive(Seq<ZipHelper.FileMapping> sources, File outputFile) {
        if (outputFile.isDirectory()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Specified output file ").append((Object)outputFile).append((Object)" is a directory.").toString());
        }
        File outputDir = outputFile.getParentFile();
        IO$.MODULE$.createDirectory(outputDir);
        this.withZipOutput(outputFile, (Function1<ZipArchiveOutputStream, BoxedUnit>)new Serializable(sources){
            public static final long serialVersionUID = 0L;
            private final Seq sources$2;

            public final void apply(ZipArchiveOutputStream output) {
                this.sources$2.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ZipHelper.FileMapping check$ifrefutable$4) {
                        ZipHelper.FileMapping fileMapping = check$ifrefutable$4;
                        boolean bl = fileMapping != null;
                        return bl;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ZipHelper.FileMapping x$9) {
                        ZipHelper.FileMapping fileMapping = x$9;
                        if (fileMapping != null) {
                            File file = fileMapping.file();
                            boolean bl = !file.isDirectory();
                            return bl;
                        }
                        throw new MatchError((Object)fileMapping);
                    }
                }).foreach((Function1)new Serializable(this, output){
                    public static final long serialVersionUID = 0L;
                    private final ZipArchiveOutputStream output$1;

                    public final void apply(ZipHelper.FileMapping x$10) {
                        ZipHelper.FileMapping fileMapping = x$10;
                        if (fileMapping != null) {
                            File file = fileMapping.file();
                            String name = fileMapping.name();
                            Option<Object> mode = fileMapping.unixMode();
                            ZipArchiveEntry entry = new ZipArchiveEntry(file, ZipHelper$.MODULE$.com$typesafe$sbt$packager$universal$ZipHelper$$normalizePath(name));
                            mode.foreach((Function1)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final ZipArchiveEntry entry$1;

                                public final void apply(int x$1) {
                                    this.apply$mcVI$sp(x$1);
                                }

                                public void apply$mcVI$sp(int x$1) {
                                    this.entry$1.setUnixMode(x$1);
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            });
                            this.output$1.putArchiveEntry((ArchiveEntry)entry);
                            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)this.output$1);
                            this.output$1.closeArchiveEntry();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)fileMapping);
                    }
                    {
                        this.output$1 = output$1;
                    }
                });
            }
            {
                this.sources$2 = sources$2;
            }
        });
    }

    private void withZipOutput(File file, Function1<ZipArchiveOutputStream, BoxedUnit> f) {
        ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(file);
        zipOut.setLevel(9);
        try {
            f.apply((Object)zipOut);
            return;
        }
        finally {
            zipOut.close();
        }
    }

    public String com$typesafe$sbt$packager$universal$ZipHelper$$normalizePath(String path) {
        char sep = File.separatorChar;
        return sep == '/' ? path : path.replace(sep, '/');
    }

    public void withZipFilesystem(File zipFile, boolean overwrite, Function1<FileSystem, BoxedUnit> f) {
        Object object = overwrite ? BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(zipFile.toPath())) : BoxedUnit.UNIT;
        java.util.Map env = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"create"), (Object)"true")}))).asJava();
        URI uri = new URI("jar", zipFile.toPath().toUri().toString(), null);
        FileSystem system = FileSystems.newFileSystem(uri, env);
        try {
            f.apply((Object)system);
            return;
        }
        finally {
            system.close();
        }
    }

    public boolean withZipFilesystem$default$2() {
        return true;
    }

    private ZipHelper$() {
        MODULE$ = this;
    }
}

