/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.packager.debian;

import com.typesafe.sbt.packager.archetypes.TemplateWriter$;
import com.typesafe.sbt.packager.chmod$;
import com.typesafe.sbt.packager.debian.DebianPlugin$;
import com.typesafe.sbt.packager.debian.DebianPluginLike;
import com.typesafe.sbt.packager.debian.DebianPluginLike$;
import com.typesafe.sbt.packager.linux.LinuxFileMetaData;
import com.typesafe.sbt.packager.linux.LinuxPackageMapping;
import com.typesafe.sbt.packager.linux.LinuxPlugin$Users$;
import com.typesafe.sbt.packager.universal.Archives$;
import java.io.File;
import java.nio.charset.Charset;
import sbt.IO$;
import sbt.package$;
import sbt.std.TaskStreams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class DebianPluginLike$class {
    public static final void copyAndFixPerms(DebianPluginLike $this, File from, File to, LinuxFileMetaData perms, boolean zipped) {
        Object object;
        if (zipped) {
            object = IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable($this, from, to){
                public static final long serialVersionUID = 0L;
                private final File from$1;
                private final File to$1;

                public final void apply(File dir) {
                    File tmp = package$.MODULE$.richFile(dir).$div(this.from$1.getName());
                    IO$.MODULE$.copyFile(this.from$1, tmp, IO$.MODULE$.copyFile$default$3());
                    File zipped = Archives$.MODULE$.gzip(tmp);
                    IO$.MODULE$.copyFile(zipped, this.to$1, true);
                }
                {
                    this.from$1 = from$1;
                    this.to$1 = to$1;
                }
            });
        } else {
            IO$.MODULE$.copyFile(from, to, true);
            object = BoxedUnit.UNIT;
        }
        chmod$.MODULE$.apply(to, perms.permissions());
    }

    public static final boolean copyAndFixPerms$default$4(DebianPluginLike $this) {
        return false;
    }

    public static final File filterAndFixPerms(DebianPluginLike $this, File script, Seq replacements, LinuxFileMetaData perms) {
        String filtered = TemplateWriter$.MODULE$.generateScript(script.toURI().toURL(), (Seq<Tuple2<String, String>>)replacements, TemplateWriter$.MODULE$.generateScript$default$3(), TemplateWriter$.MODULE$.generateScript$default$4(), TemplateWriter$.MODULE$.generateScript$default$5());
        IO$.MODULE$.delete(script);
        IO$.MODULE$.write(script, filtered, IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
        chmod$.MODULE$.apply(script, perms.permissions());
        return script;
    }

    public static final File prependAndFixPerms(DebianPluginLike $this, File script, Seq lines, LinuxFileMetaData perms) {
        List old = IO$.MODULE$.readLines(script, IO$.MODULE$.readLines$default$2());
        File x$28 = script;
        Seq x$29 = (Seq)lines.$plus$plus((GenTraversableOnce)old, Seq$.MODULE$.canBuildFrom());
        boolean x$30 = false;
        Charset x$31 = IO$.MODULE$.writeLines$default$3();
        IO$.MODULE$.writeLines(x$28, x$29, x$31, x$30);
        chmod$.MODULE$.apply(script, perms.permissions());
        return script;
    }

    public static final File appendAndFixPerms(DebianPluginLike $this, File script, Seq lines, LinuxFileMetaData perms) {
        File x$32 = script;
        Seq x$33 = lines;
        boolean x$34 = true;
        Charset x$35 = IO$.MODULE$.writeLines$default$3();
        IO$.MODULE$.writeLines(x$32, x$33, x$35, x$34);
        chmod$.MODULE$.apply(script, perms.permissions());
        return script;
    }

    public static final File createFileIfRequired(DebianPluginLike $this, File script, LinuxFileMetaData perms) {
        if (!script.exists()) {
            script.createNewFile();
            chmod$.MODULE$.apply(script, perms.permissions());
        }
        return script;
    }

    public static final void validateUserGroupNames(DebianPluginLike $this, String user, TaskStreams streams) {
        if ($this.UserNamePattern().findFirstIn((CharSequence)user).isEmpty()) {
            streams.log().warn((Function0)new Serializable($this, user){
                public static final long serialVersionUID = 0L;
                private final String user$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"The user or group '").append((Object)this.user$2).append((Object)"' may contain invalid characters for Debian based distributions").toString();
                }
                {
                    this.user$2 = user$2;
                }
            });
        }
        if (user.length() > 32) {
            streams.log().warn((Function0)new Serializable($this, user){
                public static final long serialVersionUID = 0L;
                private final String user$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"The length of '").append((Object)this.user$2).append((Object)"' must be not be greater than 32 characters for Debian based distributions.").toString();
                }
                {
                    this.user$2 = user$2;
                }
            });
        }
    }

    public static Seq scriptMapping(DebianPluginLike $this, String scriptName, Option script, File controlDir) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    File dir;
                    tuple2 = new Tuple2((Object)script, (Object)controlDir);
                    if (tuple2 == null || !package$.MODULE$.richFile(dir = (File)tuple2._2()).$div(scriptName).exists()) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)package$.MODULE$.file(package$.MODULE$.richFile(dir).$div(scriptName).getAbsolutePath())), (Object)scriptName)}));
                    break block3;
                }
                if (tuple2 == null) break block4;
                Option scr = (Option)tuple2._1();
                seq = (Seq)Option$.MODULE$.option2Iterable(scr).toSeq().map((Function1)new Serializable($this, scriptName){
                    public static final long serialVersionUID = 0L;
                    private final String scriptName$1;

                    public final Tuple2<File, String> apply(File x$22) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)x$22), (Object)this.scriptName$1);
                    }
                    {
                        this.scriptName$1 = scriptName$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public static Tuple2 makeChownReplacements(DebianPluginLike $this, Seq mappings, TaskStreams streams) {
        String header = "# Chown definitions created by SBT Native Packager\n";
        Iterable chowns = (Iterable)((TraversableLike)((TraversableLike)mappings.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(LinuxPackageMapping x0$5) {
                LinuxPackageMapping linuxPackageMapping = x0$5;
                if (linuxPackageMapping == null) return true;
                LinuxFileMetaData linuxFileMetaData = linuxPackageMapping.fileData();
                if (linuxFileMetaData == null) return true;
                String string = linuxFileMetaData.user();
                String string2 = linuxFileMetaData.group();
                String string3 = LinuxPlugin$Users$.MODULE$.Root();
                String string4 = string;
                if (string3 == null) {
                    if (string4 != null) {
                        return true;
                    }
                } else if (!string3.equals(string4)) return true;
                String string5 = LinuxPlugin$Users$.MODULE$.Root();
                String string6 = string2;
                if (string5 == null) {
                    if (string6 == null) return false;
                    return true;
                } else {
                    if (!string5.equals(string6)) return true;
                    return false;
                }
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<String, String>, Traversable<Tuple2<File, String>>> apply(LinuxPackageMapping x0$6) {
                LinuxPackageMapping linuxPackageMapping = x0$6;
                if (linuxPackageMapping != null) {
                    Traversable<Tuple2<File, String>> paths = linuxPackageMapping.mappings();
                    LinuxFileMetaData meta = linuxPackageMapping.fileData();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Tuple2((Object)meta.user(), (Object)meta.group())), paths);
                    return tuple2;
                }
                throw new MatchError((Object)linuxPackageMapping);
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<Tuple2<String, String>, Traversable<Tuple2<File, String>>> x$23) {
                return (Tuple2)x$23._1();
            }
        }).map((Function1)new Serializable($this, streams){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DebianPluginLike $outer;
            private final TaskStreams streams$1;

            public final Seq<String> apply(Tuple2<Tuple2<String, String>, Seq<Tuple2<Tuple2<String, String>, Traversable<Tuple2<File, String>>>>> x0$7) {
                Tuple2<Tuple2<String, String>, Seq<Tuple2<Tuple2<String, String>, Traversable<Tuple2<File, String>>>>> tuple2 = x0$7;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Seq pathList = (Seq)tuple2._2();
                    if (tuple22 != null) {
                        String user = (String)tuple22._1();
                        String group = (String)tuple22._2();
                        this.$outer.validateUserGroupNames(user, this.streams$1);
                        this.$outer.validateUserGroupNames(group, this.streams$1);
                        Serializable chown = new Serializable(this, user, group){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DebianPluginLike$.anonfun.15 $outer;
                            private final String user$1;
                            private final String group$1;

                            public final String apply(String path) {
                                return DebianPluginLike$class.chownCmd$1(this.$outer.com$typesafe$sbt$packager$debian$DebianPluginLike$$anonfun$$$outer(), this.user$1, this.group$1, path);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.user$1 = user$1;
                                this.group$1 = group$1;
                            }
                        };
                        Seq seq = (Seq)((TraversableLike)((GenericTraversableTemplate)pathList.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Traversable<Tuple2<File, String>> apply(Tuple2<Tuple2<String, String>, Traversable<Tuple2<File, String>>> x$24) {
                                return (Traversable)x$24._2();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).map((Function1)new Serializable(this, (Function1)chown){
                            public static final long serialVersionUID = 0L;
                            private final Function1 chown$2;

                            public final String apply(Tuple2<File, String> m) {
                                return (String)this.chown$2.apply(m._2());
                            }
                            {
                                this.chown$2 = chown$2;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ DebianPluginLike com$typesafe$sbt$packager$debian$DebianPluginLike$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.streams$1 = streams$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        String string = header;
        String replacement = ((TraversableOnce)chowns.flatten((Function1)Predef$.MODULE$.conforms())).toList().$colon$colon((Object)string).mkString("\n");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)DebianPlugin$.MODULE$.CHOWN_REPLACEMENT()), (Object)replacement);
    }

    public static String archiveFilename(DebianPluginLike $this, String appName, String version, String arch) {
        return new StringBuilder().append((Object)appName).append((Object)"_").append((Object)version).append((Object)"_").append((Object)arch).append((Object)".deb").toString();
    }

    public static String changesFilename(DebianPluginLike $this, String appName, String version, String arch) {
        return new StringBuilder().append((Object)appName).append((Object)"_").append((Object)version).append((Object)"_").append((Object)arch).append((Object)".changes").toString();
    }

    public static final String chownCmd$1(DebianPluginLike $this, String user, String group, String path) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"chown ", ":", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, group, path}));
    }

    public static void $init$(DebianPluginLike $this) {
        $this.com$typesafe$sbt$packager$debian$DebianPluginLike$_setter_$UserNamePattern_$eq(new StringOps(Predef$.MODULE$.augmentString("^[a-z][-a-z0-9_]*$")).r());
    }
}

