/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.CryptoException;
import io.apigee.trireme.core.internal.SignatureAlgorithms;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Crypto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Signature;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class SignImpl
extends ScriptableObject {
    private SignatureAlgorithms.Algorithm algorithm;
    private ArrayList<ByteBuffer> buffers = new ArrayList();

    public String getClassName() {
        return "Sign";
    }

    @JSFunction
    public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Crypto.ensureCryptoService(cx, thisObj);
        String algorithm = ArgUtils.stringArg(args, 0);
        SignImpl self = (SignImpl)thisObj;
        self.algorithm = SignatureAlgorithms.get().get(algorithm);
        if (self.algorithm == null) {
            throw Utils.makeError(cx, thisObj, "Invalid signature algorithm " + algorithm);
        }
    }

    @JSFunction
    public static void update(Context cx, Scriptable thisObj, Object[] args, Function func) {
        ArgUtils.ensureArg(args, 0);
        String encoding = ArgUtils.stringArg(args, 1, null);
        ByteBuffer buf = Crypto.convertString(args[0], encoding, cx, thisObj);
        SignImpl self = (SignImpl)thisObj;
        self.buffers.add(buf);
    }

    @JSFunction
    public static Object sign(Context cx, Scriptable thisObj, Object[] args, Function func) {
        byte[] result;
        KeyPair pair;
        Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        String format = ArgUtils.stringArg(args, 1, null);
        SignImpl self = (SignImpl)thisObj;
        ByteArrayInputStream bis = new ByteArrayInputStream(keyBuf.getArray(), keyBuf.getArrayOffset(), keyBuf.getLength());
        try {
            pair = Crypto.getCryptoService().readKeyPair(self.algorithm.getKeyFormat(), bis, null);
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, thisObj, "error reading key: " + ioe);
        }
        catch (CryptoException ce) {
            throw Utils.makeError(cx, thisObj, "invalid key: " + ce);
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException ignore) {}
        }
        try {
            Signature signer = Signature.getInstance(self.algorithm.getJavaName());
            signer.initSign(pair.getPrivate());
            for (ByteBuffer bb : self.buffers) {
                signer.update(bb);
            }
            result = signer.sign();
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, thisObj, "error signing: " + gse);
        }
        Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, thisObj, result);
        if (format == null) {
            return buf;
        }
        return buf.getString(format);
    }
}

