/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.util.HashSet;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.JavaScriptException;

public class RhinoContextFactory
extends ContextFactory {
    private static final int DEFAULT_INSTRUCTION_THRESHOLD = 100000;
    private static final ClassShutter DEFAULT_SHUTTER = new OpaqueClassShutter();
    private int jsVersion = 180;
    private int optLevel = 9;
    private boolean countOperations;
    private ClassShutter extraClassShutter;

    protected Context makeContext() {
        Context c = super.makeContext();
        c.setLanguageVersion(this.jsVersion);
        c.setOptimizationLevel(this.optLevel);
        c.setGenerateObserverCount(this.countOperations);
        if (this.countOperations) {
            c.setInstructionObserverThreshold(100000);
        }
        if (this.extraClassShutter == null) {
            c.setClassShutter(DEFAULT_SHUTTER);
        } else {
            c.setClassShutter((ClassShutter)new NestedClassShutter(DEFAULT_SHUTTER, this.extraClassShutter));
        }
        return c;
    }

    protected void observeInstructionCount(Context cx, int count) {
        Object timeoutObj = cx.getThreadLocal((Object)"_tickTimeout");
        if (timeoutObj == null) {
            return;
        }
        if (System.currentTimeMillis() > (Long)timeoutObj) {
            throw new JavaScriptException((Object)"Script timed out");
        }
    }

    protected boolean hasFeature(Context cx, int i) {
        switch (i) {
            case 10: {
                return true;
            }
        }
        return super.hasFeature(cx, i);
    }

    public int getJsVersion() {
        return this.jsVersion;
    }

    public void setJsVersion(int jsVersion) {
        this.jsVersion = jsVersion;
    }

    public int getOptLevel() {
        return this.optLevel;
    }

    public void setOptLevel(int optLevel) {
        this.optLevel = optLevel;
    }

    public boolean isCountOperations() {
        return this.countOperations;
    }

    public void setCountOperations(boolean countOperations) {
        this.countOperations = countOperations;
    }

    public ClassShutter getExtraClassShutter() {
        return this.extraClassShutter;
    }

    public void setExtraClassShutter(ClassShutter extraClassShutter) {
        this.extraClassShutter = extraClassShutter;
    }

    private static final class NestedClassShutter
    implements ClassShutter {
        private final ClassShutter cs1;
        private final ClassShutter cs2;

        NestedClassShutter(ClassShutter cs1, ClassShutter cs2) {
            this.cs1 = cs1;
            this.cs2 = cs2;
        }

        public boolean visibleToScripts(String s) {
            if (this.cs1.visibleToScripts(s)) {
                return true;
            }
            return this.cs2.visibleToScripts(s);
        }
    }

    private static final class OpaqueClassShutter
    implements ClassShutter {
        private final HashSet<String> whitelist = new HashSet();

        OpaqueClassShutter() {
            this.whitelist.add("org.mozilla.javascript.EcmaError");
            this.whitelist.add("org.mozilla.javascript.EvaluatorException");
            this.whitelist.add("org.mozilla.javascript.JavaScriptException");
            this.whitelist.add("org.mozilla.javascript.RhinoException");
            this.whitelist.add("java.lang.Byte");
            this.whitelist.add("java.lang.Character");
            this.whitelist.add("java.lang.Class");
            this.whitelist.add("java.lang.Double");
            this.whitelist.add("java.lang.Exception");
            this.whitelist.add("java.lang.Float");
            this.whitelist.add("java.lang.Integer");
            this.whitelist.add("java.lang.Package");
            this.whitelist.add("java.lang.Long");
            this.whitelist.add("java.lang.Object");
            this.whitelist.add("java.lang.Short");
            this.whitelist.add("java.lang.Number");
            this.whitelist.add("java.lang.String");
            this.whitelist.add("java.lang.Throwable");
            this.whitelist.add("java.lang.Void");
        }

        public boolean visibleToScripts(String s) {
            return this.whitelist.contains(s);
        }
    }
}

