/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeScriptModule;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.JavaVersion;
import io.apigee.trireme.core.spi.NodeImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRegistry {
    private static final String CODE_PREFIX = "(function (exports, require, module, __filename, __dirname) {";
    private static final String CODE_POSTFIX = "});";
    private final HashMap<String, NodeModule> modules = new HashMap();
    private final HashMap<String, InternalNodeModule> internalModules = new HashMap();
    private final HashMap<String, Script> compiledModules = new HashMap();
    private final NodeImplementation implementation;
    private Script mainScript;
    private boolean loaded;

    public ModuleRegistry(NodeImplementation impl) {
        this.implementation = impl;
    }

    public NodeImplementation getImplementation() {
        return this.implementation;
    }

    public synchronized void load(Context cx) {
        if (this.loaded) {
            return;
        }
        ServiceLoader<NodeModule> loader = ServiceLoader.load(NodeModule.class);
        for (NodeModule mod : loader) {
            this.addNativeModule(mod);
        }
        if (JavaVersion.get().hasAsyncFileIO().booleanValue()) {
            this.loadModuleByName("io.apigee.trireme.core.modules.AsyncFilesystem");
        } else {
            this.loadModuleByName("io.apigee.trireme.core.modules.Filesystem");
        }
        ServiceLoader<NodeScriptModule> scriptLoader = ServiceLoader.load(NodeScriptModule.class);
        for (NodeScriptModule nodeScriptModule : scriptLoader) {
            for (String[] src : nodeScriptModule.getScriptSources()) {
                if (src.length != 2) {
                    throw new AssertionError((Object)("Script module " + nodeScriptModule.getClass().getName() + " returned script source arrays that do not have two elements"));
                }
                this.compileAndAdd(cx, nodeScriptModule, src[0], src[1]);
            }
        }
        this.loadMainScript(this.implementation.getMainScriptClass());
        for (String[] builtin : this.implementation.getBuiltInModules()) {
            this.addCompiledModule(builtin[0], builtin[1]);
        }
        for (Class clazz : this.implementation.getNativeModules()) {
            this.loadModuleByClass(clazz);
        }
        this.loaded = true;
    }

    private void compileAndAdd(Context cx, Object impl, String name, String path) {
        String scriptSource;
        InputStream is = impl.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new AssertionError((Object)("Script " + path + " cannot be found for module " + name));
        }
        try {
            scriptSource = Utils.readStream(is);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Error reading script " + path + " for module " + name));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
        String finalSource = CODE_PREFIX + scriptSource + CODE_POSTFIX;
        Script compiled = cx.compileString(finalSource, name, 1, null);
        this.compiledModules.put(name, compiled);
    }

    private void addNativeModule(NodeModule mod) {
        if (mod instanceof InternalNodeModule) {
            this.internalModules.put(mod.getModuleName(), (InternalNodeModule)mod);
        } else {
            this.modules.put(mod.getModuleName(), mod);
        }
    }

    private void loadMainScript(String className) {
        try {
            Class<?> klass = Class.forName(className);
            this.mainScript = (Script)klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void loadModuleByName(String className) {
        try {
            Class<?> klass = Class.forName(className);
            this.loadModuleByClass(klass);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void loadModuleByClass(Class<? extends NodeModule> klass) {
        try {
            NodeModule mod = klass.newInstance();
            this.addNativeModule(mod);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void addCompiledModule(String name, String className) {
        try {
            Class<?> cl = Class.forName(className);
            Script script = (Script)cl.newInstance();
            this.compiledModules.put(name, script);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Missing built-in module " + className));
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Error creating Script instance for " + className));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Error creating Script instance for " + className));
        }
    }

    public NodeModule get(String name) {
        return this.modules.get(name);
    }

    public NodeModule getInternal(String name) {
        return this.internalModules.get(name);
    }

    public Script getCompiledModule(String name) {
        return this.compiledModules.get(name);
    }

    public Script getMainScript() {
        return this.mainScript;
    }
}

