/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class CompositeTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;
    private final X509CRL crl;

    public CompositeTrustManager(X509TrustManager tm, X509CRL crl) {
        this.tm = tm;
        this.crl = crl;
    }

    public void checkClientTrusted(X509Certificate[] certs, String s) throws CertificateException {
        this.tm.checkClientTrusted(certs, s);
        this.checkCRL(certs);
    }

    public void checkServerTrusted(X509Certificate[] certs, String s) throws CertificateException {
        this.tm.checkServerTrusted(certs, s);
        this.checkCRL(certs);
    }

    private void checkCRL(X509Certificate[] certs) throws CertificateException {
        for (X509Certificate cert : certs) {
            if (!this.crl.isRevoked(cert)) continue;
            throw new CertificateException("Certificate not trusted per the CRL");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }
}

