/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.Graph;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import akka.util.ByteStringBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.mvc.Codec;
import play.core.j.JavaResults;
import play.libs.Json;
import play.mvc.Results;

public abstract class Comet
extends Results.Chunks<String> {
    private static ByteString initialChunk;
    private Results.Chunks.Out<String> out;
    private String callbackMethod;

    public static Flow<String, ByteString, NotUsed> string(String string2) {
        return Flow.of(String.class).map((Function & Serializable)string -> ByteString.fromString((String)("'" + StringEscapeUtils.escapeEcmaScript((String)string) + "'"))).via(Comet.flow(string2));
    }

    public static Flow<JsonNode, ByteString, NotUsed> json(String string) {
        return Flow.of(JsonNode.class).map((Function & Serializable)jsonNode -> ByteString.fromString((String)Json.stringify((JsonNode)jsonNode))).via(Comet.flow(string));
    }

    public static Flow<ByteString, ByteString, NotUsed> flow(String string) {
        ByteString byteString = ByteString.fromString((String)string);
        return Flow.of(ByteString.class).map((Function & Serializable)byteString2 -> Comet.formatted(byteString, byteString2)).prepend((Graph)Source.single((Object)initialChunk));
    }

    private static ByteString formatted(ByteString byteString, ByteString byteString2) {
        ByteStringBuilder byteStringBuilder = new ByteStringBuilder();
        byteStringBuilder.append(ByteString.fromString((String)"<script type=\"text/javascript\">"));
        byteStringBuilder.append(byteString);
        byteStringBuilder.append(ByteString.fromString((String)"("));
        byteStringBuilder.append(byteString2);
        byteStringBuilder.append(ByteString.fromString((String)");</script>"));
        return byteStringBuilder.result();
    }

    @Deprecated
    public Comet(String string) {
        super(JavaResults.writeString((String)"text/html", (Codec)Codec.javaSupported((String)"utf-8")));
        this.callbackMethod = string;
    }

    @Deprecated
    public void onReady(Results.Chunks.Out<String> out) {
        this.out = out;
        out.write((Object)this.initialBuffer());
        this.onConnected();
    }

    @Deprecated
    protected String initialBuffer() {
        char[] cArray = new char[5120];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    @Deprecated
    public void sendMessage(String string) {
        this.out.write((Object)("<script type=\"text/javascript\">" + this.callbackMethod + "('" + StringEscapeUtils.escapeEcmaScript((String)string) + "');</script>"));
    }

    @Deprecated
    public void sendMessage(JsonNode jsonNode) {
        this.out.write((Object)("<script type=\"text/javascript\">" + this.callbackMethod + "(" + Json.stringify((JsonNode)jsonNode) + ");</script>"));
    }

    @Deprecated
    public abstract void onConnected();

    @Deprecated
    public void onDisconnected(Runnable runnable) {
        this.out.onDisconnected(runnable);
    }

    @Deprecated
    public void close() {
        this.out.close();
    }

    @Deprecated
    public static Comet whenConnected(String string, Consumer<Comet> consumer) {
        return new WhenConnectedComet(string, consumer);
    }

    static {
        char[] cArray = new char[5120];
        Arrays.fill(cArray, ' ');
        initialChunk = ByteString.fromString((String)(new String(cArray) + "<html><body>"));
    }

    static final class WhenConnectedComet
    extends Comet {
        private static final Logger logger = LoggerFactory.getLogger(Comet.class);
        private final Consumer<Comet> callback;

        WhenConnectedComet(String string, Consumer<Comet> consumer) {
            super(string);
            if (consumer == null) {
                throw new NullPointerException("Comet onConnected callback cannot be null");
            }
            this.callback = consumer;
        }

        @Override
        public void onConnected() {
            try {
                this.callback.accept(this);
            }
            catch (Throwable throwable) {
                logger.error("Exception in Comet.onConnected", throwable);
            }
        }
    }
}

