/*
 * Decompiled with CFR 0.152.
 */
package play.inject.guice;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.io.File;
import java.util.Map;
import play.Configuration;
import play.Environment;
import play.Mode;
import play.api.inject.Binding;
import play.api.inject.guice.GuiceableModule;
import play.inject.Injector;
import play.inject.guice.Guiceable;
import play.libs.Scala;

public abstract class GuiceBuilder<Self, Delegate extends play.api.inject.guice.GuiceBuilder<Delegate>> {
    protected Delegate delegate;

    protected GuiceBuilder(Delegate Delegate) {
        this.delegate = Delegate;
    }

    public final Self in(Environment environment) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.in(environment.underlying()));
    }

    public final Self in(File file) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.in(file));
    }

    public final Self in(Mode mode) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.in(play.api.Mode.apply((int)mode.ordinal())));
    }

    public final Self in(ClassLoader classLoader) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.in(classLoader));
    }

    public final Self configure(Configuration configuration) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.configure(configuration.getWrappedConfiguration()));
    }

    public final Self configure(Map<String, Object> map) {
        return this.configure(new Configuration(map));
    }

    public final Self configure(String string, Object object) {
        return this.configure((Map<String, Object>)ImmutableMap.of((Object)string, (Object)object));
    }

    public final Self bindings(GuiceableModule ... guiceableModuleArray) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.bindings(Scala.varargs((Object[])guiceableModuleArray)));
    }

    public final Self bindings(Module ... moduleArray) {
        return this.bindings(Guiceable.modules(moduleArray));
    }

    public final Self bindings(play.api.inject.Module ... moduleArray) {
        return this.bindings(Guiceable.modules(moduleArray));
    }

    public final Self bindings(Binding<?> ... bindingArray) {
        return this.bindings(Guiceable.bindings(bindingArray));
    }

    public final Self overrides(GuiceableModule ... guiceableModuleArray) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.overrides(Scala.varargs((Object[])guiceableModuleArray)));
    }

    public final Self overrides(Module ... moduleArray) {
        return this.overrides(Guiceable.modules(moduleArray));
    }

    public final Self overrides(play.api.inject.Module ... moduleArray) {
        return this.overrides(Guiceable.modules(moduleArray));
    }

    public final Self overrides(Binding<?> ... bindingArray) {
        return this.overrides(Guiceable.bindings(bindingArray));
    }

    public final Self disable(Class<?> ... classArray) {
        return this.newBuilder((play.api.inject.guice.GuiceBuilder)this.delegate.disable(Scala.toSeq((Object[])classArray)));
    }

    public Module applicationModule() {
        return this.delegate.applicationModule();
    }

    public Injector injector() {
        return (Injector)this.delegate.injector().instanceOf(Injector.class);
    }

    protected abstract Self newBuilder(Delegate var1);
}

