/*
 * Decompiled with CFR 0.152.
 */
package play.data;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Validator;
import play.data.DynamicForm;
import play.data.Form;
import play.data.format.Formatters;
import play.i18n.MessagesApi;

@Singleton
public class FormFactory {
    private final MessagesApi messagesApi;
    private final Formatters formatters;
    private final Validator validator;

    @Inject
    public FormFactory(MessagesApi messagesApi, Formatters formatters, Validator validator) {
        this.messagesApi = messagesApi;
        this.formatters = formatters;
        this.validator = validator;
    }

    public DynamicForm form() {
        return new DynamicForm(this.messagesApi, this.formatters, this.validator);
    }

    public <T> Form<T> form(Class<T> clazz) {
        return new Form<T>(clazz, this.messagesApi, this.formatters, this.validator);
    }

    public <T> Form<T> form(String string, Class<T> clazz) {
        return new Form<T>(string, clazz, this.messagesApi, this.formatters, this.validator);
    }

    public <T> Form<T> form(String string, Class<T> clazz, Class<?> clazz2) {
        return new Form<T>(string, clazz, clazz2, this.messagesApi, this.formatters, this.validator);
    }

    public <T> Form<T> form(String string, Class<T> clazz, Class<?> ... classArray) {
        return new Form<T>(string, clazz, classArray, this.messagesApi, this.formatters, this.validator);
    }

    public <T> Form<T> form(Class<T> clazz, Class<?> clazz2) {
        return new Form<T>(null, clazz, clazz2, this.messagesApi, this.formatters, this.validator);
    }

    public <T> Form<T> form(Class<T> clazz, Class<?> ... classArray) {
        return new Form<T>(null, clazz, classArray, this.messagesApi, this.formatters, this.validator);
    }
}

